/*! \file doswrite3.c \brief Test Program 3 */
//###########################################################
///	\code #include "../dos.h" \endcode
///	\par Uebersicht
//###################################################################################
// File: doswrite3.c
//
// 2MB groe Dateien auf den CF schreiben und wieder lesen.
// Jeweils mit unterschiedlichen Puffergren. Zeit messen und anzeigen.
//
// Timerint. reduziert auf 10ms fr hhere Auflsung und besseren Vergleich
// mit ARM7 LPC2136. Der ARM hat natrlich gewonnen ;)
// Dies ist meine am hufigsten benutzte Testroutine.
//
// 22.09.2007 strcpy_P() fr Datei-/Verzeichnisnamen benutzt.
//            Mal sehen wie viel RAM dann brig bleibt.
//
//#########################################################################
// Last change: 22.09.2007
//#########################################################################
// hk@holger-klabunde.de
// http://www.holger-klabunde.de/index.html
//#########################################################################
// Compiler: AVR-GCC 4.1.1
//#########################################################################
//@{
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>

#include "mydefs.h"
#include "../dos.h"
#include "../printf.h"
#include "../serial.h"
#include "../mem-check.h"

#define TEST_FILE_SIZE	(unsigned long)2000 * (unsigned long)1024  // test filesize 2MB

#if defined (__AVR_ATmega644__) || defined (__AVR_ATmega128__)
 #define BUFFER_SIZE	1024
#else
 #define BUFFER_SIZE	128
#endif

void ShowDOSConfig(void);
void StartTimer(void);
void StopTimer(void);
void ReadTestFile(char *name, unsigned char *buffer, U16 bufsize);
void WriteTestFile(char *name, unsigned char *buffer, U16 bufsize);
unsigned char VerifyTestFile(char *name, unsigned char *buffer, U16 bufsize);

//"volatile" fr alle Variablen die in Interrupt's gendert werden
unsigned long volatile countclock;

//###################################################################################
ISR(SIG_OVERFLOW1)        // signal handler for timer1 overflow interrupt
//###################################################################################
{
// TCNT1 = 65535 - ((F_CPU / 64) / 1000 ); //Counter Reload for 1ms
 TCNT1 = 65535 - ((F_CPU / 64) / 100 ); //Counter Reload for 10ms
// TCNT1 = 65535 - ((F_CPU / 64) / 10 ); //Counter Reload for 100ms

 countclock++;
}


//###################################################################################
/* Hauptprogramm */
int main(void)
//###################################################################################
{
 static unsigned char buffer[BUFFER_SIZE];
 static char filename[30];
 unsigned short i;

// DDRA=0; 	//Alles Eingnge
// PORTA=0xFF; 	//Eingnge mit Pullups setzen

#if !defined (__AVR_ATmega161__) && !defined (__AVR_ATmega644__) && !defined (__AVR_ATmega168__)
 SFIOR&=!(1<<PUD); 	//Pullups Enable
#else
#endif
// SFIOR=0; 	//Pullups Enable

#ifdef MMC_CARD_SPI //SD_CARD_SPI too !
 MMC_IO_Init();
#endif

 ser_init();

 sei();              //enable interrupts

 puts("Holgi's Single-FAT DOS-Read-Write-Test3\n");

 RED_ON();
 GREEN_OFF();

 if(GetDriveInformation()!=F_OK) // get drive parameters
  {
   puts("No Flash !");
   RED_ON();
   GREEN_ON();
   while(1);
  }
  
 ShowDOSConfig();

 puts("\nTest directory functions\n");
 strcpy_P(filename,PSTR("dir1")); Chdir(filename);
 strcpy_P(filename,PSTR("dir4")); Remove(filename);
 Chdir("/"); // Back to root
 strcpy_P(filename,PSTR("dir1")); Remove(filename);
 Mkdir(filename);
 Chdir(filename);

 strcpy_P(filename,PSTR("dir2")); Mkdir(filename);
 strcpy_P(filename,PSTR("dir3")); Mkdir(filename);
 Rename(filename,"dir4");
 strcpy_P(filename,PSTR("dir2")); Remove(filename);

 // You should have now:
 // dir1/dir4

 Chdir("/"); // Back to root

 puts("\nDeleting files\n");
 strcpy_P(filename,PSTR("01.bin")); Remove(filename); //Remove last data
 strcpy_P(filename,PSTR("02.bin")); Remove(filename);
 strcpy_P(filename,PSTR("04.bin")); Remove(filename);
 strcpy_P(filename,PSTR("08.bin")); Remove(filename);
 strcpy_P(filename,PSTR("16.bin")); Remove(filename);
 strcpy_P(filename,PSTR("32.bin")); Remove(filename);
 strcpy_P(filename,PSTR("64.bin")); Remove(filename);
 strcpy_P(filename,PSTR("77.bin")); Remove(filename);
 strcpy_P(filename,PSTR("128.bin")); Remove(filename);
#if defined (__AVR_ATmega644__) || defined (__AVR_ATmega128__)
 strcpy_P(filename,PSTR("MAX.bin")); Remove(filename);
#endif

 //Fill the test buffer
 for(i=0; i<BUFFER_SIZE; i++) buffer[i]=(unsigned char)(i);

 puts("\nStart writing files\n");

 strcpy_P(filename,PSTR("01.bin")); WriteTestFile(filename,buffer,1);
 strcpy_P(filename,PSTR("02.bin")); WriteTestFile(filename,buffer,2);
 strcpy_P(filename,PSTR("04.bin")); WriteTestFile(filename,buffer,4);
 strcpy_P(filename,PSTR("08.bin")); WriteTestFile(filename,buffer,8);
 strcpy_P(filename,PSTR("16.bin")); WriteTestFile(filename,buffer,16);
 strcpy_P(filename,PSTR("32.bin")); WriteTestFile(filename,buffer,32);
 strcpy_P(filename,PSTR("64.bin")); WriteTestFile(filename,buffer,64);
 strcpy_P(filename,PSTR("77.bin")); WriteTestFile(filename,buffer,77);
 strcpy_P(filename,PSTR("128.bin")); WriteTestFile(filename,buffer,128);
#if defined (__AVR_ATmega644__) || defined (__AVR_ATmega128__)
 strcpy_P(filename,PSTR("MAX.bin")); WriteTestFile(filename,buffer,BUFFER_SIZE);
#endif

 puts("\nStart reading files\n");

 strcpy_P(filename,PSTR("01.bin")); ReadTestFile(filename,buffer,1);
 strcpy_P(filename,PSTR("02.bin")); ReadTestFile(filename,buffer,2);
 strcpy_P(filename,PSTR("04.bin")); ReadTestFile(filename,buffer,4);
 strcpy_P(filename,PSTR("08.bin")); ReadTestFile(filename,buffer,8);
 strcpy_P(filename,PSTR("16.bin")); ReadTestFile(filename,buffer,16);
 strcpy_P(filename,PSTR("32.bin")); ReadTestFile(filename,buffer,32);
 strcpy_P(filename,PSTR("64.bin")); ReadTestFile(filename,buffer,64);
 strcpy_P(filename,PSTR("77.bin")); ReadTestFile(filename,buffer,77);
 strcpy_P(filename,PSTR("128.bin")); ReadTestFile(filename,buffer,128);
#if defined (__AVR_ATmega644__) || defined (__AVR_ATmega128__)
 strcpy_P(filename,PSTR("MAX.bin")); ReadTestFile(filename,buffer,BUFFER_SIZE);
#endif

 puts("\nVerifying files\n");
 strcpy_P(filename,PSTR("32.bin")); VerifyTestFile(filename,buffer,32);
 strcpy_P(filename,PSTR("64.bin")); VerifyTestFile(filename,buffer,64);
 strcpy_P(filename,PSTR("77.bin")); VerifyTestFile(filename,buffer,77);
 strcpy_P(filename,PSTR("128.bin")); VerifyTestFile(filename,buffer,128);
#if defined (__AVR_ATmega644__) || defined (__AVR_ATmega128__)
 strcpy_P(filename,PSTR("MAX.bin")); VerifyTestFile(filename,buffer,BUFFER_SIZE);
#endif

 puts("Test done.\n");

 GREEN_ON();
 RED_OFF();

 i=get_mem_unused();
 printf("Unused memory: %u\n",i);
 
 for(;;) // loop forever
  {
  }
}

//###################################################################################
void WriteTestFile(char *name, unsigned char *buffer, U16 bufsize)
//###################################################################################
{
 unsigned long i;
 unsigned char result;

 result=Fopen(name,'w');
 if(result==F_OK)
  {
   StartTimer();
   for(i=0; i<TEST_FILE_SIZE; i+=bufsize)
    {
     if(Fwrite(buffer,bufsize)!=bufsize) result=F_ERROR;
     if(result==F_ERROR) break;
    }
   Fclose();
   printf("% 3u",bufsize);
   StopTimer();
  }
}

//###################################################################################
void ReadTestFile(char *name, unsigned char *buffer, U16 bufsize)
//###################################################################################
{
 unsigned long i;
 unsigned char result;

 result=Fopen(name,'r');
 if(result==F_OK)
  {
   StartTimer();
   for(i=0; i<TEST_FILE_SIZE; i+=bufsize)
    {
     if(Fread(buffer,bufsize)!=bufsize) result=F_ERROR;
     if(result==F_ERROR) break;
    }
   Fclose();
   printf("% 3u",bufsize);
   StopTimer();
  }
}

//###################################################################################
unsigned char VerifyTestFile(char *name, unsigned char *buffer, U16 bufsize)
//###################################################################################
{
 unsigned long i, k;
 unsigned char result;

 result=Fopen(name,'r');
 if(result==F_OK)
  {
   for(i=0; i<TEST_FILE_SIZE; i+=bufsize)
    {
     if(Fread(buffer,bufsize)!=bufsize) result=F_ERROR;
     if(result==F_ERROR) break;

     //Verify buffer
     for(k=0; k<bufsize; k++)
      {
       if(buffer[k] != (unsigned char)(k))
        { 
         printf("Verify Error at 0x%08lX\n", i+k);
         result=F_ERROR;
         break;
        }
      }

     if(result==F_ERROR) break;
    }
   Fclose();

   if(result!=F_ERROR) printf("%s verify ok !\n", name);
   else printf("%s verify NOT ok !\n", name);
  }

 return result;
}

//###################################################################################
void StartTimer(void)
//###################################################################################
{
 countclock=0;
//Timer1 Configuration
// TCNT1 = 65535 - ((F_CPU / 64) / 1000 ); //Counter Reload for 1ms
 TCNT1 = 65535 - ((F_CPU / 64) / 100 ); //Counter Reload for 10ms
// TCNT1 = 65535 - ((F_CPU / 64) / 10 ); //Counter Reload for 100ms

 TCCR1A=0; 
 TCCR1B=((1<<CS11) | (1<<CS10) ); // prescaler 1/64

#if defined (__AVR_ATmega644__) || defined (__AVR_ATmega168__)
 TIMSK1|=(1<<TOIE1);   // enable timer1 int
#else
 TIMSK|=(1<<TOIE1);   // enable timer1 int
#endif
}

//###################################################################################
void StopTimer(void)
//###################################################################################
{
 unsigned long tmp1,tmp2;
 float kBps;

#if defined (__AVR_ATmega644__) || defined (__AVR_ATmega168__)
 TIMSK1 &= ~(1<<TOIE1);   // disable timer1 int
#else
 TIMSK &= ~(1<<TOIE1);   // disable timer1 int
#endif

 tmp1 = countclock / 100; // timer ticks per count is 10ms, this is the seconds part
 tmp2 = countclock % 100; // timer tick counts below 1s 
 printf(" % 3lu.%02lus ",tmp1,tmp2);

 // We have to use float here to avoid rounding
 kBps = (float)TEST_FILE_SIZE / (float)countclock; //Bytes per 0.01 seconds
 kBps *= 1000.0; //Bytes per 10 seconds to get xxx.x values
 kBps /= 1024.0; // kiloBytes per 10 seconds
 tmp1 = (unsigned int)(kBps / 10.0);
 tmp2 = (unsigned int)kBps % 10;
 printf("% 3lu.%lukB/s\n",tmp1,tmp2);
}

//###################################################################################
void ShowDOSConfig(void)
//###################################################################################
{
 puts("Using ");
#ifdef USE_FAT12
 puts("FAT12 ");
#endif

#ifdef USE_FAT16
 puts("FAT16 ");
#endif

#ifdef USE_FAT32
 puts("FAT32 ");
#endif
 puts("\n");

#ifdef USE_FATBUFFER
 puts("\nUsing FAT Buffer\n");
#else
 puts("\nNo FAT Buffer\n");
#endif

#ifdef COMPACTFLASH_CARD
 puts("CF Card\n");
#endif
#ifdef MMC_CARD_SPI //SD_CARD_SPI too !
 puts("MMC/SD Card\n");
#endif

#ifdef STANDARD_SPI_WRITE  // No optimizations   
 puts("STANDARD_SPI_WRITE ");
#endif
#ifdef FAST_SPI_WRITE      // Optimizations
 puts("FAST_SPI_WRITE ");
#endif
#ifdef HYPER_SPI_WRITE      // Best Optimizations
 puts("HYPER_SPI_WRITE ");
#endif
#ifdef STANDARD_SPI_READ  // No optimizations   
 puts("STANDARD_SPI_READ\n");
#endif
#ifdef FAST_SPI_READ      // Optimizations
 puts("FAST_SPI_READ\n");
#endif
#ifdef HYPER_SPI_READ      // Best Optimizations
 puts("HYPER_SPI_READ\n");
#endif
#ifdef BUSY_BEFORE_COMMAND
 puts("BUSY_BEFORE_COMMAND\n");
#endif


#ifdef FWRITE_SMALL_BUFFERS
 puts("FWRITE_SMALL_BUFFERS\n");
#endif
#ifdef FREAD_SMALL_BUFFERS
 puts("FREAD_SMALL_BUFFERS\n");
#endif

 printf("F_CPU %lu\n",F_CPU);
}

//@}
