/*! \file freeseek.c \brief Fseek Test Program 2 */
//###########################################################
///	\code #include "../dos.h" \endcode
///	\par Uebersicht
//###################################################################################
// 
// Testroutinen fr die Fseek(),Fwrite(),Fread() Funktionen
//
//#########################################################################
// Last change: 01.10.2007
//#########################################################################
// hk@holger-klabunde.de
// http://www.holger-klabunde.de/index.html
//#########################################################################
// Compiler: AVR-GCC 4.1.1
//#########################################################################
//@{
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <string.h>
#include <stdlib.h>

#include "mydefs.h"
#include "../dos.h"
#include "../printf.h"
#include "../serial.h"
#include "../mem-check.h"

#define TEST_FILE_SIZE	(unsigned long)128 * (unsigned long)1024  // test filesize 128kB

#define BUFFER_SIZE	128

void WriteTestFile(char *name, unsigned char *buffer, U16 bufsize);
unsigned char VerifyTestFile(char *name, unsigned char *buffer, U16 bufsize);

//"volatile" fr alle Variablen die in Interrupt's gendert werden
unsigned long volatile countclock;

//###################################################################################
ISR(SIG_OVERFLOW1)        // signal handler for timer1 overflow interrupt
//###################################################################################
{
// TCNT1 = 65535 - ((F_CPU / 64) / 1000 ); //Counter Reload for 1ms
 TCNT1 = 65535 - ((F_CPU / 64) / 100 ); //Counter Reload for 10ms
// TCNT1 = 65535 - ((F_CPU / 64) / 10 ); //Counter Reload for 100ms

 countclock++;
}


//###################################################################################
/* Hauptprogramm */
int main(void)
//###################################################################################
{
 static unsigned char buffer[BUFFER_SIZE];
 static char filename[12];
 unsigned short i;
 unsigned char result;

// DDRA=0; 	//Alles Eingnge
// PORTA=0xFF; 	//Eingnge mit Pullups setzen

#if !defined (__AVR_ATmega161__) && !defined (__AVR_ATmega644__) && !defined (__AVR_ATmega168__)
 SFIOR&=!(1<<PUD); 	//Pullups Enable
#else
#endif
// SFIOR=0; 	//Pullups Enable

#ifdef MMC_CARD_SPI //SD_CARD_SPI too !
 MMC_IO_Init();
#endif

 ser_init();

 sei();              //enable interrupts

 puts("Holgi's Single-FAT DOS-Fseek-Test2\n");

 RED_ON();
 GREEN_OFF();

 if(GetDriveInformation()!=F_OK) // get drive parameters
  {
   puts("No Flash !");
   RED_ON();
   GREEN_ON();
   while(1);
  }
  
 puts("\nDeleting files\n");
 strcpy_P(filename,PSTR("128.bin"));
 Remove(filename); //Remove last data

 //Fill the test buffer
 for(i=0; i<BUFFER_SIZE; i++) buffer[i]=0;

 puts("\nStart writing files\n");
 // Write file with all bytes zero
 WriteTestFile(filename,buffer,128);

 puts("\nVerifying files\n");
 VerifyTestFile(filename,buffer,128);

 puts("\nStart Fseek() Tests\n");

 result=Fopen(filename,'w');
 if(result==F_OK)
  {
   for(i=0; i<BUFFER_SIZE; i++) buffer[i]='A';

   Fseek(0,SEEK_SET); // insert BUFFER_SIZE 'A's at beginning of file
   if(Fwrite(buffer,BUFFER_SIZE) != BUFFER_SIZE) result=F_ERROR;
   if(result==F_ERROR) printf("Err 'A'\n");

   for(i=0; i<BUFFER_SIZE; i++) buffer[i]='B';

   Fseek(BytesPerCluster,SEEK_SET); // insert BUFFER_SIZE 'B's at beginning of file + one cluster
   if(Fwrite(buffer,BUFFER_SIZE) != BUFFER_SIZE) result=F_ERROR;
   if(result==F_ERROR) printf("Err 'B'\n");


   Fseek(0,SEEK_SET); // insert BUFFER_SIZE 'C's at beginning of file + one cluster
                      // Overwrite the 'B's

   for(i=0; i<BytesPerCluster; i++)
    {
     Fread(buffer,1);
    }

   for(i=0; i<BUFFER_SIZE; i++) buffer[i]='C';
   if(Fwrite(buffer,BUFFER_SIZE) != BUFFER_SIZE) result=F_ERROR;
   if(result==F_ERROR) printf("Err 'C'\n");

   Fclose();
  }

 puts("Tests done.\n");

 GREEN_ON();
 RED_OFF();

 i=get_mem_unused();
 printf("Unused memory: %u\n",i);
 
 for(;;) // loop forever
  {
  }
}

//###################################################################################
void WriteTestFile(char *name, unsigned char *buffer, U16 bufsize)
//###################################################################################
{
 unsigned long i;
 unsigned char result;

 result=Fopen(name,'w');
 if(result==F_OK)
  {
   for(i=0; i<TEST_FILE_SIZE; i+=bufsize)
    {
     if(Fwrite(buffer,bufsize)!=bufsize) result=F_ERROR;
     if(result==F_ERROR) break;
    }
   Fclose();
   printf("% 3u",bufsize);
  }
}

//###################################################################################
unsigned char VerifyTestFile(char *name, unsigned char *buffer, U16 bufsize)
//###################################################################################
{
 unsigned long i, k;
 unsigned char result;

 result=Fopen(name,'r');
 if(result==F_OK)
  {
   for(i=0; i<TEST_FILE_SIZE; i+=bufsize)
    {
     if(Fread(buffer,bufsize)!=bufsize) result=F_ERROR;
     if(result==F_ERROR) break;

     //Verify buffer
     for(k=0; k<bufsize; k++)
      {
       if(buffer[k] != 0)
        { 
         printf("Verify Error at 0x%08lX\n", i+k);
         result=F_ERROR;
         break;
        }
      }

     if(result==F_ERROR) break;
    }
   Fclose();

   if(result!=F_ERROR) printf("%s verify ok !\n", name);
   else printf("%s verify NOT ok !\n", name);
  }

 return result;
}

//@}
