//#########################################################################
// File: killcard.c
//
// Lscht die gesamte CF/MMC/SD
// Danach ist NICHTS mehr drauf. Alles weg. Keine Partitionstabelle
// kein Bootsektor, kein FAT. Alle Sektoren werden mit Nullen beschrieben.
// Sie muss formatiert werden. Wenn dein Kartenleser die Karte nicht mehr
// lesen will knnte dieses Programm helfen ;)
//
//
// This program erases ALL data on the card. All sectors will be filled
// with zeroes. Partitiontable, bootsector and fat all will be erased.
// You have to format the card after running this program !
//
//#########################################################################
// Last change: 23.09.2006
//#########################################################################
// hk@holger-klabunde.de
// http://www.holger-klabunde.de/index.html
//#########################################################################
// Compiler: AVR-GCC 3.4.5
//#########################################################################
#include <avr/io.h>
#include <avr/interrupt.h>

#include <stdarg.h>
#include <string.h>
#include <stdlib.h>

#include "mydefs.h"
#include "protos.h"
#include "../dos.h"
#include "../lcd.h"
#include "../serial.h"
#include "../printf.h"

//"volatile" fr alle Variablen die in Interrupt's gendert werden
unsigned long volatile countclock;

//###################################################################################
SIGNAL(SIG_OVERFLOW1)        // signal handler for timer1 overflow interrupt
//###################################################################################
{
// TCNT1 = 65535 - ((F_CPU / 64) / 1000 ); //Counter Reload for 1ms
 TCNT1 = 65535 - ((F_CPU / 64) / 10 ); //Counter Reload for 100ms

 countclock++;
}

//###################################################################################
/* Hauptprogramm */
int main(void)
//###################################################################################
{
 unsigned long tmp1,tmp2;
 float kBps;

 DDRC=0xFF;  	// set io-pins on PortC
 PORTC=0; 	//LCD-Datenbus

 DDRD=0xF2;  	// set io-pins on PortD
 PORTD=0x02; 	//LCD-Steuersignale siehe lcd.h

 DDRA=0; 	//Alles Eingnge
 PORTA=0xFF; 	//Eingnge mit Pullups setzen

 SFIOR&=!(1<<PUD); 	//Pullups Enable
// SFIOR=0; 	//Pullups Enable

#ifdef MMC_CARD_SPI //SD_CARD_SPI too !
 MMC_IO_Init();
#endif

 ser_init();
 LCDInit();
 LCDCls();
 
 sei();              //enable interrupts

 IdentifyMedia(); //LaufwerksInformationen holen

 int i;
 unsigned long sector;

 RED_ON();
 GREEN_OFF();

 for(i=0; i<BYTE_PER_SEC; i++) iob[i]=0; //fill write buffer with zeroes

 countclock=0;
//Timer1 Configuration
// TCNT1 = 65535 - ((F_CPU / 64) / 1000 ); //Counter Reload for 1ms
 TCNT1 = 65535 - ((F_CPU / 64) / 10 ); //Counter Reload for 100ms

 TCCR1A=0; 
 TCCR1B=((1<<CS11) | (1<<CS10) ); // prescaler 1/64
 TIMSK|=(1<<TOIE1);   // enable timer1 int

 printf("Kill Card Start\n");

// for(sector=0; sector<=maxsect; sector++) //delete the whole card
 for(sector=0; sector<=100; sector++) //for deleting MBR,FAT,Bootsector
  {
//   if(sector%64==0) { LCDPos(1,1); printf("%lu\n",sector); }
   WriteSector(sector,iob);
  }

 TIMSK &= ~(1<<TOIE1);   // disable timer1 int
 GREEN_ON();
 RED_OFF();

 LCDPos(1,1); 
 printf("Sectors written %lu\n",maxsect);

 LCDPos(2,1); //Program running time
 tmp1 = countclock / 10;
 tmp2 = countclock % 10;
 printf("%lu.%lus\n",tmp1,tmp2);

 LCDPos(2,10);
 // We have to use float here to avoid rounding
 kBps = (float)(maxsect*BYTE_PER_SEC) / (float)countclock; //Bytes per 0.1 seconds
 kBps *= 100.0; //Bytes per 10 seconds to get xxx.x values
 kBps /= 1024.0; // kiloBytes per 10 seconds
 tmp1 = (unsigned int)(kBps / 10.0);
 tmp2 = (unsigned int)kBps % 10;
 printf("%lu.%lukB/s\n",tmp1,tmp2);
 
 
 for(;;) // loop forever
  {
  }
}

