//#########################################################################
// File: MYDEFS.H
//
//
//#########################################################################
// Last change: 25.07.2005
//#########################################################################
// Compiler: AVR-GCC 3.4.3
//#########################################################################

#ifndef __MYDEFS_H
#define __MYDEFS_H


#define UART_BAUD_RATE	19200

#define T1_PRESCALER	8
#define T1_TICKS   	F_CPU / ( T1_PRESCALER * 65536 )	
#define T1_ONESECOND    T1_TICKS

#define NOP asm volatile ("nop" ::)
//WinAVR 3.4.3 setzt die Bitsetzbefehle sbi(),cbi() ins Assembler-Listing fr diese
//beiden #defines ein ! Also kein Grund Inline Assembler zu benutzen.
#define sbi(portn, bitn) ((portn)|=(1<<(bitn)))
#define cbi(portn, bitn) ((portn)&=~(1<<(bitn)))
//#define sbi(portn, bitn) asm volatile("sbi %0, %1" : : "I" (_SFR_IO_ADDR(portn)), "I" ((uint8_t)(bitn)))
//#define cbi(portn, bitn) asm volatile("cbi %0, %1" : : "I" (_SFR_IO_ADDR(portn)), "I" ((uint8_t)(bitn)))

#if defined (__AVR_ATmega32__) || defined (__AVR_ATmega323__)
 #define RED_PIN	7	//Pin number for red LED
 #define RED_PORT 	PORTD   //Port where red LED is located
 #define RED_DDR 	DDRD    //Port direction register where red LED is located
 #define GREEN_PIN	6	//Pin number for green LED
 #define GREEN_PORT 	PORTD   //Port where green LED is located
 #define GREEN_DDR 	DDRD    //Port direction register where green LED is located
#elif defined (__AVR_ATmega128__) || defined (__AVR_ATmega64__)
 #define RED_PIN	7	//Pin number for red LED
 #define RED_PORT 	PORTE   //Port where red LED is located
 #define RED_DDR 	DDRE    //Port direction register where red LED is located
 #define GREEN_PIN	6	//Pin number for green LED
 #define GREEN_PORT 	PORTE   //Port where green LED is located
 #define GREEN_DDR 	DDRE    //Port direction register where green LED is located
#else
#  error "processor type not defined in mydefs.h"
#endif

//Die beiden LED's
#define RED_ON() { sbi(RED_DDR,RED_PIN); cbi(RED_PORT,RED_PIN); }
#define RED_OFF() { sbi(RED_DDR,RED_PIN); sbi(RED_PORT,RED_PIN); }

#define GREEN_ON() { sbi(GREEN_DDR,GREEN_PIN); cbi(GREEN_PORT,GREEN_PIN); }
#define GREEN_OFF() { sbi(GREEN_DDR,GREEN_PIN); sbi(GREEN_PORT,GREEN_PIN); }


//#define MODE	bit_is_set(PINA,PA0)

#endif //__MYDEFS_H
