//************************************************************************
// Bitmap.c
//
// Bitmaps aus dem Flash an beliebige Position zeichnen
//
// Der Nullpunkt der Anzeige ist links oben
//
// hk@holger-klabunde.de
// http://www.holger-klabunde.de
// 31.07.2005
// Compiler AVR-GCC 3.4.3
//************************************************************************
#include <avr/pgmspace.h>

#include "protos.h"
#include "t6963.h"

//##########################################################
void LoadBitmap(unsigned const char *bitmap,unsigned char xpos , unsigned char ypos, unsigned char width, unsigned char height)
{
 unsigned char bwidth,i,j,k,yp,xp;
 unsigned char by,mask;
 unsigned int xend;     //xpos + width kann grer als 255 werden

 xend=(unsigned int)xpos + (unsigned int)width;
 if(xend>LCD_WIDTH) xend=LCD_WIDTH; //Bitmap abschneiden wenn auerhalb des Displays
 
 bwidth=width/8; //Anzahl Bytes horizontal
 if((width%8)!=0) bwidth++; //Bei Rest noch ein Byte mehr

 yp=ypos;
 for(i=0; i<height; i++) //ber die gesamte Hhe
  {
   xp=xpos; //Zum Beginn der Zeile

   for(j=0; j<bwidth; j++) //ber die gesamte Breite in Bytes
    {
     by=pgm_read_byte(bitmap);

#ifdef PIXPERBYTE_8
     if((xp % 8 ==0) && (xp < LCD_WIDTH-8)) //Die schnelle Methode
      {
         SetPixel(xp,yp,0);
         WriteData1(by,0xC0); //write 8 pixel with one command
         xp+=8;
      }
     else //Die langsame Methode
      {
#endif //#ifdef PIXPERBYTE_8
       mask=0x80;         //Fngt bei MSB an

       for(k=0; k<8; k++) //ber ein Byte
        {
          //Nur vorhandene und keine Fllpixel,-bytes zeichnen
          if(xp < (unsigned char)xend)
          {
           SetPixel(xp,yp,(by & mask) );
           xp++; 
          }                               

         mask>>=1; //Nchstes Bit
        }//for k

#ifdef PIXPERBYTE_8
      }//else if((xp % 8 ==0) && (xp <.....
#endif

     bitmap++;
    } //for j

   yp++; //Nchste Zeile
  } //for i
}

