//#################################################################
//fontsoft.c
//
//Text mit Software Fonts schreiben
//Nachteil: wesentlich langsamer als der interne Font des T6963 
//Vorteil: Auf einen Pixel genau plazierbar !
//
//Bisher fr Fonts bis 8 Pixel Breite und bis zu 16 Pixel Hhe
//Die Zeichenstze der Fonts sind nicht alle gleich !
//
//Die Fonts ohne xxxfv am Ende enthalten auch Zeichen unter 0x20
//Herzchen, Smiley usw
//
// hk@holger-klabunde.de
// http://www.holger-klabunde.de
// 31.07.2005
// Compiler AVR-GCC 3.4.3
//#################################################################
#include <avr/pgmspace.h>
#include "protos.h"
#include "T6963.h"

unsigned char fontwidth,fontheight;   //Breite,Hhe in Pixeln
unsigned const char *font;

//Namensgebung der Fonts: f[Hhe]x[Breite]
extern prog_uchar f8x6[];
extern prog_uchar f8x8a[];
extern prog_uchar f8x8b[];
extern prog_uchar f16x8a[];
extern prog_uchar f16x8b[];
extern prog_uchar f16x8c[];

extern prog_uchar f6x4fv[]; 
extern prog_uchar f6x5fv[]; 
extern prog_uchar f8x6fv[]; 
extern prog_uchar f8x8fv[]; 

//########################################################################
void SetFont(unsigned char num)
//Die Zuordnung mte mal nach Gre umsortiert werden
//########################################################################
{
 switch(num)
  {
   case 1: fontwidth=6; fontheight=8; font=f8x6; break;
   case 2: fontwidth=8; fontheight=8; font=f8x8a; break;
   case 3: fontwidth=8; fontheight=8; font=f8x8b; break;
   case 4: fontwidth=8; fontheight=16; font=f16x8a; break;
   case 5: fontwidth=8; fontheight=16; font=f16x8b; break;
   case 6: fontwidth=8; fontheight=16; font=f16x8c; break;
   case 7: fontwidth=4; fontheight=6; font=f6x4fv; break;
   case 8: fontwidth=5; fontheight=6; font=f6x5fv; break;
   case 9: fontwidth=6; fontheight=8; font=f8x6fv; break;
   case 10: fontwidth=8; fontheight=8; font=f8x8fv; break;
   default: fontwidth=0; fontheight=0; break;
  }
}

//########################################################################
//Schreibt ein einzelnes Zeichen an Position x,y
void LCDSoftChar(unsigned char ch, unsigned char xpos, unsigned char ypos)
//########################################################################
{
unsigned char by,mask;
unsigned char i,j;
 
 for(i=0; i<fontwidth; i++) //ber die Breite des Zeichens
  {
   if(fontheight<=8)
    {
     by=pgm_read_byte(&font[ch*fontwidth+i]); //Ein Byte des Zeichens holen
     mask=0x01;               //Bei D0 anfangen

//Bei den kleinen Fonts wie 6x4 knnte man nicht benutzte Bits
//nicht schreiben um die Textzeilen eng bereinander zu plazieren,
//bzw. um angrenzende Grafikbereiche nicht zu lschen.
//Wenn man immer von oben nach unten schreibt geht es aber auch so.
     for(j=0; j<8; j++)
      {
       SetPixel(xpos+i,ypos+j,(by&mask));
       mask<<=1; //Nchstes Bit
      }//for j
    }//if(fontheight==8)
    
   if(fontheight>8 && fontheight<=16)
    {
     by=pgm_read_byte(&font[ch*2*fontwidth+i]); //Ein Byte des Zeichens holen oberer Teil

     mask=0x01;               //Bei D0 anfangen
     for(j=0; j<8; j++)
      {
       SetPixel(xpos+i,ypos+j,(by&mask));
       mask<<=1; //Nchstes Bit
      }//for j

     by=pgm_read_byte(&font[ch*2*fontwidth+i+8]); //Ein Byte des Zeichens holen unterer Teil

     mask=0x01;               //Bei D0 anfangen
     for(j=0; j<8; j++)
      {
       SetPixel(xpos+i,ypos+j+8,(by&mask));
       mask<<=1; //Nchstes Bit
      }//for j
    }//if(fontheight>8....

  }//for i
}

//########################################################################
//Schreibt einen Text an Position x,y
//Mit automatischem Zeilenvorschub falls der Text zu lang war.
//Noch keine Steuerzeichen wie TAB,CR,LF integriert
void LCDSoftText(char *__putstr, unsigned char xpos, unsigned char ypos)
//########################################################################
{
 char __ps;
 unsigned char xp,yp;

 if(fontwidth==0) return; //Kein Font ausgewhlt

 xp=xpos; yp=ypos;
 
 while((__ps = *__putstr))
  {
   __putstr++;
   if (__ps== 0) break;
   LCDSoftChar(__ps,xp,yp);
   xp+=fontwidth; //Nchstes Zeichen
   if(xp>=LCD_WIDTH) { xp=0; yp+=fontheight; } //Nchste Zeile
  }
}

//########################################################################
//Zeigt eine bersicht der im Font enthaltenen Zeichen
void ShowSoftFont(unsigned char num)
//########################################################################
{
 unsigned char i,xp,yp;
 
 ClearScreen();

 xp=0; yp=0;
 SetFont(num);
 
 for(i=0; i<255; i++)
  {
   LCDSoftChar(i,xp,yp);
   xp+=fontwidth; //Nchstes Zeichen
   if(xp>=LCD_WIDTH) { xp=0; yp+=fontheight; } //Nchste Zeile
  }
}
