//************************************************************************
// T6963.H
//
// LCD Gre und Hardwaredefinitionen
//
// hk@holger-klabunde.de
// http://www.holger-klabunde.de
// 31.07.2005
// Compiler AVR-GCC 3.4.3
//************************************************************************
#ifndef t6963_h
#define t6963_h

#define LCD_WIDTH	240  //Display Breite
#define LCD_HEIGHT	64   //Display Hhe

//#define CGRAM_OFFSET  0x02   //CGRAM Startaddress 0x1000 for 240x64
//#define CGRAM_START   0x14   //for 240x64 and 128x128

//#define CGRAM_OFFSET  0x03   //CGRAM Startaddress 0x1800 for 240x128
//#define CGRAM_START   0x1C   //for 240x128

// !!! only use ONE of the definitions below !!!
#define PIXPERBYTE_6 //pin FONT of the display connected to +5V
                      //undef this if you use 8x8 builtin font of display
                
//#define PIXPERBYTE_8  //pin FONT of the display connected to GROUND
                      //undef this if you use 6x8 builtin font of display

#ifdef PIXPERBYTE_6       // 6 bits per character for builtin font
 #define PIXPERBYTE    6  // than also 6 pixel per byte for graphic
#endif

#ifdef PIXPERBYTE_8      // 8 bits per character for builtin font
 #define PIXPERBYTE    8 // than also 8 pixel per byte for graphic
#endif

#define BYTES_PER_ROW   LCD_WIDTH / PIXPERBYTE     // how many bytes per row on screen
#define DISPLAYBYTES    BYTES_PER_ROW * LCD_HEIGHT // how many bytes for a screen

#define T_BASE  0 	//begin of textarea
#define T_END   T_BASE + ( BYTES_PER_ROW * LCD_HEIGHT / 8 ) //end of textarea

#define G_BASE  0x0200            	// base address of first screen
//#define G_BASE  0x0400            	// base address of first screen 240x128 ?
#define G_END  	G_BASE+DISPLAYBYTES-1   // end adress of first screen
#define G_BASE1 G_BASE+DISPLAYBYTES     // base address of 2nd screen
#define G_END1 	G_BASE1+DISPLAYBYTES-1  // end adress of 2nd screen

#define NOP asm volatile ("nop" ::)
//WinAVR 3.4.3 setzt die Bitsetzbefehle sbi(),cbi() ins Assembler-Listing fr diese
//beiden #defines ein ! Also kein Grund Inline Assembler zu benutzen.
#define sbi(portn, bitn) ((portn)|=(1<<(bitn)))
#define cbi(portn, bitn) ((portn)&=~(1<<(bitn)))
//#define sbi(portn, bitn) asm volatile("sbi %0, %1" : : "I" (_SFR_IO_ADDR(portn)), "I" ((uint8_t)(bitn)))
//#define cbi(portn, bitn) asm volatile("cbi %0, %1" : : "I" (_SFR_IO_ADDR(portn)), "I" ((uint8_t)(bitn)))

#if defined (__AVR_ATmega32__) || defined (__AVR_ATmega323__) || defined (__AVR_ATmega644__)
 //PORTC ist der Datenport
 #define INIT_CONTROL_PINS() { DDRD=0xFF; DDRA=0xFF; } //control pins to output

 #define DATA_DIR_IN()  DDRC=0x00; // set io-pins to inputs
 #define DATA_DIR_OUT() DDRC=0xFF; // set io-pins to outputs
 #define READ_DATA()    PINC	  // read PINC, ! NOT ! PORTC
 #define WRITE_DATA(a)  PORTC=(a); // write to data port

 #define WR_ON()  sbi(PORTA,6); //PA6
 #define WR_OFF() cbi(PORTA,6);

 #define RD_ON()  sbi(PORTA,7); //PA7
 #define RD_OFF() cbi(PORTA,7);

 #define CE_ON()  sbi(PORTD,4); //PD4
 #define CE_OFF() cbi(PORTD,4);

 #define CTRL()   sbi(PORTD,5); //PD5 => A0 => C/D = 1
 #define DATA()   cbi(PORTD,5); //       A0 => C/D = 0
#elif defined (__AVR_ATmega128__) || defined (__AVR_ATmega64__)
 #define INIT_CONTROL_PINS() { DDRD=0xFF; DDRF=0xFF; } //control pins to output

 #define DATA_DIR_IN()  DDRB=0x00; // set io-pins to inputs
 #define DATA_DIR_OUT() DDRB=0xFF; // set io-pins to outputs
 #define READ_DATA()    PINB	  // read PIN, ! NOT ! PORT
 #define WRITE_DATA(a)  PORTB=(a); // write to data port

 #define WR_ON()  sbi(PORTF,6);
 #define WR_OFF() cbi(PORTF,6);

 #define RD_ON()  sbi(PORTF,7);
 #define RD_OFF() cbi(PORTF,7);

 #define CE_ON()  sbi(PORTD,5);
 #define CE_OFF() cbi(PORTD,5);

 #define CTRL()   sbi(PORTD,4); //A0 => C/D = 1
 #define DATA()   cbi(PORTD,4); //A0 => C/D = 0
#else
#  error "processor type not defined in t6963.h"
#endif

//Prototypes
extern void WriteData1(unsigned char, unsigned char);
extern void WriteData2(unsigned int, unsigned char);
extern void WriteData(unsigned char dat);
extern void WriteCommand(unsigned char command);
extern unsigned char ReadData(void);
extern void SetPixel(unsigned char xpos, unsigned char ypos, unsigned char mode);
extern unsigned char GetPixel(unsigned char xpos, unsigned char ypos);
extern void SetGBaseLine(unsigned char line);
extern void SetPosition(unsigned char xpos, unsigned char ypos);
extern void DisplayOn(void);
extern void ClearScreen(void);
extern void ClearGScreen(unsigned int begin, unsigned int end);
extern void ClearTextScreen(void);
extern void FillScreen(void);
extern unsigned char ConvertText(unsigned char ch);
extern void LCDText(char *txt, unsigned char xpos, unsigned char ypos);

#endif // t6963_h
