//************************************************************************
// circle.c
//
// Bresenham Algorithmus.
//
// Schnell Kreise zeichen OHNE sin() cos() oder eine Tabelle zu benutzen.
// Der Algorithmus erfordert keine Fliekommaberechnungen.
//
// Der Algorithmus nutzt die Symmetrie des Kreises aus. Pro Durchgang
// knnen 8 Punkte gleichzeitig berechnet werden. Das heisst es wird
// nur 1/8 Kreisbogen (45) berechnet.
//
// Die Kreise sehen glatter aus als die die ich mit sin() cos()
// erzeugt hatte. Die Anzahl zu berechnender Punkte hngt auch
// direkt vom Radius ab. Je kleiner der Radius ist desto schneller
// wird der Kreis berechnet. Die Kreislinie ist immer maximal einen
// Pixel breit.
//
// hk@holger-klabunde.de
// http://www.holger-klabunde.de
// 12.02.2007
// Compiler AVR-GCC 3.4.3
//************************************************************************

#include <avr/io.h>
#include <stdlib.h>

#include "protos.h"
#include "draw.h"

//***************************************************************************************
// Zeichnet einen Kreis auf Position xpos,ypos mit Radius radius
void Circle(unsigned char xpos, unsigned char ypos, unsigned char radius)
//***************************************************************************************
{
  int x,y,d;

  x = 0;
  y = (int)radius-1; // radius ist bei Bresenham der Innenradius
  d = 1 - (int)radius;

  SetPixel((unsigned char)(xpos+x),(unsigned char)(ypos+y),1);
  SetPixel((unsigned char)(xpos-x),(unsigned char)(ypos+y),1);
  SetPixel((unsigned char)(xpos+x),(unsigned char)(ypos-y),1);
  SetPixel((unsigned char)(xpos-x),(unsigned char)(ypos-y),1);
  SetPixel((unsigned char)(xpos+y),(unsigned char)(ypos+x),1);
  SetPixel((unsigned char)(xpos-y),(unsigned char)(ypos+x),1);
  SetPixel((unsigned char)(xpos+y),(unsigned char)(ypos-x),1);
  SetPixel((unsigned char)(xpos-y),(unsigned char)(ypos-x),1);

  while ( y > x )
   {
    if ( d < 0 )
      d += 2 * x + 3;
    else
     {
      d += 2 * (x - y) + 5;
      y--;
     }

    x++;

    SetPixel((unsigned char)(xpos+y),(unsigned char)(ypos+x),1);
    SetPixel((unsigned char)(xpos-y),(unsigned char)(ypos+x),1);
    SetPixel((unsigned char)(xpos+y),(unsigned char)(ypos-x),1);
    SetPixel((unsigned char)(xpos-y),(unsigned char)(ypos-x),1);
    SetPixel((unsigned char)(xpos+x),(unsigned char)(ypos+y),1);
    SetPixel((unsigned char)(xpos+x),(unsigned char)(ypos-y),1);
    SetPixel((unsigned char)(xpos-x),(unsigned char)(ypos+y),1);
    SetPixel((unsigned char)(xpos-x),(unsigned char)(ypos-y),1);
   }
}

//***************************************************************************************
// Zeichnet einen gefllten Kreis auf Position xpos,ypos mit Radius radius
void FillCircle(unsigned char xpos, unsigned char ypos, unsigned char radius)
//***************************************************************************************
{
  int x,y,d;

  x = 0;
  y = (int)radius-1; // radius ist bei Bresenham der Innenradius
  d = 1 - (int)radius;

  DrawLine((unsigned char)(xpos-radius+1),ypos,(unsigned char)(xpos+radius-1),ypos);

  while ( y > x )
   {
    if ( d < 0 )
      d += 2 * x + 3;
    else
     {
      d += 2 * (x - y) + 5;
      y--;
     }

    x++;

    DrawLine((unsigned char)(xpos-x),(unsigned char)(ypos+y),(unsigned char)(xpos+x),(unsigned char)(ypos+y));
    DrawLine((unsigned char)(xpos-x),(unsigned char)(ypos-y),(unsigned char)(xpos+x),(unsigned char)(ypos-y));
    DrawLine((unsigned char)(xpos-y),(unsigned char)(ypos+x),(unsigned char)(xpos+y),(unsigned char)(ypos+x));
    DrawLine((unsigned char)(xpos-y),(unsigned char)(ypos-x),(unsigned char)(xpos+y),(unsigned char)(ypos-x));
   }

/* Nee, die Kreise sind nicht ganz gefllt. Aber immerhin symmetrisch ;)
 sieht ganz witzig aus.
 unsigned char i;
 SetPixel(xpos,ypos,1);
 for(i=2; i<radius; i++) Circle(xpos,ypos,i);
*/
 
/* Neee, is nich gut
   Igendwas stimmt da nicht. Auf der linken Seite sehen die Kreise schei.... aus
   
  int x,y,d;

  x = 0;
  y = (int)radius;
  d = 1 - (int)radius;

  DrawXLineLen((unsigned char)(xpos-radius),(unsigned char)(2*radius),ypos);

  while ( y > x )
   {
    if ( d < 0 )
      d += 2 * x + 3;
    else
     {
      d += 2 * (x - y) + 5;
      y--;
     }

    x++;

    DrawXLineLen((unsigned char)(xpos-x),(unsigned char)(2*x),(unsigned char)(ypos+y));
    DrawXLineLen((unsigned char)(xpos-x),(unsigned char)(2*x),(unsigned char)(ypos-y));
    DrawXLineLen((unsigned char)(xpos-y),(unsigned char)(2*y),(unsigned char)(ypos+x));
    DrawXLineLen((unsigned char)(xpos-y),(unsigned char)(2*y),(unsigned char)(ypos-x));
   }
*/
}
