//************************************************************************
// Datei: main.c
// Hauptprogramm
//
// Demoprogramm um Text und Grafik auf
// T6963 Grafik-LCD-Display anzeigen
// Display: Winstar WG24064A 240x64 Pixel
//
// Erluterungen zu den Funktionen stehen in den entsprechenden
// *.c Dateien.
//
// 
//
// hk@holger-klabunde.de
// http://www.holger-klabunde.de
// 11.02.2007
// Compiler AVR-GCC 3.4.6
//************************************************************************
#include <avr/io.h>
#include <avr/interrupt.h>
#include <stdlib.h>
#include <string.h>

#include "mydefs.h"
#include "protos.h"
#include "draw.h"
#include "T6963.h"
#include "paul.h"
#include "demo.h"
#include "bitmap.h"
#include "../dos.h"
#include "../printf.h"
#include "../serial.h"

//#############################################################
int main(void)
{
 int i;
 

 DisplayOn();

#ifdef MMC_CARD_SPI //SD_CARD_SPI too !
 MMC_IO_Init();
#endif

 ser_init();

 RED_ON();
 GREEN_OFF();

 if(GetDriveInformation()!=F_OK) // get drive parameters
  {
   puts("No Flash!");
   RED_OFF();
   GREEN_ON();
   while(1);
  }

 sei();              // enable interrupts

 Mkdir("bitmaps");   // if you want to save A LOT of screens use a subdirectory !
 Chdir("bitmaps");   // change to bitmaps subdirectory

 ClearScreen();

 SetGCursor(0,0);       //Macht ClearScreen() auch schon !
 DrawLineAbs(239,0,0);  //Die 0 hinten heit letzte Position merken
   Delay1ms(250);
 DrawLineAbs(239,63,0);
   Delay1ms(250);
 DrawLineAbs(0,0,0);    //ergibt ein groes Dreieck
   Delay1ms(250);

 SetGCursor(200,32);
 DrawLineRel(-10,-10,1); //Die 1 hinten heit letzte Position NICHT merken
   Delay1ms(250);
 DrawLineRel(5,-10,1);   //Strahlen zeichnen, alle mit demselben Ausgangspunkt
   Delay1ms(250);
 DrawLineRel(-10,5,1);
   Delay1ms(250);
 DrawLineRel(20,10,1);
   Delay1ms(250);

 SetGCursor(0,55);
 for(i=0; i<9; i++) //Eine merkwrdige Achse zeichnen
  {
   DrawLineRel(0,-5,1); //Strich nach oben, Cursor nicht ndern
   Delay1ms(250);
   DrawLineRel(5,5,1);  //Strich nach rechts unten, Cursor nicht ndern
   Delay1ms(250);
   DrawLineRel(10,-3,0);//Strich nach rechts oben, letzte Position merken 
   Delay1ms(250);
  }
 Delay1ms(3000);
 SaveGraphDisplay("display1.bmp",G_BASE);
 
 ClearScreen();
 Circle(60,32,30);
 Circle(60,32,20);
 Circle(60,32,10);
 Circle(60,32,7);
 Circle(60,32,3);

 FillCircle(140,32,30);
 FillCircle(180,10,10);
 FillCircle(195,10,3);
 FillCircle(200,40,20);
 Delay1ms(3000);
 SaveGraphDisplay("display2.bmp",G_BASE);

 ClearScreen();
 LoadBitmap(paulbmp, 0 , 0, paulWIDTH, paulHEIGHT);   //Bitmap schnell laden
 LoadBitmap(paulbmp, 121 , 0, paulWIDTH, paulHEIGHT); //Bitmap langsam laden
 LoadBitmap(paulbmp, 199 , 32, paulWIDTH, paulHEIGHT); //Bitmap abschneiden
 Delay1ms(3000);

 ClearScreen();
 LoadBitmap(demobmp, 0 , 0, demoWIDTH, demoHEIGHT);   //Bitmap fllt ganzes Display
 Delay1ms(3000);
 SaveGraphDisplay("display3.bmp",G_BASE);

 ClearScreen();
 DrawRect(0,0,LCD_WIDTH,LCD_HEIGHT);     //Ganzen Bildschirm mit 3 Pixel Breite umranden
 DrawRect(1,1,LCD_WIDTH-2,LCD_HEIGHT-2);
 DrawRect(2,2,LCD_WIDTH-4,LCD_HEIGHT-4);
 
 FillRect(5,5,LCD_WIDTH-10,LCD_HEIGHT-10); //Groe Flche fllen, flimmert es ? ;)
 Delay1ms(3000);

 ClearScreen();                     
 DrawRect(0,0,LCD_WIDTH,LCD_HEIGHT);
 DrawLine(0,0,LCD_WIDTH,LCD_HEIGHT); //Schrge Linien zeichnen links nach rechts
 DrawLine(LCD_WIDTH,0,0,LCD_HEIGHT); //und andersrum
 DrawLine(0,0,LCD_WIDTH/2,LCD_HEIGHT); //Schrge Linien zeichnen links nach rechts
 DrawLine(LCD_WIDTH/2,0,0,LCD_HEIGHT); //und andersrum
 DrawLine(LCD_WIDTH/2,0,LCD_WIDTH,LCD_HEIGHT); //Schrge Linien zeichnen links nach rechts
 DrawLine(LCD_WIDTH,0,LCD_WIDTH/2,LCD_HEIGHT); //und andersrum
 SaveGraphDisplay("display4.bmp",G_BASE);
 Delay1ms(3000);

 ClearScreen();
//Hardware Font. Schreiben ist schnell, aber nur grob plazierbar wie auf einem
//LCD-Textdisplay
 LCDText("Interner 8x8 Font",0,0); //Text auf dem Textdisplay
 for(i=1; i<8; i++) LCDText("Hello World",0,i);
 SaveTextDisplay("text1.txt");
 Delay1ms(3000);

 ClearScreen();                     
//Software Fonts. Schreiben ist langsam, dafr auf einen Pixel genau plazierbar
 SetFont(4);
//Umlaute unter Windows hier im DOS-Modus eintippen !
 LCDSoftText("F16x8a SoftFont gjqy",0,0);
 SetFont(5);
 LCDSoftText("F16x8b SoftFont gjqy",0,18);
 SetFont(6);
 LCDSoftText("F16x8c SoftFont gjqy",0,36);
 Delay1ms(3000);
 SaveGraphDisplay("display5.bmp",G_BASE);

 ClearScreen();                     
//Software Fonts. Schreiben ist langsam, dafr auf einen Pixel genau plazierbar
 SetFont(1);
//Umlaute unter Windows hier im DOS-Modus eintippen !
 LCDSoftText("F8x6 SoftFont gjqy",0,0);
 SetFont(2);
 LCDSoftText("F8x8a SoftFont gjqy",0,9);
 SetFont(3);
 LCDSoftText("F8x8b SoftFont gjqy",0,18);
 SetFont(7);
 LCDSoftText("F6x4fv SoftFont gjqy",0,27);
 SetFont(8);
 LCDSoftText("F6x5fv SoftFont gjqy",0,36);
 SetFont(9);
 LCDSoftText("F8x6fv SoftFont gjqy",0,45);
 SetFont(10);
 LCDSoftText("F8x8fv SoftFont gjqy",0,54);
 SaveGraphDisplay("display6.bmp",G_BASE);
 Delay1ms(3000);

//bersicht aller Fonts anzeigen
 for(i=1; i<11; i++)
  {
   ShowSoftFont(i);
   Delay1ms(3000);
  }
 SaveGraphDisplay("display7.bmp",G_BASE);

 RED_ON();  // Start reading bitmaps from flashcard
 GREEN_ON();

 LoadGraphDisplay("display1.bmp",G_BASE);
 Delay1ms(3000);
 LoadGraphDisplay("display2.bmp",G_BASE);
 Delay1ms(3000);
 LoadGraphDisplay("display3.bmp",G_BASE);
 Delay1ms(3000);
 LoadGraphDisplay("display4.bmp",G_BASE);
 Delay1ms(3000);
 LoadGraphDisplay("display5.bmp",G_BASE);
 Delay1ms(3000);
 LoadGraphDisplay("display6.bmp",G_BASE);
 Delay1ms(3000);
 LoadGraphDisplay("display7.bmp",G_BASE);
 Delay1ms(3000);

 RED_OFF();
 GREEN_ON();

//Beginn Endlosschleife
 while(1)
  {

  } //Endlosschleife
}

//###################################################################################
//Nicht sonderlich genau !!
void Delay1ms(unsigned int time)
//###################################################################################
{
 unsigned int i;

 for(i=0; i<time; i++) Delay100us(10);
}

//###################################################################################
//Nicht sonderlich genau !!
//time<=255 !!
void Delay100us(unsigned char time)
//###################################################################################
{
 unsigned char k,l;

 for(k=0; k<time; k++)
  {
   for(l=0; l<40; l++)
    {
     //Ein CPU-Clock = 0.125us bei 8MHz
     NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP;  
     NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP;  
    }
  }
}
