//************************************************************************
// Datei: readbmp.c
//
// Liest eine Bitmap von einer Speicherkarte und schreibt sie in den
// Grafikschirm eines T6963 Displays.
//
// Es wird erwartet das ein komplettes Display in der Bitmap Datei steht.
// Wer kleinere Bitmaps laden mchte muss das hier SELBST ndern.
//
// Man sollte nur Bitmaps laden die mit SaveGraphDisplay() erzeugt wurden.
// Dieses Programm wird mit hoher Wahrscheinlichkeit nicht alle Bitmaps
// lesen knnen die mit diversen Grafikprogrammen erzeugt wurden. Ich erwarte
// dann eine fehlerhafte Darstellung auf dem Display.
//
// Die Bitmap darf nur SW sein. Farbige Bitmaps werden natrlich nicht geladen.
// Obwohl, das ist nicht richtig ;) Sie werden geladen, aber es ist dann Schrott
// auf dem Display.
//
// Die Routinen sind fr ein 240x64 Display ausgelegt.
// 128x64 habe ich nie probiert. Das wird mit dem 6 Bit Modus wohl noch
// ziemlich buggy sein. Im 8 Bit Modus sollte es aber keine Probleme geben.
//
// Das ganze ist noch nicht sonderlich optimiert. Mit ein paar kleinen
// Datenpuffern sollten auch Animationen mit 10 FPS oder mehr mglich sein.
// Mal sehen. 
// 
// hk@holger-klabunde.de
// http://www.holger-klabunde.de
// 11.02.2007
// Compiler AVR-GCC 3.4.6
//************************************************************************
#include <avr/io.h>

#include "mydefs.h"
#include "protos.h"
#include "T6963.h"
#include "bitmap.h"
#include "../dos.h"
#include "../printf.h"
#include "../serial.h"

//#############################################################
// Display loading routine. 
// Returns 0 if failed, >0 if successfull
//
unsigned char LoadGraphDisplay(char *name, unsigned short baseadr)
//#############################################################
{
 unsigned char by,by1,result, fillbytes;
 unsigned char i , j;
 struct bmpheader bmp;
 
 if(baseadr!=G_BASE && baseadr!=G_BASE1) return 0;
 
 if(Fopen(name,F_READ)!=F_OK) return 0;

 // Problem ! BMP's have to use 4 Byte boundarys.
 // So if you have 240 pixels and 8 pixel per byte, this is
 // 30 bytes per row. But it has to be 32 for Win !
 // For 240 pixels and 6 pixel per byte this is 40. OK.
 
 fillbytes= 4 - ( (LCD_WIDTH/8) % 4); //unused bytes at the end of a row of a bitmap

// Read the BMP header and..., ignore it ;)
 result=Fread((unsigned char *)&bmp,sizeof(struct bmpheader));
 if(result != sizeof(struct bmpheader))
  {
   Fclose();
   return 0;
  }
 
 for(i=LCD_HEIGHT; i>0 ; i--)
  {
   // BMP's want to be drawn from down to up !
   WriteData2(baseadr + ((i-1) * BYTES_PER_ROW ) ,0x24); //Setze Startadresse des zu schreibenden Bereiches

#ifdef PIXPERBYTE_6    // than also 6 pixel per byte for graphic
// Problem with LCD_WIDTH = 128 !
// 128/6 is 22 bytes. 21*6 bits plus 2 bits.
// We go some times through this loop repacking 3*8 bits to 4*6 bits,
// but one time repacking 1*8 bits to 1*6 bits + 1*2 bits.
// Next problem BYTES_PER_ROW is 21 !
   j=BYTES_PER_ROW;
   do
    {
     result=Fread(&by,1);
     by1 = by>>2; // upper 6 bits to by1
     WriteData1(by1,0xC0); //data write and increment ADP
     j--;

     if(LCD_WIDTH==128 && j==0) // tricky trick ;) for 22th byte
      {
       by = (by << 4) & 0x3F; // shift left lower two bits and clean upper bits
       WriteData1(by,0xC0); //data write and increment ADP
       break; // the loop
      }

     result=Fread(&by1,1);
     by = (by << 4) & 0x3F; // shift left lower two bits and clean upper bits
     by |= by1 >> 4;        // upper 4 bits from by1 to lower 4 bits of by
     WriteData1(by,0xC0); //data write and increment ADP
     j--;
     
     result=Fread(&by,1);
     by1 &= 0x0F; // delete upper nibble
     by1 <<= 2;
     by1 |= by >> 6;
     WriteData1(by1,0xC0); //data write and increment ADP
     j--;

     by &= 0x3F; // delete upper two bits
     WriteData1(by,0xC0); //data write and increment ADP
     j--;

     if(LCD_WIDTH==128 && j==0) j=1; // tricky trick ;) one more time through the loop for 22th byte !
    }while(j);
#endif   

#ifdef PIXPERBYTE_8    // than also 8 pixel per byte for graphic
   for(j=0; j < BYTES_PER_ROW; j++)
    {
     result=Fread(&by,1);
     WriteData1(by,0xC0); //data write and increment ADP
    } //for j
#endif   
    
   by=0; // read and skip the fillbytes at the end of a row
   for(j=0; j<fillbytes; j++) result=Fread(&by,1);

  }// for i

 Fclose();
 return result;
}
