//************************************************************************
// Datei: savetext.c
//
// Speichert den Textschirm eines T6963 Displays als Textdatei.
//
// Die Routinen sind fr ein 240x64 Display ausgelegt.
// 128x64 habe ich nie probiert. Das wird mit dem 6 Bit Modus wohl noch
// ziemlich buggy sein. Im 8 Bit Modus sollte es keine Probleme geben.
// 
// hk@holger-klabunde.de
// http://www.holger-klabunde.de
// 11.02.2007
// Compiler AVR-GCC 3.4.6
//************************************************************************
#include <avr/io.h>

#include "mydefs.h"
#include "protos.h"
#include "T6963.h"
#include "../dos.h"
#include "../printf.h"
#include "../serial.h"

//#############################################################
// Display saving routine. 
// Returns 0 if failed, >0 if successfull
//
// This routine only saves the Text screen ! Not the text
// AND graphic screen you might see on your display.
//
// Diese Routine speichert nur den Textschirm ! Nicht die
// Mischung aus Text und Grafik die man mglicherweise auf dem
// Display sieht.
//
unsigned char SaveTextDisplay(char *name)
//#############################################################
{
 unsigned char by, result;
 unsigned char i , j;
 
 Remove(name); // overwrite if file exists
 
 if(Fopen(name,F_WRITE)!=F_OK) return 0;

 WriteData2(T_BASE ,0x24); //Setze Startadresse des zu lesenden Bereiches

 for(i=0; i < (LCD_HEIGHT/8); i++)
  {

   for(j=0; j < BYTES_PER_ROW; j++)
    {
     WriteCommand(0xC1); //data read and increment ADP
     by=ReadData();

     by+=0x20;
     
     result=Fwrite(&by,1);
    } //for j

   by='\r';
   result=Fwrite(&by,1);
   by='\n';
   result=Fwrite(&by,1);
    
  }// for i

 Fclose();
 return result;
}
