//************************************************************************
// Datei: main.c
// Hauptprogramm
//
// Schreibt eine Folge von Bildern auf ein T6963 Display.
// Jedes Bild wird auf eine MMC/SD gespeichert und dann
// als Animation abgespielt.
// 
// Bei einem 240x64 Display sind das 240 Einzelbilder !
// Ein harter Test fr mein FAT Dateisystem. Klappt aber ;)
//
// Dieser Test ist fr ein 240x64 Display.
//
// hk@holger-klabunde.de
// http://www.holger-klabunde.de
// 11.02.2007
// Compiler AVR-GCC 3.4.6
//************************************************************************
#include <avr/io.h>
#include <avr/interrupt.h>
#include <stdlib.h>
#include <string.h>

#include "mydefs.h"
#include "protos.h"
#include "T6963.h"
#include "paul.h"
#include "bitmap.h"
#include "../dos.h"
#include "../printf.h"
#include "../serial.h"

//#############################################################
int main(void)
{
 unsigned char i,j,tmp,num2,num1,num0;
 char bmpname [] = {'b','m','p','0','0','0','.','b','m','p'};
 char tmpc [] = {'0','0','0','\0'};

 DisplayOn();

#ifdef MMC_CARD_SPI //SD_CARD_SPI too !
 MMC_IO_Init();
#endif

 ser_init();

 RED_ON();
 GREEN_OFF();

 if(GetDriveInformation()!=F_OK) // get drive parameters
  {
   puts("No Flash!");
   RED_OFF();
   GREEN_ON();
   while(1);
  }

 sei();              // enable interrupts

 Mkdir("bitmaps");   // if you want to save A LOT of screens use a subdirectory !
 Chdir("bitmaps");   // change to bitmaps subdirectory

 ClearScreen();
 LCDText("Load/Save Bitmaps Test1",0,0); //Text auf dem Textdisplay
 LCDText("Holger Klabunde",0,1); //Text auf dem Textdisplay
 Delay1ms(6000);

 ClearScreen();
 LCDText("Saving Bitmaps",0,0); //Text auf dem Textdisplay

// Schreibe Bilder einer Bitmap die pixelweise nach rechts geschoben wird
 for(i=0; i<LCD_WIDTH; i++)
  {
   LoadBitmap(paulbmp, i , 0, paulWIDTH, paulHEIGHT);
   tmp=i;
   num0=(unsigned char)(tmp%10);
   bmpname[5] = (char) (num0 + '0');
   tmpc[2] = bmpname[5];
   tmp /= 10;
   num1=(unsigned char)(tmp%10);
   bmpname[4] = (char) (num1 + '0');
   tmpc[1] = bmpname[4];
   tmp /= 10;
   num2=(unsigned char)(tmp);
   bmpname[3] = (char) (num2 + '0');
   tmpc[0] = bmpname[3];
   LCDText(tmpc,0,1); //Text auf dem Textdisplay
   
   SaveGraphDisplay(bmpname,G_BASE);
  }

 RED_ON();  // Start reading bitmaps from flashcard
 GREEN_ON();

 ClearScreen();
 LCDText("Run animation",0,0); //Text auf dem Textdisplay
 Delay1ms(3000);

 for(i=0; i<LCD_WIDTH; i++)
  {
   tmp=i;
   num0=(unsigned char)(tmp%10);
   bmpname[5] = (char) (num0 + '0');
   tmpc[2] = bmpname[5];
   tmp /= 10;
   num1=(unsigned char)(tmp%10);
   bmpname[4] = (char) (num1 + '0');
   tmpc[1] = bmpname[4];
   tmp /= 10;
   num2=(unsigned char)(tmp);
   bmpname[3] = (char) (num2 + '0');
   tmpc[0] = bmpname[3];
   LCDText(tmpc,0,1); //Text auf dem Textdisplay

   LoadGraphDisplay(bmpname,G_BASE);
  }

 ClearScreen();
 LCDText("One more time",0,0); //Text auf dem Textdisplay
 Delay1ms(3000);

 for(i=0; i<LCD_WIDTH; i++)
  {
   tmp=i;
   num0=(unsigned char)(tmp%10);
   bmpname[5] = (char) (num0 + '0');
   tmpc[2] = bmpname[5];
   tmp /= 10;
   num1=(unsigned char)(tmp%10);
   bmpname[4] = (char) (num1 + '0');
   tmpc[1] = bmpname[4];
   tmp /= 10;
   num2=(unsigned char)(tmp);
   bmpname[3] = (char) (num2 + '0');
   tmpc[0] = bmpname[3];
   LCDText(tmpc,0,1); //Text auf dem Textdisplay

   LoadGraphDisplay(bmpname,G_BASE);
  }

 ClearScreen();
 LCDText("Do you like scrolling ?",0,0); //Text auf dem Textdisplay
 j=0;
 
 for(i=0; i<LCD_WIDTH; i++)
  {
   if(i<LCD_HEIGHT) SetGBaseLine(j++);  // a little bit of scrolling
   if(i>LCD_HEIGHT && j>0) SetGBaseLine(j--);  // a little bit of scrolling
   tmp=i;
   num0=(unsigned char)(tmp%10);
   bmpname[5] = (char) (num0 + '0');
   tmp /= 10;
   num1=(unsigned char)(tmp%10);
   bmpname[4] = (char) (num1 + '0');
   tmp /= 10;
   num2=(unsigned char)(tmp);
   bmpname[3] = (char) (num2 + '0');

   LoadGraphDisplay(bmpname,G_BASE);
   LoadGraphDisplay(bmpname,G_BASE1);
  }

 ClearScreen();
 LCDText("The END",0,0); //Text auf dem Textdisplay
 LCDText("hk@holger-klabunde.de",0,2); //Text auf dem Textdisplay
 LCDText("www.holger-klabunde.de",0,4); //Text auf dem Textdisplay

 SetGBaseLine(0);
 LoadGraphDisplay("bmp175.bmp",G_BASE);

 LCDText("Bye ;)",10,7); //Text auf dem Textdisplay
 
 RED_OFF();
 GREEN_ON();

//Beginn Endlosschleife
 while(1)
  {

  } //Endlosschleife
}

//###################################################################################
//Nicht sonderlich genau !!
void Delay1ms(unsigned int time)
//###################################################################################
{
 unsigned int i;

 for(i=0; i<time; i++) Delay100us(10);
}

//###################################################################################
//Nicht sonderlich genau !!
//time<=255 !!
void Delay100us(unsigned char time)
//###################################################################################
{
 unsigned char k,l;

 for(k=0; k<time; k++)
  {
   for(l=0; l<40; l++)
    {
     //Ein CPU-Clock = 0.125us bei 8MHz
     NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP;  
     NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP;  
    }
  }
}
