//************************************************************************
// Datei: savebmp.c
//
// Speichert den Grafikschirm eines T6963 Displays als Bitmap-Datei
// auf eine Speicherkarte.
//
// Die Bitmap kann mit jedem Grafikprogramm angezeigt werden.
// Hoffe ich jedenfalls ;)
//
// Es wird immer ein komplettes Display geschrieben. Wer nur Teile
// des Displays speichern mchte muss das hier SELBST ndern.
//
// Die Routinen sind fr ein 240x64 Display ausgelegt.
// 128x64 habe ich nie probiert. Das wird mit dem 6 Bit Modus wohl noch
// ziemlich buggy sein. Im 8 Bit Modus sollte es aber keine Probleme geben.
// 
// hk@holger-klabunde.de
// http://www.holger-klabunde.de
// 11.02.2007
// Compiler AVR-GCC 3.4.6
//************************************************************************
#include <avr/io.h>

#include "mydefs.h"
#include "protos.h"
#include "T6963.h"
#include "bitmap.h"
#include "../dos.h"
#include "../printf.h"
#include "../serial.h"

//#############################################################
// Display saving routine. 
// Returns 0 if failed, >0 if successfull
//
// This routine only saves the graphic screen ! Not the text
// AND graphic screen you might see on your display. If you
// want to save some text also, use a graphic text font.
//
// Diese Routine speichert nur den Grafikschirm ! Nicht die
// Mischung aus Text und Grafik die man mglicherweise auf dem
// Display sieht. Wenn Text mit gespeichert werden soll, muss
// der im Grafikmodus auf das Display geschrieben werden.
//
unsigned char SaveGraphDisplay(char *name, unsigned short baseadr)
//#############################################################
{
 unsigned char by,by1,result, fillbytes;
 unsigned char i , j;
 struct bmpheader bmp;
 unsigned char buf[BYTES_PER_ROW+1];
 
 if(baseadr!=G_BASE && baseadr!=G_BASE1) return 0;

 Remove(name); // overwrite if file exists
 
 if(Fopen(name,F_WRITE)!=F_OK) return 0;

 // Problem ! BMP's have to use 4 Byte boundarys.
 // So if you have 240 pixels and 8 pixel per byte, this is
 // 30 bytes per row. But it has to be 32 for Win !
 // For 240 pixels and 6 pixel per byte this is 40. OK.
 
 fillbytes= 4 - ( (LCD_WIDTH/8) % 4);

 bmp.b='B';
 bmp.m='M';
 bmp.reserved=0;      //Keine Funktion
 bmp.offset=sizeof(struct bmpheader);        //Offset vom Anfang der Datei zu den Bitmapdaten
 bmp.headersize=40;    //Gre des Bitmap Headers
 bmp.width=LCD_WIDTH;         //Breite der Bitmap in Pixeln
 bmp.height=LCD_HEIGHT;        //Hhe der Bitmap in Pixeln
 bmp.planes=1;       //Bitmap Planes
 bmp.bitsperpixel=1; //Bits pro Pixel                   
 bmp.compression=0;   //Kompression
 bmp.bitmapsize=(LCD_WIDTH/8 + fillbytes) * LCD_HEIGHT;    //Gre der Bitmap in Bytes. Aufgerundet auf 4Byte Grenze
 bmp.hresolution=0;   //Horizontale Auflsung in Pixel/Meter
 bmp.vresolution=0;   //Vertikale Auflsung in Pixel/Meter
 bmp.colors=2;        //Anzahl Farben
 bmp.impcolors=0;     //Anzahl der wichtigen Farben
 bmp.rgb0=0x00FFFFFF; //Wei
 bmp.rgb1=0;          //Schwarz

 bmp.filesize=sizeof(struct bmpheader)+bmp.bitmapsize;      //Gre der gesamten Datei

// printf("fillbytes %d\n",(int)fillbytes);
// printf("bitmapsize %ld\n",bmp.bitmapsize);
// printf("headersize %d\n",(int)sizeof(struct bmpheader));


 result=Fwrite((unsigned char *)&bmp,sizeof(struct bmpheader));
 if(result != sizeof(struct bmpheader))
  {
   Fclose();
   return 0;
  }
  
 for(i=LCD_HEIGHT; i>0 ; i--)
  {
   // BMP's want to be drawn from down to up !
   WriteData2(baseadr + ((i-1) * BYTES_PER_ROW ) ,0x24); //Setze Startadresse des zu lesenden Bereiches

#ifdef PIXPERBYTE_6    // than also 6 pixel per byte for graphic
// Problem with LCD_WIDTH = 128 !
// 128/6 is 22 bytes. 21*6 bits plus 2 bits.
// We go 5 times through this loop repacking 4*6 bits to 3*8 bits,
// but one time repacking 1*6 bits + 1*2 bits to 1*8 bits.
// Next problem BYTES_PER_ROW is 21 !
   j=BYTES_PER_ROW;
   do
    {
     // We have to repack 4*6 bits into 3*8 bits
     WriteCommand(0xC1); //data read and increment ADP
     by=ReadData();
     j--;
     by <<= 2; //shift all 6 bits to leftmost
     
     WriteCommand(0xC1); //data read and increment ADP
     by1=ReadData();
     by |= by1>>4; //insert lower two bits for the byte
     result=Fwrite(&by,1);
     if(j>0) j--; //BYTES_PER_ROW is 21 for LCD_WIDTH == 128
     if(j==0) break;
     
     by1 <<= 4; //shift 4 bits to leftmost. Upper two bits get lost.

     WriteCommand(0xC1); //data read and increment ADP
     by=ReadData();
     by1 |= (by>>2);  //insert lower four bits for the byte

 //    result=Fwrite(&by1,1);
     buf[0] = by1;
     
     by <<= 6;
     
     WriteCommand(0xC1); //data read and increment ADP
     by1=ReadData();
     by |= by1; //insert lower six bits for the byte

//     result=Fwrite(&by,1);
     buf[1] = by;

     result=Fwrite(buf,2);

     j-=2;
    }while(j);
#endif   

#ifdef PIXPERBYTE_8    // than also 8 pixel per byte for graphic
   for(j=0; j < BYTES_PER_ROW; j++)
    {
     WriteCommand(0xC1); //data read and increment ADP
     by=ReadData();
     buf[j]=by;
    } //for j

   result=Fwrite(buf,BYTES_PER_ROW);
#endif   
    
   for(j=0; j<fillbytes; j++) buf[j]=0;

   result=Fwrite(buf,(unsigned int)fillbytes);
   
  }// for i

 Fclose();
 return result;
}
