//#########################################################################
// File: BUTTONS.H
//
// Function prototypes, external variables and definitions for the eight
// player buttons at portx.
//
//#########################################################################
// Last change: 12.11.2006
//#########################################################################

#ifndef __BUTTONS_H
#define __BUTTONS_H

//PORT where player buttons are connected
#if defined (__AVR_ATmega32__) || defined (__AVR_ATmega323__) || defined (__AVR_ATmega161__)
 #define USE_PLAYER_BUTTONS
 
 #define PLAYER_BUTTONS_DDR	DDRA
 #define PLAYER_BUTTONS_PORT	PORTA
 #define PLAYER_BUTTONS_PIN	PINA

#elif defined (__AVR_ATmega168__) || defined (__AVR_ATmega88__) || defined (__AVR_ATmega8__)
 #undef USE_PLAYER_BUTTONS

#elif defined (__AVR_ATmega128__) || defined (__AVR_ATmega64__)
 #define USE_PLAYER_BUTTONS
 
 #define PLAYER_BUTTONS_DDR	DDRA
 #define PLAYER_BUTTONS_PORT	PORTA
 #define PLAYER_BUTTONS_PIN	PINA

#else
#  error "processor type not defined in buttons.h"
#endif


#define BUTTON_REPLAY	0x01 //Px0
#define BUTTON_PLAY	0x02 //Px1
#define BUTTON_STOP	0x04 //Px2
#define BUTTON_PAUSE	0x08 //Px3
#define BUTTON_PREV	0x10 //Px4
#define BUTTON_VOLDOWN	0x20 //Px5
#define BUTTON_VOLUP	0x40 //Px6
#define BUTTON_NEXT	0x80 //Px7

enum {
       PLAYER_REPLAY,
       PLAYER_PAUSE,
       PLAYER_PLAY,
       PLAYER_STOP,
       PLAYER_NEXT,
       PLAYER_PREV,
       PLAYER_VOLUP,
       PLAYER_VOLDOWN
     };

extern void CheckButtonsInLoop(void);
extern void CheckButtonsAfterLoop(void);
extern void ButtonsInit(void);

extern volatile unsigned char timeout; // max. 25.5s timeouts for 100ms timer ticks
extern unsigned char max_hangs;

#endif //#ifndef __BUTTONS_H
