//######################################################################
// File: display.c
//
//######################################################################
// Last change: 05.05.2007
//#########################################################################
// hk@holger-klabunde.de
// http://www.holger-klabunde.de/index.html
//#########################################################################
// Compiler: AVR-GCC 3.4.3
//#########################################################################
#include <avr/io.h>
#include <avr/interrupt.h>

#include "mydefs.h"
#include "printf.h"
#include "../lcd.h"

#include "display.h"
#include "vs1001.h"
#include "buttons.h"

volatile unsigned char update_display; //down counter for update periods of the LCD display

//#########################################################################
void DisplayInit(void)
//#########################################################################
{
 LCDInit();
 update_display=UPDATE_DISPLAY;
}

//#########################################################################
void UpdateDisplay(void)
//#########################################################################
{
 int minutes,seconds;
 unsigned char sample_rate,mpgmode;
 unsigned int audata,hdat0,playtime;

 //Don't update the display EVERY time we come here
 if(update_display==0)
  {
   //Show playtime for this song
   playtime=VS1001_GetPlayTime();
   minutes=playtime/60;
   seconds=playtime%60;
   LCDPos(2,1);
   printf("%02d:%02d ",minutes,seconds);

   //get MPEG mode from VS1001
   hdat0=VS1001_GetHdat0();
   mpgmode=(unsigned char)((hdat0>>6) & 0x03); //read VS1001 datasheet
 
   audata=VS1001_GetAudata();
   sample_rate=(unsigned char)((audata>>9) & 0x0F); //read VS1001 datasheet
   audata &= 0x01FF;
   printf("% 3dkbps ",audata); //bitrate, read VS1001 datasheet

   // If we have no valid samplerate or kbps value, software reset
   // does help the decoder to eat non mpg frames ;) Without this,
   // decoder hangs sometimes ! Maybe this should be done in PlayMp3() routine.
   // If you don't want a display for example.
   if(audata==0)
    {
     VS1001_Reset(SOFT_RESET); // soft reset the decoder here !
     max_hangs++;
    } 
   else max_hangs=0;

   switch(sample_rate)
    {
     case 1 : puts("44"); break;
     case 2 : puts("48"); break;
     case 3 : puts("32"); break;
     case 4 : puts("22"); break;
     case 5 : puts("24"); break;
     case 6 : puts("16"); break;
     case 7 : puts("11"); break;
     case 8 : puts("12"); break;
     case 9 : puts(" 8"); break;
     default: puts("??");
          VS1001_Reset(SOFT_RESET);
          max_hangs++;
      break;
    } 
 
   puts("kHz ");

   // bliches Kennzeichen fr einen hngenden VS1001 ist das die Playtime auf 00:00 stehen bleibt
   // wenn der Decoder sich aufgehngt hat.
   if(minutes==0 && seconds==0) max_hangs++;
   else max_hangs=0; //Uhrzeit luft, also scheint mit dem Decoder alles ok zu sein

   if(max_hangs>=DECODER_MAX_HANGS) // To many false values, hard reset the decoder !
    {
     VS1001_Reset(HARD_RESET);        // hard reset the decoder here !
     VS1001_SetVolume(volume,volume); // restore old volume setting, gets lost by hard reset
     max_hangs=0;
    }
    
#if !defined (__AVR_ATmega8__) && !defined (__AVR_ATmega88__)
   switch(mpgmode)
    {
     case  0 : puts("ST"); break; //Stereo
     case  1 : puts("JO"); break; //Joint Stereo
     case  2 : puts("DU"); break; //Dual ??
     case  3 : puts("MO"); break; //Mono
    }

    puts("\n"); //for serial output. remove for lcd only
#endif

    update_display=UPDATE_DISPLAY; //refresh update display counter
 
  }//if(update_display==0)
}
