//#########################################################################
// File: main.c
//
// MP3 Player main() routine
//
//#########################################################################
// Last change: 05.05.2007
//#########################################################################
// hk@holger-klabunde.de
// http://www.holger-klabunde.de/index.html
//#########################################################################
// Compiler: AVR-GCC 3.4.6
//#########################################################################
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/eeprom.h>

#include <stdarg.h>
#include <string.h>
#include <stdlib.h>

#include "mydefs.h"
#include "protos.h"
#include "../dos.h"
#include "../serial.h"
#include "printf.h"
#include "../lcd.h"
#include "vs1001.h"
#include "buttons.h"
#include "display.h"
#include "playmp3.h"
#include "rc5.h"

volatile unsigned char play_status;
unsigned char volume;

//###################################################################################
/* Hauptprogramm */
int main(void)
//###################################################################################
{
 unsigned char result;
 
 Delay1ms(200); //Wait for Power Up of MMC/SD/CF and VS1001

//1 Ausgang
//0 Eingang

#ifdef COMPACTFLASH_CARD
#if defined (__AVR_ATmega32__) || defined (__AVR_ATmega323__)
#  error "CompactFlash does not work with this processor type in main.c"
#endif
#endif //#ifdef COMPACTFLASH_CARD

#ifdef MMC_CARD_SPI //SD_CARD_SPI too !
 MMC_IO_Init();
#endif

 VS1001_IO_Init();

#if !defined (__AVR_ATmega161__) && !defined (__AVR_ATmega168__)
 SFIOR&=!(1<<PUD); 	//Pullups Enable
#else
#endif

#if !defined (__AVR_ATmega8__) && !defined (__AVR_ATmega88__)
 ser_init(); //init serial port
#endif

#ifdef USE_REMOTE
 RemoteInit();
#endif
 ButtonsInit();
 DisplayInit();
 
 timeout=DECODER_TIME_OUT;

 sei();              //enable interrupts

// puts("Try to read FlashDrive Configuration\n");

 if(GetDriveInformation()!=F_OK) // get drive parameters
  {
   puts("No Flash!");
   RED_OFF();
   GREEN_ON();
   while(1);
  }

 LCDCls();
  
 VS1001_Reset(HARD_RESET);
 // Switching the hardware reset line of the VS1001 results in a loud ugly blop.

 RED_ON();
 GREEN_OFF();

 // Todo:
 // Get last values from eeprom for
 // Volume, last played title, last player status (stop/play)
 // Bass/trebble enhancer on/off
 // A balance function !
 
 // Volume 0 is highest volume
 // Volume 254 is lowest volume
 // Volume 255 is power down VS1001

 volume=eeprom_read_byte(EEP_VOLUME);
 if(volume==0xFF) //No volume found
  { volume=0x20;
    eeprom_write_byte(EEP_VOLUME,volume);
  }
// volume=0; //play it loud ;)
 VS1001_SetVolume(volume,volume);

 VS1001_SetMode(VS_SM_BASS); //Bass/treble enhancer. Good for small headphones.
// VS1001_SetMode(VS_SM_DIFF); //Virtual surround stereo test ;)
 
// Don't do this WITHOUT a FAT buffer !
// printf("Drive Size %lukB\n",drivesize());
// printf("Drive Free %lukB\n",drivefree());
// printf("Drive Used %lukB\n",driveused());

// RED_OFF();
// GREEN_ON();
 play_status=PLAYER_PLAY; //auto play on power on. remove if you don't like it
 result=0;

 Chdir("mp3"); //change to MP3 directory !

// Player buttons are read in TCNT1 interrupt routine !
// Remote control signals are read in INT0 interrupt routine !
 
 for(;;) // loop forever until power down
  {
#ifdef USE_REMOTE
   CheckRemote();
#endif
   //Player buttons are read in interrupt routine !
   
   if(Findfirst()!=0 && play_status==PLAYER_PLAY) //find FIRST file in directory
    {
     do
      {
       if(ffblk.ff_attr==ATTR_FILE && play_status==PLAYER_PLAY) //did we find a file ?
        {

         //is this a MP3 file ? check the DOS 8.3 extension to .MP3
         if(ffblk.ff_name[9]=='M' && ffblk.ff_name[10]=='P' && ffblk.ff_name[11]=='3')
          {
           LCDCls();
           
#ifdef USE_FINDLONG
           //do we have a long filename ?
           if(ffblk.ff_longname[0]!=0) printf("%s\n",ffblk.ff_longname); //print long name
           else printf("%s\n",ffblk.ff_name);    //print 8.3 DOS name
//           printf("% 9lu\n",ffblk.ff_fsize); //print filesize 
#else
           printf("%s\n",ffblk.ff_name);    //print 8.3 DOS name
//           printf("% 9lu\n",ffblk.ff_fsize); //print filesize 
#endif

           PlayMp3(ffblk.ff_name);           //play the song

          }//if(ffblk.ff_name[9]=='M' && ...
        }//if(ffblk.ff_attr==ATTR_FILE && play_status ...

       if(play_status==PLAYER_PLAY) result=Findnext(); //find the next song
 
      }while(result!=0 && play_status!=PLAYER_STOP);

      //At this point last song is played. So go to the first file and play all 
      //songs again until power is switched off.
    }
  }//for(;;)
}
