//#########################################################################
// File: MYDEFS.H
//
//
//#########################################################################
// Last change: 05.05.2007
//#########################################################################
// Compiler: AVR-GCC 3.4.5
//#########################################################################

#ifndef __MYDEFS_H
#define __MYDEFS_H

#define EEP_VOLUME (uint8_t *) 2  // EEPROM Adress of volume settings

#define UART_BAUD_RATE	19200
//#define UART_BAUD_RATE	38400

#define T1_PRESCALER	8
#define T1_TICKS   	F_CPU / ( T1_PRESCALER * 65536 )	
#define T1_ONESECOND    T1_TICKS

#define NOP asm volatile ("nop" ::)
//WinAVR 3.4.3 setzt die Bitsetzbefehle sbi(),cbi() ins Assembler-Listing fr diese
//beiden #defines ein ! Also kein Grund Inline Assembler zu benutzen.
#define sbi(portn, bitn) ((portn)|=(1<<(bitn)))
#define cbi(portn, bitn) ((portn)&=~(1<<(bitn)))
//#define sbi(portn, bitn) asm volatile("sbi %0, %1" : : "I" (_SFR_IO_ADDR(portn)), "I" ((uint8_t)(bitn)))
//#define cbi(portn, bitn) asm volatile("cbi %0, %1" : : "I" (_SFR_IO_ADDR(portn)), "I" ((uint8_t)(bitn)))

#if defined (__AVR_ATmega32__) || defined (__AVR_ATmega323__) || defined (__AVR_ATmega161__) || defined (__AVR_ATmega163__)

 #define RED_BIT	7	//Pin number for red LED
 #define RED_PORT 	PORTD   //Port where red LED is located
 #define RED_DDR 	DDRD    //Port direction register where red LED is located
 #define GREEN_BIT	6	//Pin number for green LED
 #define GREEN_PORT 	PORTD   //Port where green LED is located
 #define GREEN_DDR 	DDRD    //Port direction register where green LED is located

#elif defined (__AVR_ATmega128__) || defined (__AVR_ATmega64__)
 #define RED_BIT	7	//Pin number for red LED
 #define RED_PORT 	PORTE   //Port where red LED is located
 #define RED_DDR 	DDRE    //Port direction register where red LED is located
 #define GREEN_BIT	6	//Pin number for green LED
 #define GREEN_PORT 	PORTE   //Port where green LED is located
 #define GREEN_DDR 	DDRE    //Port direction register where green LED is located

#elif defined (__AVR_ATmega168__) || defined (__AVR_ATmega8__) || defined (__AVR_ATmega88__)
 #define RED_BIT	5	//Pin number for red LED
 #define RED_PORT 	PORTD   //Port where red LED is located
 #define RED_DDR 	DDRD    //Port direction register where red LED is located
 #define GREEN_BIT	4	//Pin number for green LED
 #define GREEN_PORT 	PORTD   //Port where green LED is located
 #define GREEN_DDR 	DDRD    //Port direction register where green LED is located

#else
#  error "processor type not defined in mydefs.h"
#endif

//Die beiden LED's
#define RED_ON() { sbi(RED_DDR,RED_BIT); cbi(RED_PORT,RED_BIT); } //LOW activ
#define RED_OFF() { sbi(RED_DDR,RED_BIT); sbi(RED_PORT,RED_BIT); } //LOW activ

#define GREEN_ON() { sbi(GREEN_DDR,GREEN_BIT); cbi(GREEN_PORT,GREEN_BIT); }  //LOW activ
#define GREEN_OFF() { sbi(GREEN_DDR,GREEN_BIT); sbi(GREEN_PORT,GREEN_BIT); } //LOW activ

//Prototypes of global variables
extern volatile unsigned char play_status;
extern unsigned char volume;

#endif //__MYDEFS_H
