//######################################################################
// File: playmp3.c
//
//######################################################################
// Last change: 01.09.2006
//#########################################################################
// hk@holger-klabunde.de
// http://www.holger-klabunde.de/index.html
//#########################################################################
// Compiler: AVR-GCC 3.4.5
//#########################################################################
#include <avr/io.h>
#include <avr/interrupt.h>

#include "mydefs.h"
#include "../dos.h"
#include "../serial.h"
#include "../lcd.h"
#include "printf.h"

#include "playmp3.h"
#include "buttons.h"
#include "rc5.h"
#include "vs1001.h"
#include "display.h"

//###################################################################################
// MP3 playing routine with control buttons checking and display output
int PlayMp3(char *name)
//###################################################################################
{
 unsigned char result, buf[PLAY_BUFFER_SIZE], packets;
 unsigned int i, numbytes;
 unsigned char ID3[41];  //LCD length +1. Mine is 40 chars
 
 packets=PLAYER_MAX_PACKETS; //Allows you to break playing if player hangs or
                             //does not play correctly. For example if you want to play
                             //320kbps files with CPU clock of 4.00MHz.
 
 timeout=DECODER_TIME_OUT;
 max_hangs=0;

 result=Fopen(name,F_READ);
 if(result==F_OK)
  {

/*
   // Try to read ID3 Tags (if exist :( only )
   Fread(ID3,3); // Try to read "ID3" V2 Tag at beginning of file
   if(ID3[0]=='I' && ID3[1]=='D' && ID3[2]=='3')
    {

    }
   else
    {
*/
     Fseek(-128,SEEK_END); // Go to ID3 V1 TAG 
     Fread(ID3,3); // Try to read "TAG"
     if(ID3[0]=='T' && ID3[1]=='A' && ID3[2]=='G')
      {
       ID3[30]=0; // end of string marker !
       LCDCls();
       Fread(ID3,30);    // Read song name (max. 30 chars)
       printf("%s",ID3); // Show it
      }
/*
    }
*/

   Fseek(0,SEEK_SET); // Go to beginning of file 
   
   //#####################
   //begin of playing loop  
   //#####################
   do
    {

     if(play_status==PLAYER_PLAY) //read nothing if playing is paused
      {

       // If the decoder does not want data for longer than 1 second,
       // hard reset the decoder and skip the file.
       if(timeout==0)
        {
//         printf("\nHard Reset the Decoder !\n");
         VS1001_Reset(HARD_RESET); // decoder does not like this file
         VS1001_SetVolume(volume,volume); // restore old volume setting, gets lost by hard reset
         max_hangs=0;
         result=F_ERROR; // skip this file
        }
        
       //Fill VS1001 buffer until DREQ is set to 0 or end of file reached
       while((VS1001_READY_FOR_RECEIVE) && result==F_OK)
        {
         if(max_hangs==0) timeout=DECODER_TIME_OUT;

         //read up to PLAY_BUFFER_SIZE Bytes from cf/mmc/sd for the VS1001 buffer
         numbytes=Fread(buf,PLAY_BUFFER_SIZE);
         if(numbytes!=PLAY_BUFFER_SIZE)
          {
           for(i=numbytes; i<PLAY_BUFFER_SIZE; i++) buf[i]=0;
           result=F_ERROR; //end of file reached ?
          } 
         
         if(numbytes>0) VS1001_WriteData32(buf); //give VS1001 something to play
         
         packets--; //count down PLAYER_MAX_PACKETS counter
         if(packets==0)
          {
           packets=PLAYER_MAX_PACKETS;
           break; //force breaking the loop
          }
        }

      }//if(play_status==PLAYER_PLAY)  
      else timeout=DECODER_TIME_OUT; // Don't time out the decoder if paused ! 

     //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     //VS1001 buffer is full here, so we have some time to do other things
     //like testing input keys, remote control or update display informations.
     //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#ifdef USE_REMOTE
     CheckRemote();
#endif
     CheckButtonsInLoop();

     UpdateDisplay();

    }while(result==F_OK && ( play_status==PLAYER_PLAY || play_status==PLAYER_PAUSE));
   //read file to the end or STOP or NEXT or PREV or REPLAY

   //#####################
   //end of playing loop  
   //#####################

   VS1001_Reset(SOFT_RESET); //very important ! soft reset vs1001k after each track

   CheckButtonsAfterLoop();

   Fclose(); //close this MP3 file
   return 0; //no errors
  }
 else return 1; //error
// else printf("File is not open !\n");

}
