//#########################################################################
// printf.c
//
// printf() based on sprintf() from gcctest9.c Volker Oth
//
// If you have no parameters for printf() use puts() !
//
// Modified Version. Supports unsigned types only !
//
//#########################################################################
// Last change: 29.10.2006
//#########################################################################
// hk@holger-klabunde.de
// http://www.holger-klabunde.de/index.html
//#########################################################################
// Compiler: AVR-GCC 3.4.5
//#########################################################################

#include <stdarg.h>
#include <string.h>
#include <avr/pgmspace.h>

#define SERIAL_OUT  //Output should go to serial-interface
#define LCD_OUT     //Output should go to lcd-display
//#define WHAT_EVER_YOU_WANT
//You can do even both ;)

#ifdef SERIAL_OUT
 #include "../serial.h" 
#endif

#ifdef LCD_OUT
 #include "../lcd.h"  
#endif

#define SCRATCH 12	//32Bits go up to 4GB + 1 Byte for \0

//Spare some program space by making a comment of all not used format flag lines
#define USE_LONG 	// %lx, %Lu and so on, else only 16 bit integer is allowed
#define USE_STRING      // %s, %S Strings as parameters
#define USE_HEX		// %x, %X Hexadezimal output
#define USE_UPPERHEX	// %x, %X outputs A,B,C... else a,b,c...
#ifndef USE_HEX
 #undef USE_UPPERHEX    // ;)
#endif

#define USE_UPPER	// uncommenting this removes %C,%D,%I,%O,%S,%U,%X and %L..
                        // only lowercase format flags are used

#define PADDING         //SPACE and ZERO padding

//Making a comment of all #defines spares more then 360 Bytes.

//##############################################
//Outputs a single char. You can redirect output
//here to whatever you want.
void myputchar(unsigned char c)
//##############################################
{
#ifdef SERIAL_OUT
 if(c == '\n') //send CR and LF if \n
  {
   ser_putc(0x0D); //CR
   ser_putc(0x0A); //LF
  }
 else ser_putc(c);
#endif
 
#ifdef LCD_OUT
 if(c!=0x0D && c!=0x0A) LCDWriteByte(c);
#endif
}

//##############################################
//Outputs a text via myputchar().
void _puts_P(char const *s)
//##############################################
{
 unsigned char c;
 while((c=pgm_read_byte(s++))) myputchar(c);
}

//##############################################
void _printf_P(char const *format, ...)
//##############################################
{
  char scratch[SCRATCH];
  unsigned char format_flag;
  unsigned short base;
  char *ptr;
  va_list ap;

#ifdef USE_LONG
  unsigned char islong=0;
  unsigned long u_val=0;
#else
  unsigned int u_val=0;
#endif

  unsigned char fill;
  unsigned char width;

  va_start (ap, format);
  for (;;)
  {
    while ((format_flag = pgm_read_byte(format++)) != '%')
    {      // Until '%' or '\0' 
      if (!format_flag){va_end (ap); return;}
      myputchar(format_flag);
    }

    base = 10;

    format_flag = pgm_read_byte(format++); //get char after '%'

#ifdef PADDING
    width=0; //no formatting
    fill=0;  //no formatting
    if(format_flag=='0' || format_flag==' ') //SPACE or ZERO padding  ?
     {
      fill=format_flag;
      format_flag = pgm_read_byte(format++); //get char after padding char
      if(format_flag>='0' && format_flag<='9')
       {
        width=format_flag-'0';
        format_flag = pgm_read_byte(format++); //get char after width char
       }
     }
#endif

#ifdef USE_LONG
    islong=0; //default int value
#ifdef USE_UPPER
    if(format_flag=='l' || format_flag=='L') //Long value 
#else
    if(format_flag=='l') //Long value 
#endif
     {
      islong=1;
      format_flag = pgm_read_byte(format++); //get char after 'l' or 'L'
     }
#endif

    switch (format_flag)
    {
    default:
      myputchar(format_flag);
      continue;

#ifdef USE_STRING
#ifdef USE_UPPER
    case 'S':
#endif
    case 's':
      ptr = va_arg(ap,char *);
      while(*ptr) { myputchar(*ptr); ptr++; }
      continue;
#endif

    case 'd':
#ifdef USE_UPPER
    case 'D':
#endif
      // no break -> run into next case
    case 'u':
#ifdef USE_UPPER
    case 'U':
#endif

//don't insert some case below this if USE_HEX is undefined !
//or put       goto CONVERSION_LOOP;  before next case.
#ifdef USE_HEX
      goto CONVERSION_LOOP;
    case 'x':
#ifdef USE_UPPER
    case 'X':
#endif
      base = 16;
#endif

    CONVERSION_LOOP:

#ifdef USE_LONG
        if(islong) { u_val = va_arg(ap,unsigned long); }
        else { u_val = va_arg(ap,unsigned int); }
#else
        u_val = va_arg(ap,unsigned int);
#endif
    
      ptr = scratch + SCRATCH;
      *--ptr = 0;
      do
       {
        char ch = u_val % base + '0';
#ifdef USE_HEX
        if (ch > '9')
         {
          ch += 'a' - '9' - 1;
#ifdef USE_UPPERHEX
          ch-=0x20;
#endif
         }
#endif          
        *--ptr = ch;
        u_val /= base;

#ifdef PADDING
        if(width) width--; //calculate number of padding chars
#endif
      } while (u_val);

#ifdef PADDING
     while(width--) *--ptr = fill; //insert padding chars		      
#endif

      while(*ptr) { myputchar(*ptr); ptr++; }
    }
  }
}
