#ifndef __vs1001_h
#define __vs1001_h

#include "../dos.h"
//###############################################
//	FUNCTION PROTOTYPES
//###############################################
void VS1001_IO_Init(void);
void VS1001_Reset(U8 resetmode);
void VS1001_SetVolume(U8 left,U8 right);
void VS1001_WriteData32(U8 *data);
void VS1001_WriteControl(U8 adress, U16 data);
U16 VS1001_ReadControl(U8 adress);
U8 ReadByteSPI(void);
void VS1001_SendNull32(U8 count);
U16 VS1001_GetPlayTime(void);
U16 VS1001_GetAudata(void);
U16 VS1001_GetHdat0(void);
void VS1001_SetMode(U16 mode);

#define SOFT_RESET			0
#define HARD_RESET			1

#define DECODER_TIME_OUT	20 // 100ms steps
#define DECODER_MAX_HANGS	10 // Force hardware reset after x times
                                   // no valid samplerate or kbps values

//###############################################
// VS1001 Command Definitions
//###############################################
#define	VS1001_READ		0x03 
#define	VS1001_WRITE		0x02

//###############################################
// VS1001 Register Adress Definitions
//###############################################
#define VS_MODE_REG         0
#define VS_STATUS_REG       1
#define VS_INT_FCTLH_REG    2
#define VS_CLOCKF_REG       3
#define VS_DECODE_TIME_REG  4
#define VS_AUDATA_REG       5
#define VS_HDAT0_REG        8
#define VS_HDAT1_REG        9
#define VS_VOL_REG         11

//###############################################
// Mode register bits.
//###############################################
#define VS_SM_DIFF      0x0001
#define VS_SM_FFWD      0x0002
#define VS_SM_RESET     0x0004
#define VS_SM_MP12      0x0008
#define VS_SM_PDOWN     0x0010
#define VS_SM_DAC       0x0020
#define VS_SM_DACMONO   0x0040
#define VS_SM_BASS      0x0080
#define VS_SM_DACT      0x0100
#define VS_SM_BYTEORD   0x0200
#define VS_SM_IBMODE    0x0400
#define VS_SM_IBCLK     0x0800

//###############################################
// Hardware Interface Definitions
//###############################################
#if defined (__AVR_ATmega32__) || defined (__AVR_ATmega323__) || defined (__AVR_ATmega161__) || defined (__AVR_ATmega644__)

#define VS_PORT		PORTB
#define VS_DDR		DDRB
#define VS_PIN		PINB

#define VS_SCK_PORT     VS_PORT	// Port register of VS_SCK_BIT
#define VS_SCK_DDR      VS_DDR	// Data direction register of VS_SCK_BIT
#define VS_SCK_BIT      7	// VS1001 interface clock input

#define VS_SS_PORT      VS_PORT	// Port output register of VS_SS_BIT
#define VS_SS_DDR       VS_DDR	// Data direction register of VS_SS_BIT
#define VS_SS_BIT       7	// Dummy, set to SCK
				// SS is used by my MMC !

#define VS_MOSI_PORT    VS_PORT	// Port output register of VS_MOSI_BIT
#define VS_MOSI_DDR     VS_DDR	// Data direction register of VS_MOSI_BIT
#define VS_MOSI_BIT     5	// VS1001 serial control interface data input

#define VS_MISO_PIN     VS_PIN	// Pin input register of VS_MISO_BIT
#define VS_MISO_PORT    VS_PORT	// Port input register of VS_MISO_BIT
#define VS_MISO_DDR     VS_DDR	// Data direction register of VS_MISO_BIT
#define VS_MISO_BIT     6	// VS1001 serial control interface data output

#define VS_XCS_PORT     VS_PORT	// Port output register of VS_XCS_BIT
#define VS_XCS_DDR      VS_DDR	// Data direction register of VS_XCS_BIT
#define VS_XCS_BIT      3	// VS1001 active low chip select input

#define VS_BSYNC_PORT   VS_PORT	// Port output register of VS_BSYNC_BIT
#define VS_BSYNC_DDR    VS_DDR	// Data direction register of VS_BSYNC_BIT
#define VS_BSYNC_BIT    2	// VS1001 serial data interface bit bsync

#define VS_RESET_PORT   VS_PORT	// Port output register of VS_RESET_BIT
#define VS_RESET_DDR    VS_DDR	// Data direction register of VS_RESET_BIT
#define VS_RESET_BIT    1	// VS1001 hardware reset input

#define VS_DREQ_PORT    VS_PORT	// Port output register of VS_DREQ_BIT
#define VS_DREQ_PIN     VS_PIN	// Pin input register of VS_DREQ_BIT
#define VS_DREQ_DDR     VS_DDR	// Data direction register of VS_DREQ_BIT
#define VS_DREQ_BIT     0	// VS1001 data request output

#elif defined (__AVR_ATmega128__) || defined (__AVR_ATmega64__)

#define VS_PORT		PORTB
#define VS_DDR		DDRB
#define VS_PIN		PINB

#define VS_SCK_PORT     VS_PORT	// Port register of VS_SCK_BIT
#define VS_SCK_DDR      VS_DDR	// Data direction register of VS_SCK_BIT
#define VS_SCK_BIT      1	// VS1001 interface clock input

#define VS_SS_PORT      VS_PORT	// Port output register of VS_SS_BIT
#define VS_SS_DDR       VS_DDR	// Data direction register of VS_SS_BIT
#define VS_SS_BIT       1	// Dummy, set to SCK
				// SS is used by my MMC !

#define VS_MOSI_PORT    VS_PORT	// Port output register of VS_MOSI_BIT
#define VS_MOSI_DDR     VS_DDR	// Data direction register of VS_MOSI_BIT
#define VS_MOSI_BIT     2	// VS1001 serial control interface data input

#define VS_MISO_PIN     VS_PIN	// Pin input register of VS_MISO_BIT
#define VS_MISO_PORT    VS_PORT	// Port input register of VS_MISO_BIT
#define VS_MISO_DDR     VS_DDR	// Data direction register of VS_MISO_BIT
#define VS_MISO_BIT     3	// VS1001 serial control interface data output

#define VS_XCS_PORT     VS_PORT	// Port output register of VS_XCS_BIT
#define VS_XCS_DDR      VS_DDR	// Data direction register of VS_XCS_BIT
#define VS_XCS_BIT      4	// VS1001 active low chip select input

#define VS_BSYNC_PORT   VS_PORT	// Port output register of VS_BSYNC_BIT
#define VS_BSYNC_DDR    VS_DDR	// Data direction register of VS_BSYNC_BIT
#define VS_BSYNC_BIT    5	// VS1001 serial data interface bit bsync

#define VS_RESET_PORT   VS_PORT	// Port output register of VS_RESET_BIT
#define VS_RESET_DDR    VS_DDR	// Data direction register of VS_RESET_BIT
#define VS_RESET_BIT    6	// VS1001 hardware reset input

#define VS_DREQ_PORT    VS_PORT	// Port output register of VS_DREQ_BIT
#define VS_DREQ_PIN     VS_PIN	// Pin input register of VS_DREQ_BIT
#define VS_DREQ_DDR     VS_DDR	// Data direction register of VS_DREQ_BIT
#define VS_DREQ_BIT     7	// VS1001 data request output

#elif defined (__AVR_ATmega168__) || defined (__AVR_ATmega8__)

#define VS_SCK_PORT     PORTB	// Port register of VS_SCK_BIT
#define VS_SCK_DDR      DDRB	// Data direction register of VS_SCK_BIT
#define VS_SCK_BIT      5	// VS1001 interface clock input

#define VS_SS_PORT      PORTB	// Port output register of VS_SS_BIT
#define VS_SS_DDR       DDRB	// Data direction register of VS_SS_BIT
#define VS_SS_BIT       5	// Dummy, set to SCK
				// SS is used by my MMC !

#define VS_MOSI_PORT    PORTB	// Port output register of VS_MOSI_BIT
#define VS_MOSI_DDR     DDRB	// Data direction register of VS_MOSI_BIT
#define VS_MOSI_BIT     3	// VS1001 serial control interface data input

#define VS_MISO_PIN     PINB	// Pin input register of VS_MISO_BIT
#define VS_MISO_PORT    PORTB	// Port input register of VS_MISO_BIT
#define VS_MISO_DDR     DDRB	// Data direction register of VS_MISO_BIT
#define VS_MISO_BIT     4	// VS1001 serial control interface data output

#define VS_XCS_PORT     PORTB	// Port output register of VS_XCS_BIT
#define VS_XCS_DDR      DDRB	// Data direction register of VS_XCS_BIT
#define VS_XCS_BIT      1	// VS1001 active low chip select input

#define VS_BSYNC_PORT   PORTB	// Port output register of VS_BSYNC_BIT
#define VS_BSYNC_DDR    DDRB	// Data direction register of VS_BSYNC_BIT
#define VS_BSYNC_BIT    0	// VS1001 serial data interface bit bsync

#define VS_RESET_PORT   PORTD	// Port output register of VS_RESET_BIT
#define VS_RESET_DDR    DDRD	// Data direction register of VS_RESET_BIT
#define VS_RESET_BIT    7	// VS1001 hardware reset input

#define VS_DREQ_PORT    PORTD	// Port output register of VS_DREQ_BIT
#define VS_DREQ_PIN     PIND	// Pin input register of VS_DREQ_BIT
#define VS_DREQ_DDR     DDRD	// Data direction register of VS_DREQ_BIT
#define VS_DREQ_BIT     6	// VS1001 data request output

#else
#  error "processor type not defined in vs1001.h"
#endif

#define VS_BSYNC_ON	sbi(VS_BSYNC_PORT, VS_BSYNC_BIT);
#define VS_BSYNC_OFF	cbi(VS_BSYNC_PORT, VS_BSYNC_BIT);

#define VS_XCS_ON	sbi(VS_XCS_PORT, VS_XCS_BIT);
#define VS_XCS_OFF	cbi(VS_XCS_PORT, VS_XCS_BIT);

#define VS_SCK_ON	sbi(VS_SCK_PORT, VS_SCK_BIT);
#define VS_SCK_OFF	cbi(VS_SCK_PORT, VS_SCK_BIT);

#define VS_RESET_ON	sbi(VS_RESET_PORT, VS_RESET_BIT);
#define VS_RESET_OFF	cbi(VS_RESET_PORT, VS_RESET_BIT);

#define VS_SS_ON	sbi(VS_SS_PORT, VS_SS_BIT);
#define VS_SS_OFF	cbi(VS_SS_PORT, VS_SS_BIT);

#define VS_MOSI_ON	sbi(VS_MOSI_PORT, VS_MOSI_BIT);
#define VS_MOSI_OFF	cbi(VS_MOSI_PORT, VS_MOSI_BIT);

#define VS1001_READY_FOR_RECEIVE	bit_is_set(VS_DREQ_PIN, VS_DREQ_BIT)
#define VS1001_BUSY			bit_is_clear(VS_DREQ_PIN, VS_DREQ_BIT)

#endif
