// NMEA.C
//
// Bearbeitet NMEA-Messages von GPS-Musen
//###################################################################################
// Probleme:
// 
// Wenn z.B. die Navimouse keinen Empfang hat kann das so aussehen:
//
// $GPGGA,,,,,,0,00,,,,,,,*66
// $GPGSA,A,1,,,,,,,,,,,,,1.98,1.52,1.27*02
// $GPRMC,235948,V,5419.2530,N,01007.0105,E,0.000,0.0,280697,0.1,W*7E
//
// Man kann also nicht damit rechnen das zwischen den Komma's immer etwas kommt.
// Selbst da nicht wo oben noch Werte stehen ! Deshalb der stndige Check
// "if(num!=0) ..." Die Anzahl Nachkommastellen ist auch nicht fest
// und von GPS zu GPS verschieden. Das eine liefert 0.000 das andere 0.00 usw. 
// Einige GPS liefern Nachkommastellen bei der Uhrzeit, andere nicht.
//###################################################################################
// Compiler: AVR-GCC (Mingw32)
// Version : 3.2
//###################################################################################
// Processor: ATMega323
//
// hk@holger-klabunde.de
// http://www.holger-klabunde.de
// Last change: 01.09.2002
//###################################################################################

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/signal.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>

#include "mydefs.h"
#include "protos.h"

//###################################################
// Liest einen Teilstring in line[] bis end, z.b. ','
// oder bis '*' dem Beginn der Checksumme
unsigned char GetLine(unsigned char end)
//###################################################
{
 unsigned char c,i;

//Achtung: Unten wird die Lnge von line[] nicht berprft !
//Knnte zum Absturz fhren. line[] ist aber gro genug fr
//die lngste NMEA Meldung

 line[0]=0; //Besser is das ! Auf keinen Fall entfernen !
 i=0;
 do
  {
   c=ser_getc();
   if(c=='*') return 0xFF; //Checksumme erreicht
   if(c==',') return i; //Ende eines Wertes erreicht

   if(c!=end) //Buchstaben sammeln
    {
     line[i]=c;
     i++;
     line[i]=0; //End of String updaten
    }

  }while(c!=end);

 return i;
}


//#########################################################################
//Beispiele wie unterschiedlich die $GPGSV Meldungen aussehen knnen !
//
//Rockwell/Navimouse
//$GPGSV,3,1,12,27,72,114,44,08,55,192,,10,51,296,,13,40,087,47*7C
//$GPGSV,3,2,12,24,33,240,00,02,16,037,40,04,10,203,00,29,10,271,*74
//$GPGSV,3,3,12,23,08,311,,01,08,088,,22,06,024,,28,,165,*71
//
//Und kurz danach aus derselben GPS-Maus
//$GPGSV,3,1,12,27,71,104,44,08,59,191,34,10,53,294,31,13,37,089,45*78
//$GPGSV,3,2,12,24,30,238,23,02,15,035,41,29,12,273,00,23,11,311,00*7F
//$GPGSV,3,3,12,04,07,202,00,01,05,089,00,22,03,023,00,28,02,164,00*75
//
//Statt keinem Wert zwischen den Komma's ein ,00,
//
//SIRF/Tekelec Mouse
//$GPGSV,3,1,09,27,71,131,35,08,49,192,31,10,45,299,32,13,44,084,33*74
//$GPGSV,3,2,09,24,36,245,36,02,18,040,,04,14,204,,01,12,085,30*70
//$GPGSV,3,3,09,22,08,027,*4D
//
//Nur eine Satellitenangabe in der letzten Zeile. Das habe ich auch schon
//so gesehen:
//
//$GPGSV,3,3,09,22,08,027,,,,,,,,,,,,,*4D PS: Checksumme stimmt jetzt nicht
//
/* Speicher reicht nicht fr GP_GSV() !
void GP_GSV(void)
//#########################################################################
{
 unsigned char num,i;
 unsigned char pnr;
 unsigned char ele;
 unsigned int azi;
 unsigned char snr;

 //Anzahl GPGSV Message Zeilen
 num=GetLine(',');
 //Nummer dieser Zeile
 num=GetLine(',');

 //Anzahl Satelliten in Sicht (bei idealer Sicht)
 //Also nicht die die tatschlich in Sicht sind !
 num=GetLine(',');

 for(i=0; i<4; i++)
  {
   //Und danach bis zu vier dieser Blcke pro GPGSV Meldung
   //PRN Nummer des Satelliten
   pnr=0;
   num=GetLine(',');
   if(num==0xFF) break; //Checksumme gefunden !
   if(num!=0) pnr=(unsigned char)atoi(line);
   //Elevation 0-90 (Sichtwinkel ber Horizont)
   ele=0;
   num=GetLine(',');
   if(num==0xFF) break; //Checksumme gefunden !
   if(num!=0) ele=(unsigned char)atoi(line);
   //Sichtwinkel bezogen auf Nordpol 0-359
   azi=0;
   num=GetLine(',');
   if(num==0xFF) break; //Checksumme gefunden !
   if(num!=0) azi=(unsigned int)atoi(line);

   //SNR Wert 00-99dB 
   //Ab SNR=30 werden Satelliten fr die Lsung benutzt. Das scheint bei den
   //meisten Herstellern so zu sein.
   
   snr=0;
   num=GetLine(',');
   if(num!=0) snr=(unsigned char)atoi(line);
   
   if(snr!=0) //Aha ein Satellit in Arbeit
    {
     //SNR der ersten 8 Satelliten anzeigen. Fr mehr kein Platz
     satcount++; //Anzahl Satelliten zhlen (bis zu 12)

     switch(satcount)
      {
       case 1: LCDPos(1,29); break;
       case 2: LCDPos(1,32); break;
       case 3: LCDPos(1,35); break;
       case 4: LCDPos(1,38); break;
       case 5: LCDPos(2,29); break;
       case 6: LCDPos(2,32); break;
       case 7: LCDPos(2,35); break;
       case 8: LCDPos(2,38); break;
      }

     if(satcount<9) LCDWrite(line);
    }

   if(num==0xFF) break; //Checksumme gefunden !
  }
}
*/

//###################################################
void GP_GGA(void)
//###################################################
{
 unsigned char num;

//$GPGGA Meldung kommt immer zuerst !
 
// Speicher reicht nicht fr GP_GSV() !
// satcount=0; //Zhlt die Satelliten in Sicht

//Die Navimouse liefert bei kein Empfang keine Werte in $GPGGA
//Deshalb Koordinaten LCD-Ausgabe verlegt in $GPRMC

//Uhrzeit ignorieren
 GetLine(',');

//Koordinaten ignorieren
 GetLine(','); //bis zum nchsten ',' alles ignorieren
 GetLine(','); //bis zum nchsten ',' alles ignorieren
 GetLine(','); //bis zum nchsten ',' alles ignorieren
 GetLine(','); //bis zum nchsten ',' alles ignorieren

//Lsung 0=kein Empfang, 1=GPS, 2=DGPS
   num=GetLine(',');
   LCDPos(2,1);
   if(line[0]=='0' || num==0)
    { LCDWriteByte('?');
      RED_ON(); GREEN_OFF();
    }
   else
    { LCDWriteByte('!');
      RED_OFF(); GREEN_ON();
    }
  
//Anzahl benutzter Satelliten zwei Zeichen
   num=GetLine(',');
   LCDPos(2,2);
   if(num!=0) { LCDWrite(line); }

//Der Rest der "$GPGGA" Meldung ist uninteressant.
//Die Hhe die dort noch geliefert wird ist uerst ungenau

//Horizontal Dilution of Position
// GetLine(,);
//Hhe zum Meeresspiegel, kann auch negativ werden !
// GetLine(,);
//Einheit der Hhe meist M fr Meter
// GetLine(,);
//Geoidal separation (Diff. between WGS-84 earth ellipsoid and
//mean sea level.  -=geoid is below WGS-84 ellipsoid)
// GetLine(,);
//Einheit meist M fr Meter
// GetLine(,);
//Age in seconds since last update from diff. reference station
// GetLine(,);
//Diff. reference station ID#
// GetLine(,);
}


//###################################################
void GP_RMC(void)
//###################################################
{
 unsigned char c,i,num;
 unsigned int buf;
 unsigned long tempo;

//Als erstes kommt die Uhrzeit in UTC. Sommerzeit+2Std, Winterzeit+1Std
 LCDPos(1,11);
// LCDWriteByte(' '); //Evtl. Mll aus der Anzeige lschen
 num=GetLine(',');
//Interessant: SIRF liefert hier z.B. "hhmmss.xxx," Navimouse "hhmmss,"
//ohne Nachkommastellen
 line[6]=0;  //alles unter 1s brauch ich nicht
 if(num!=0) LCDWrite(line);

//Receiver Warning. Oben wird schon GPS-Fix angezeigt. Das reicht. 
 GetLine(','); //bis zum nchsten ',' alles ignorieren

//Dann kommen die Koordinaten, als erstes die Breite
 LCDPos(1,19);
// LCDWriteByte(' '); //Evtl. Mll aus der Anzeige lschen
 num=GetLine('.');

 if(num!=0) 
  {
   //Grad zweistellig, Minuten zweistellig
   LCDWriteByte(line[0]); LCDWriteByte(line[1]);
   LCDWriteByte(0xDF);
   LCDWriteByte(line[2]); LCDWriteByte(line[3]);
   LCDWriteByte('\'');

   num=GetLine(','); //Die Nachkommastellen abholen

   line[4]=0; //Nur 4 Stellen nehmen. Sirf-Chips geben manchmal 5 aus !
          //Sollten weniger als 4 Stellen ausgegeben werden, mu
          //der Teiler (167) unten angepasst werden !
             
   buf=atoi(line);
   buf/=(unsigned int)167;  //Eigentlich * 0.006 bzw. / 166.666666

   if(num!=0) 
    {
     itoa(buf,line,10);
     if(buf<10) LCDWriteByte('0');
     LCDWrite(line);
    }
  }
  
 num=GetLine(','); //Die Richtung N,S
 if(num!=0) LCDWriteByte(line[0]);

//Dann die Lnge
 LCDPos(2,18);
// LCDWriteByte(' '); //Evtl. Mll aus der Anzeige lschen
 num=GetLine('.');

  //Grad dreistellig, Minuten zweistellig
 if(num!=0)
  { 
//   if(line[0]>'0') LCDWriteByte(line[0]); //Gradzahl dreistellig
//   else LCDWriteByte(' '); //Sieht besser aus
   LCDWriteByte(line[0]); LCDWriteByte(line[1]); LCDWriteByte(line[2]);
   LCDWriteByte(0xDF);
   LCDWriteByte(line[3]); LCDWriteByte(line[4]);
   LCDWriteByte('\'');

   num=GetLine(','); //Die Nachkommastellen abholen

   line[4]=0; //Nur 4 Stellen nehmen. Sirf-Chips geben manchmal 5 aus !
          //Sollten weniger als 4 Stellen ausgegeben werden, mu
          //der Teiler (167) unten angepasst werden !

   buf=atoi(line);
   buf/=(unsigned int)167;  //Eigentlich * 0.006 bzw. / 166.666666

   if(num!=0)
    { 
     itoa(buf,line,10);
     if(buf<10) LCDWriteByte('0');
     LCDWrite(line);
    }
  
  }
  
 num=GetLine(','); //Die Richtung E,W
 if(num!=0) LCDWriteByte(line[0]);

//Geschwindigkeit in Knoten !
//Umrechnen in km/h = Knoten * 1,85 ungefhr
//atof() hat AVR-GCC leider noch nicht :(
 num=GetLine(',');
 if(num!=0) //Achtung: bei kein Empfang kommt keine Tempoangabe !
  {
//Zum testen 100.5 Knoten annehmen !! Ergebnis: 185.9 km/h
//line[0]='1'; line[1]='0'; line[2]='0'; line[3]='.'; line[4]='5'; line[5]='0'; line[6]='\0';

//Erstmal die Stellen vor dem Komma ermitteln
   i=0;   
   do {
       c=line[i];
       i++;
      }while(c!='.');

   line[i-1]=0;       //End of String auf dem '.' setzen
   tempo=atoi(line); 	//Stellen vor dem Komma zu int
   tempo*=10;        	//Kleiner Trick ;)
   tempo+=line[i]-'0'; //um Nachkommastellen zu addieren, eine Stelle reicht

   tempo*=185;                  //eigentlich * 1,85, siehe aber unten
   tempo/=1000;                  //wegen oben        
//   tempo/=100;                  //wegen oben        
//   c=(unsigned char)(tempo%10); //Nachkommastelle von tempo merken
//   tempo/=10;                   //wegen oben tempo*=10;
                        
   buf=(unsigned int)tempo;     //fr itoa() uint aus ulong machen

   LCDPos(2,5);
//   LCDWriteByte(' '); //Evtl. Mll aus der Anzeige lschen
   itoa(buf,line,10);
   if(buf<100) LCDWriteByte(' '); //Fhrende Nullen weg
   if(buf<10)  LCDWriteByte(' ');
   LCDWrite(line);

//   LCDWriteByte('.');
//   c+='0'; 	      		//int zu ASCII Nachkommastelle
//   LCDWriteByte(c);
  }

//Aktueller Kurs
 num=GetLine(',');
 LCDPos(1,5);
// LCDWriteByte(' '); //Evtl. Mll aus der Anzeige lschen
 if(num!=0) 
  {
   buf=atoi(line); //nimmt nur die Stellen vor dem Komma !
   if(buf<100) LCDWriteByte(' '); //Fhrende Nullen weg
   if(buf<10)  LCDWriteByte(' ');
   itoa(buf,line,10);
   LCDWrite(line);
   LCDWriteByte(0xDF); //Gradzeichen
//   LCDWriteByte(' ');
  }
    
//Datum
 LCDPos(2,11);
// LCDWriteByte(' '); //Evtl. Mll aus der Anzeige lschen
 num=GetLine(',');
 if(num!=0) LCDWrite(line);

/* Speicher reicht nicht fr GP_GSV() !
//Und zum Schlu die ber GPGSV ermittelte Anzahl Satelliten
//die wirklich in Sicht sind. Das sind alle die ein SNR>00 haben !
 itoa(satcount,line,10);
 LCDPos(1,1);
 LCDWriteByte(' '); //Evtl. Mll aus der Anzeige lschen
 if(satcount<10) LCDWriteByte('0');
 LCDWrite(line);

 //Lschen alter ungltiger SNR Werte
 //So ist es zwar aufwendiger, aber angenehmer fr die Augen !
 if(satcount<8) { LCDPos(2,37); LCDWrite("    "); }
 if(satcount<7) { LCDPos(2,34); LCDWrite("   "); }
 if(satcount<6) { LCDPos(2,31); LCDWrite("   "); }
 if(satcount<5) { LCDPos(2,28); LCDWrite("   "); }
 if(satcount<4) { LCDPos(1,37); LCDWrite("    "); }
 if(satcount<3) { LCDPos(1,34); LCDWrite("   "); }
 if(satcount<2) { LCDPos(1,31); LCDWrite("   "); }
 if(satcount<1) { LCDPos(1,28); LCDWrite("   "); }
*/ 
}


/*
void GP_GSA(void)
{
}

void GP_VTG(void)
{
}
*/
//#########################################################################
//
//Bisher verwendete Muse:
//Navimouse von Unitronic Softwarerevision 1999, also schon recht alt obwohl
//sie 2002 gekauft wurde.
//Chipsatz Rockwell
//Keine Pufferbatterie fr die Uhrzeit. Nur die letzte Koordinate wird behalten.
//Stromverbrauch 135mA
//
//GPS-Mouse von Tekelec Baujahr ca. 1999
//Chipsatz SIRF
//Pufferbatterie fr die Uhrzeit. Die letzte Koordinate wird behalten.
//Die Batterie ist aber irgendwann leer und mu ausgewechselt werden !
//Stromverbrauch 195mA
//Die SNR Werte sind durchweg um 3dB besser als bei der Navimouse
