// Datei: MYDEFS.H
//
// Meine Standarddefinitionen
//
// Holger Klabunde
// 02.08.2002
// Compiler AVR-GCC


#ifndef MYDEFS_H
#define MYDEFS_H 1

#define TAKT 8000000     		//Taktfrequenz in Hz
#define PRESCALE 1       		//Prescaler Timer1
#define TIME_OUT   20*TAKT/65536    	//Display alle 20s ganz lschen

#define sbi(portn, bitn) ((portn)|=(1<<(bitn)))
#define cbi(portn, bitn) ((portn)&=~(1<<(bitn)))
#define NOP() asm volatile ("nop" ::)

//Die beiden LED's
#define RED_ON() { cbi(PORTD,7); }
#define RED_OFF() { sbi(PORTD,7); }

#define GREEN_ON() { cbi(PORTD,6); }
#define GREEN_OFF() { sbi(PORTD,6); }

#define MODE	bit_is_set(PINA,PA0)	//Eingang fr Displaymode Umschaltung

#endif //MYDEFS_H
