#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/signal.h>
#include <stdlib.h>

#include "serial.h"
#include "mydefs.h"


#define RBUFLEN 8 //Pufferlnge fr seriellen Empfang

volatile unsigned char rbuf[RBUFLEN]; //Ringpuffer 
volatile unsigned char rcnt, rpos, recbuf;

volatile unsigned char busy;

//Receive Interruptroutine
SIGNAL(SIG_UART_RECV)      // signal handler for receive complete interrupt
{
 recbuf= UDR; //Byte auf jeden Fall abholen, sonst Endlosinterrupt

 // don't overwrite chars already in buffer
 if(rcnt < RBUFLEN)  rbuf[(rpos+rcnt++) % RBUFLEN] = recbuf;
}

//Transmit Interruptroutine
SIGNAL(SIG_UART_TRANS)     // signal handler for transmit complete interrupt
{
 cbi(UCSRB,TXEN); //ATmega Disable Transmit complete interrupt lschen
 busy=0; //Byte gesendet Flag rcksetzen
}

unsigned char ser_getc (void)
{
 unsigned char c;

 while(!rcnt) { };   // wait for character
//   if(!rcnt) return 0; //Nix im Puffer, dann raus

// cbi(UCR,RXCIE); //AVR Disable Receiveinterrupt
 cbi(UCSRB,RXCIE); //ATMega Disable Receiveinterrupt

 rcnt--;
 c = rbuf [rpos++];
 if (rpos >= RBUFLEN)  rpos = 0;

// sbi(UCR,RXCIE); //AVR Enable Receiveinterrupt
 sbi(UCSRB,RXCIE); //ATmega Enable Receiveinterrupt
 return (c);
}

/*
void ser_putc(unsigned char c)
{
//Nicht zu warten ist schlecht !
//Die Zeichenausgabe leidet dann !
  while(busy); //warten bis letztes Byte gesendet wurde
   
  sbi(UCSRB,TXEN); //ATmega Enable Transmit complete interrupt erlauben
  UDR=c;    //Byte in Sendepuffer
  busy = 1;        //Setze Flag Transmit gestartet
}

//ser_puts() strzt immer ab. Vermute kein RAM mehr ! Deshalb weggelassen
void ser_puts(unsigned char * s)
{
 unsigned char c;

   while((c=*s++))
    {
     if(c == '\n') //CR und LF senden bei \n
      {
       ser_putc(0x0D); //CR
       ser_putc(0x0A); //LF
      }
     else ser_putc(c);
    }
}
*/

void ser_init(void)
{
   rcnt = rpos = 0;  // init buffers
   busy = 0;

  // enable RxD/TxD and ints
// UCR=(1<<RXCIE) |(1<<TXCIE)|(1<<RXEN) |(1<<TXEN); //AVR
  UCSRB=(1<<RXCIE) |(1<<TXCIE)|(1<<RXEN) |(1<<TXEN); //AVR, ATMega
  UBRR=UART_BAUD_SELECT_4800; // set baudrate ATMega323
//  UBRRL=UART_BAUD_SELECT_4800; // set baudrate ATMega8
//  UCSRC=(1<<URSEL) | (1<<UCSZ1) | (1<<UCSZ0); //ATMega 8 Bit,1 Stop, no parity
}

