//###################################################################################
// File: gpsdisp.c
//
// Schaltung siehe AVR/ATMega Testboard Version 2.
// 2x40 Zeichen LCD-Anzeige fr eine GPS-Maus
// Baudrate fest 4800Baud. Das knnen alle GPS-Muse
// Die Maus mu die NMEA Meldungen GPGGA,GPGSV und GPRMC liefern
//###################################################################################
//
//   Satelliten in Sicht
//   |   
//   |  Kurs  Uhrzeit   Breite  Bis zu 8 SNR Werte von Satelliten in Sicht
//   |  |     |         |       |
//  ----------------------------------------
// | 06 120  104615  5419'16N 25 42 30 29 |
// |!05  43.4 310802  1007'02E 45 41       |
//  ----------------------------------------
//  ||   |    |         |
//  ||   |    Datum     Lnge
//  ||   |
//  ||   Tempo in km/h
//  ||
//  |Satelliten benutzt
//  | 
//  Gltigkeit der Position. '!' zeigt an gut, '?' zeigt an ungltig
//
// Uhrzeit,Datum in UTC. In Deutschland: Sommerzeit+2Std, Winterzeit+1Std.
//
// SNR Werte in der Reihenfolge so wie sie reinkommen.
//
//###################################################################################
//
// Manches GPS zeigt '!' auch bei nur ein oder zwei Satelliten.
// Bei weniger als drei Satelliten sollte man die gezeigte Position aber
// besser kritisch beurteilen.
//
//###################################################################################
// Compiler: AVR-GCC (Mingw32)
// Version : 3.4.3
//###################################################################################
// Processor: AT90S8515
//
// hk@holger-klabunde.de
// http://www.holger-klabunde.de
// Last change: 11.08.2005
//###################################################################################

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/signal.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>

#include "mydefs.h"
#include "protos.h"
#include "serial.h"

//Hier evtl. Chipset einstellen ! Fr Tekelec-Mouse = SIRF, Navimouse = ROCKWELL
//sonst alle #defines wegkommentieren. Scheint aber nicht ntig zu sein.
//#define SIRF		1
//#define ROCKWELL	1
//#define GARMIN        1 //nicht ausprobiert !

//"volatile" fr alle Variablen die in Interrupt's gendert werden
unsigned int volatile overflow;

char line[80];     //Zeichenpuffer

unsigned char satcount;
unsigned char gsvcount;

//###################################################################################
SIGNAL(SIG_OVERFLOW1)        /* signal handler for tcnt1 overflow interrupt */
//###################################################################################
{
 if(overflow>0) overflow--;
}

//###################################################################################
/* Hauptprogramm */
int main(void)
//###################################################################################
{
 unsigned char c;

 DDRC=0xFF;  	// set io-pins on PortC
 PORTC=0; 	//LCD-Datenbus

 DDRD=0xF0;  	// set io-pins on PortD
 PORTD=0; 	//LCD-Steuersignale siehe lcd.h

 DDRA=0; 	//Alles Eingnge
 PORTA=0x01; 	//Eingnge mit Pullups setzen

// SFIOR&=!(1<<PUD); 	//ATMega Pullups Enable
// SFIOR=0; 	//Pullups Enable

 LCDInit();
 ser_init();

//Timer1
 TCCR1A=0; 
 TCCR1B=0x01;        //Timer1 Start Takt = F/1
 TIMSK=(1<<TOIE1);   /* enable timer1 overflow int */
 sei();              //enable interrupts

 LCDCls();
 LCDWrite("GPS-Display");
 LCDPos(2,1);
 LCDWrite("2002 by Holgi");
 Delay1ms(1000);
 LCDCls();

 overflow=TIME_OUT;

//Ein paar Befehle zum GPS schicken, leider abhngig vom Hersteller !
//Es scheint die GPS aber nicht zu stren wenn sie Befehle anderer
//Hersteller bekommen. Deshalb die #ifdef entfernt.
//#ifdef ROCKWELL
//Navimouse: Checksumme am Ende nicht ntig
   ser_puts("$PRWIILOG,???,V,,,\n"); //Alle Messages abschalten
   Delay1ms(100);
   ser_puts("$PRWIILOG,GGA,A,T,1,0\n"); //GGA Message ein. Jede Sekunde
   Delay1ms(100);
   ser_puts("$PRWIILOG,RMC,A,T,1,0\n"); //RMC Message ein. Jede Sekunde
   Delay1ms(100);
//   ser_puts("$PRWIILOG,GSA,A,T,1,0\n"); //GSA Message ein. Jede Sekunde
//   Delay1ms(100);
   ser_puts("$PRWIILOG,GSV,A,T,1,0\n"); //GSV Message ein. Jede Sekunde
   Delay1ms(100);
//#endif

//#ifdef SIRF
//Checksumme am Ende erforderlich !
   //GPS knnte noch auf 9600 Baud stehen.
   UBRR=UART_BAUD_SELECT_9600; //Auf hhere Baudrate schalten
   Delay1ms(100);
   ser_puts("$PSRF100,1,4800,8,1,0*0E\n"); //Neue Baudrate zum GPS senden
   Delay1ms(100);
   UBRR=UART_BAUD_SELECT_4800; //und zurckschalten
   Delay1ms(100);

//   ser_puts("$PSRF103,01,00,00,01*25\n"); //GLL Message abschalten
//   ser_puts("$PSRF103,02,00,00,01*26\n"); //GSA Message abschalten
//   ser_puts("$PSRF103,03,00,00,01*27\n"); //GSV Message abschalten
//   ser_puts("$PSRF103,04,00,00,01*20\n"); //RMC Message abschalten
//   ser_puts("$PSRF103,05,00,00,01*21\n"); //VTG Message abschalten
  
   ser_puts("$PSRF103,00,00,01,01*25\n"); //GGA Message 1s einschalten
   Delay1ms(100);
   ser_puts("$PSRF103,04,00,01,01*21\n"); //RMC Message 1s einschalten
   Delay1ms(100);
   ser_puts("$PSRF103,03,00,01,01*26\n"); //GSV Message 1s einschalten
   Delay1ms(100);
//#endif

 for(;;) // Anfang Programm Endlosschleife
  {
   do { c=ser_getc(); }while(c!='$'); //Warte auf Anfang einer Message z.B. "$GPGGA"

   GetLine(','); //Hole den Header

   if(strcmp(line,"GPGGA")==0) GP_GGA();
   if(strcmp(line,"GPRMC")==0) GP_RMC();
   if(strcmp(line,"GPGSA")==0) GP_GSA();
   if(strcmp(line,"GPGSV")==0) GP_GSV();
   if(strcmp(line,"GPVTG")==0) GP_VTG();

  } // Ende Programm Endlosschleife
}

//###################################################################################
//Nicht sonderlich genau !!
void Delay1ms(unsigned int time)
//###################################################################################
{
 unsigned int i;

 for(i=0; i<time; i++) Delay100us(10);
}

//###################################################################################
//Nicht sonderlich genau !!
//time<=255 !!
void Delay100us(unsigned char time)
//###################################################################################
{
 unsigned char k,l;

 for(k=0; k<time; k++)
  {
   for(l=0; l<40; l++)
    {
     //Ein CPU-Clock = 0.125us bei 8MHz
     NOP(); NOP(); NOP(); NOP(); NOP(); NOP(); NOP(); NOP(); NOP(); NOP();  
     NOP(); NOP(); NOP(); NOP(); NOP(); NOP(); NOP(); NOP(); NOP(); NOP();  
    }
  }
}
