// Datei: LCD.C
//
// Ansteuerung einer LCD-Anzeige
// im 8 Bit Daten Mode
//
// Holger Klabunde
// 29.07.2002
// Compiler AVR-GCC

#include <avr/io.h>

#include "lcd.h"
#include "protos.h"
#include "mydefs.h"

//*******************************************
// Schreibt ein Datenbyte in die LCD-Anzeige
//*******************************************
void LCDWriteByte(unsigned char data)
{
 LCDCS_OFF();

 PORTC=data;
 
 LCDCS_ON();
 LCDCS_OFF();	

 Delay100us(1); //etwas auf die Anzeige warten
}

//**************************************************
//Schreibt einen Text in die LCD-Anzeige
//**************************************************
void LCDWrite(char *__putstr)
{
 char __ps;
 
  while((__ps = *__putstr))
   {
    __putstr++;
    if (__ps== 0) break;
    LCDWriteByte(__ps);
   }
}

//****************************************************
// Springt auf Zeile x und Position y der LCD-Anzeige 
// Gltig fr 2 Zeilen
//****************************************************
void LCDPos(unsigned char zeile,unsigned char position)
{
 unsigned char buff;

 LCDRS_OFF(); //Umschalten auf Kontrollregister

// 0x80 wegen Display Adress Set.
// Erste Position ist bei mir 1, nicht 0.
// Offset's
// Zeile 1 -> 0x00+0x80-0x01=0x7F
// Zeile 2 -> 0x40+0x80-0x01=0xBF 

 switch(zeile)
  {
   case 1: buff=0x7F+position; break;
   case 2: buff=0xBF+position; break;
   default : buff=0x80; break; //1,1
  }

 LCDWriteByte(buff); 
 LCDRS_ON(); //Umschalten auf Datenregister
 Wait();
}

//*****************************************
// Lscht die LCD Anzeige
// Cursor steht dann auf Position 1,Zeile 1
// Gilt auch fr mehrzeilige Anzeigen
//*****************************************
void LCDCls(void)
{
 LCDRS_OFF(); //Controlregister
 LCDWriteByte(0x01); //CLS
 LCDRS_ON(); //Umschalten auf Datenregister
 Wait();
}

//*********************************************
//Stellt die Funktionsweise der LCD Anzeige ein
//*********************************************
void LCDInit(void)
{
 int i;

 LCDRS_OFF();  //Control Register
 LCDCS_OFF();  //LCD-Anzeige anwhlen

//Software Reset laut Hitachi Datenblatt
 Delay1ms(255); //Mglichen Power On Reset abwarten
 for(i=0; i<3; i++)
  {
   PORTC=0x30;	//Auf den Port legen

   LCDCS_ON();	//schreiben
   LCDCS_OFF(); //LCD-Anzeige abwhlen
   Delay1ms(100); //Ein bichen warten auf die Anzeige
  }
//Ende Software Reset


//Der erste Schreibzugriff nach dem Reset ist ein 8 Bit
//Zugriff!! Also nur einmal schreiben, nicht Low-High Nibble.

//Um die 4Bit Operation einzuschalten
// lcdport=0x02;	//4 Bit Operation
// outp(lcdport,PORTB);	//Auf den Port legen
// LCDCS_ON();	//High Nibble schreiben
// Wait();

//Nach einfgen von Wait() = 5ms
//kommt die LCD Anzeige nach dem Einschalten immer.
//Ohne Wait's zeigte sie oft gar nix !
// LCDWriteByte(0x28);    //4 Bit Operation,2 Line,5x7 Font
 LCDWriteByte(0x38);    //8 Bit Operation,2 Line,5x7 Font
 Wait();
 LCDWriteByte(0x14); 	//Cursor Move,Right Shift
 Wait();

// LCDWriteByte(0x0F); 	//Display on, Cursor on ,Cursor blink
// LCDWriteByte(0x0E); 	//Display on, Cursor on ,Cursor no blink
 LCDWriteByte(0x0C); 	//Display on, Cursor off ,Cursor no blink
 Wait();

 LCDWriteByte(0x06); 	//Increment, Display Freeze
 Wait();
 LCDWriteByte(0x02); 	//Cursor Home
 Wait();
 LCDRS_ON();		//LCD-Datenregister
}

//Zeigt ein Byte im HexCode an
void ShowHex(unsigned char by)
{
 unsigned char buff;

 buff=by>>4; //Highnibble zuerst
 if(buff<10) buff+='0'; //ASCII Code erzeugen
 else buff+=0x37;        //Grobuchstaben
 LCDWriteByte(buff);

 buff=by&0x0f; //Danach das Lownibble
 if(buff<10) buff+='0'; //ASCII Code erzeugen
 else buff+=0x37;        //Grobuchstaben
 LCDWriteByte(buff);
}
