#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/signal.h>
#include <stdlib.h>

#include "serial.h"
#include "mydefs.h"

#define RBUFLEN 8 //Pufferlnge fr seriellen Empfang

volatile unsigned char rbuf[RBUFLEN]; //Ringpuffer 
volatile unsigned char rcnt, rpos, recbuf;

//volatile bit busy;
volatile unsigned char busy;

//Receive Interruptroutine
//SIGNAL(SIG_UART_RECV)  //AVR, ATMega signal handler for receive complete interrupt
SIGNAL(SIG_UART0_RECV)   //ATMega161 signal handler for receive complete interrupt
{
// recbuf= UDR; //AVR, ATMega Byte auf jeden Fall abholen, sonst Endlosinterrupt
 recbuf= UDR0; //ATMega161 Byte auf jeden Fall abholen, sonst Endlosinterrupt

 /* don't overwrite chars already in buffer */
 if(rcnt < RBUFLEN)  rbuf[(rpos+rcnt++) % RBUFLEN] = recbuf;
}

//Transmit Interruptroutine
//SIGNAL(SIG_UART_TRANS)  //AVR, ATMega signal handler for transmit complete interrupt
SIGNAL(SIG_UART0_TRANS)    //ATMega161 signal handler for transmit complete interrupt
{
// cbi(UCSRB,TXEN); //ATmega Disable Transmit complete interrupt lschen
 cbi(UCSR0B,TXEN0); //ATmega161 Disable Transmit complete interrupt lschen
 busy=0; //Byte gesendet Flag rcksetzen
}

unsigned char ser_getc (void)
{
 unsigned char c;

 while(!rcnt) { };   /* wait for character */
//   if(!rcnt) return 0; //Nix im Puffer, dann raus

// cbi(UCR,RXCIE); //AVR Disable Receiveinterrupt
// cbi(UCSRB,RXCIE); //ATMega Disable Receiveinterrupt
 cbi(UCSR0B,RXCIE0); //ATMega161 Disable Receiveinterrupt

 rcnt--;
 c = rbuf [rpos++];
 if (rpos >= RBUFLEN)  rpos = 0;

// sbi(UCR,RXCIE); //AVR Enable Receiveinterrupt
// sbi(UCSRB,RXCIE); //ATmega Enable Receiveinterrupt
 sbi(UCSR0B,RXCIE0); //ATmega161 Enable Receiveinterrupt
 return (c);
}

void ser_putc(unsigned char c)
{
//Nicht zu warten ist schlecht !
//Die Zeichenausgabe leidet dann !
  while(busy==1); //warten bis letztes Byte gesendet wurde
   
//  sbi(UCSRB,TXEN); //ATmega Enable Transmit complete interrupt erlauben
  sbi(UCSR0B,TXEN0); //ATmega161 Enable Transmit complete interrupt erlauben
//  UDR=c;    //AVR, ATMega Byte in Sendepuffer
  UDR0=c;    //ATMega161 Byte in Sendepuffer
  busy = 1;        //Setze Flag Transmit gestartet
}

void ser_puts(unsigned char * s)
{
 unsigned char c;

   while((c=*s++))
    {
     if(c == '\n') //CR und LF senden bei \n
      {
       ser_putc(0x0D); //CR
       ser_putc(0x0A); //LF
      }
     else ser_putc(c);
    }
}

//void new_line( void) {	sendstring("\n\r"); }

void ser_init(void)
{
   rcnt = rpos = 0;  /* init buffers */
   busy = 0;

  /* enable RxD/TxD and ints  */
// UCR=(1<<RXCIE) |(1<<TXCIE)|(1<<RXEN) |(1<<TXEN); //AVR
//  UCSRB=(1<<RXCIE) |(1<<TXCIE)|(1<<RXEN) |(1<<TXEN); //ATMega
  UCSR0B=(1<<RXCIE0) |(1<<TXCIE0)|(1<<RXEN0) |(1<<TXEN0); //ATMega161

//  UBRR=UART_BAUD_SELECT_4800; //AVR, ATMega set baudrate
  UBRR0=UART_BAUD_SELECT_4800;  //ATMega161
}
