//************************************************************************
// Draw.C
//
// Linien zeichnen, Strichbreite immer 1
// Rechtecke zeichnen und gefllte Flchen
// Optimiert auf schreiben von 8 Pixeln gleichzeitig
//
// Der Nullpunkt der Anzeige ist links oben
//
// hk@holger-klabunde.de
// www.holger-klabunde.de
// 12.01.2003
// Compiler AVR-GCC 3.2
//************************************************************************
#include <stdlib.h>
#include "protos.h"
#include "ks108.h"

unsigned char xcursor,ycursor;

//###################################################################
//GrafikCursor Position (im Speicher) setzen fr relative
//Zeichenfunktionen DrawLineAbs() und DrawLineRel(). 
void SetGCursor(unsigned char x, unsigned char y)
//###################################################################
{
 xcursor=x;
 ycursor=y;
}

//####################################################################
// Zeichnet eine Linie von xcursor,ycursor relativ nach dX,dY
// Wenn mode=0 wird der Grafik Cursor bewegt, mode>0 bewegt den Cursor
// nicht mit
//####################################################################
void DrawLineRel(int dx, int dy, unsigned char mode)
{
 unsigned char newx,newy;
 
 newx=(unsigned char)(xcursor+dx);
 newy=(unsigned char)(ycursor+dy);
 
 if(dx==0) DrawYLine(ycursor,newy,xcursor); //Vertikale Linie
 if(dy==0) DrawXLine(xcursor,newx,ycursor); //Horizontale Linie
 if(dx!=0 && dy!=0) DrawLine(xcursor,ycursor,newx,newy);//Schrge Linie
 
 if(mode==0)
  {
   xcursor=newx;
   ycursor=newy;
  }
}

//####################################################################
// Zeichnet eine Linie von xcursor,ycursor absolut nach X,Y
// Wenn mode=0 wird der Grafik Cursor bewegt, mode>0 bewegt den Cursor
// nicht mit
//####################################################################
void DrawLineAbs(unsigned char x, unsigned char y, unsigned char mode)
{
 if(xcursor==x) DrawYLine(ycursor,y,x);                     //Vertikale Linie
 if(ycursor==y) DrawXLine(xcursor,x,y);                     //Horizontale Linie
 if(xcursor!=x && ycursor!=y) DrawLine(xcursor,ycursor,x,y);//Schrge Linie
 
 if(mode==0)
  {
   xcursor=x;
   ycursor=y;
  }
}

//####################################################################
// Zeichnet eine Linie absolut von X1,Y1 bis X2,Y2
// Fr horizontal, vertikale Linien besser die anderen Funktionen
// DrawXLine(), DrawYLine() benutzen !
// Gefunden im Internet. http://www.prog.cz/swag/swag/graphics/
void DrawLine(unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2)
//####################################################################
{
 int x,y,count,xs,ys,xm,ym;

 x=(int)x1; y=(int)y1;
 xs=(int)x2-(int)x1; ys=(int)y2-(int)y1;
 if(xs<0) xm=-1; else if(xs>0) xm=1; else xm=0;
 if(ys<0) ym=-1; else if(ys>0) ym=1; else ym=0;
// xs=abs(xs);  ys=abs(ys);
 if(xs<0) xs=-xs;
 if(ys<0) ys=-ys;

 SetPixel((unsigned char)x,(unsigned char)y,1);

 if(xs>ys) // Flache Linie <45 Grad
  {
   count=-(xs/2);

   while(x!=x2 )
    {
     count=count+ys;
     x=x+xm;

     if(count>0)
      {
       y=y+ym;
       count=count-xs;
      }

     SetPixel((unsigned char)x,(unsigned char)y,1);
    }
   }
  else // Steile Linie >=45 Grad
   {
    count=-(ys/2);

    while(y!=y2)
	 {
      count=count+xs;
      y=y+ym;

      if(count>0)
       {
        x=x+xm;
        count=count-ys;
       }

      SetPixel((unsigned char)x,(unsigned char)y,1);
     }
   }
}

//####################################################################
// Zeichnet eine horizontale Linie absolut von X1 bis X2 auf Zeile Y
void DrawXLine(unsigned char x1, unsigned char x2, unsigned char y)
{
 unsigned char i,xstart,xend;

 if(x2>x1) //Immer von links nach rechts zeichnen
  { xstart=x1; xend=x2; }
 else
  { xstart=x2; xend=x1; }
 
 for(i=xstart; i<=xend; i++)
  {
   SetPixel(i,y,1);
  }
}

//##################################################################
// Zeichnet eine vertikale Linie absolut von Y1 bis Y2 auf Spalte X
void DrawYLine(unsigned char y1, unsigned char y2, unsigned char x)
{
 unsigned char i,ystart,yend;

 if(y2>y1)
  { ystart=y1; yend=y2; }
 else
  { ystart=y2; yend=y1; }

 for(i=ystart; i<=yend; i++)
  {
   SetPixel(x,i,1);
  }
}

//#########################################################################
// Zeichnet eine horizontale Linie mit Lnge len ab Position X auf Zeile Y
// Von links nach rechts
void DrawXLineLen(unsigned char x, unsigned char len, unsigned char y)
{ DrawXLine(x,x+len-1,y); }

//#########################################################################
// Zeichnet eine vertikale Linie mit Lnge len ab Position Y auf Spalte X 
// Von oben nach unten
void DrawYLineLen(unsigned char y, unsigned char len, unsigned char x)
{ DrawYLine(y,y+len-1,x); }

//#########################################################################
// Zeichnet ein Rechteck mit Breite width, Hhe height ab Position X,Y 
void DrawRect(unsigned char x, unsigned char y, unsigned char width, unsigned char height)
{
 DrawXLineLen(x,width,y);
 DrawXLineLen(x,width,y+height-1);
 DrawYLineLen(y,height,x);
 DrawYLineLen(y,height,x+width-1);
}

//#########################################################################
// Fllt ein Rechteck mit Breite width, Hhe height ab Position X,Y 
void FillRect(unsigned char x, unsigned char y, unsigned char width, unsigned char height)
{
 unsigned char i;

 for(i=y; i<(y+height); i++) DrawXLineLen(x,width,i);
}
