//#################################################################
//fontsoft.c
//
//Text mit Software Fonts schreiben
//
//Bisher fr Fonts bis 8 Pixel Breite und bis zu 16 Pixel Hhe
//Die Zeichenstze der Fonts sind nicht alle gleich !
//
//Die Fonts ohne xxxfv am Ende enthalten auch Zeichen unter 0x20
//Herzchen, Smiley usw
//
// hk@holger-klabunde.de
// www.holger-klabunde.de
// 14.10.2003
// Compiler MCC18
//#################################################################
#include "prozess.h"
#include "protos.h"
#include "ks108.h"

unsigned char fontwidth,fontheight;   //Breite,Hhe in Pixeln
unsigned char font;

//Irgendwie klappte es mit den Arrays und Pointern nicht wie bei AVR-GCC
//Deshalb etwas umstndlicher mit vielen if() Abfragen
//und der korrekten Angabe der Array Gren.
//Hauptsache es geht. Warum klr ich vieleicht spter mal ;)

//Namensgebung der Fonts: f[Hhe]x[Breite]
extern const rom unsigned char f8x6[256][6];
extern const rom unsigned char f8x8a[256][8];
extern const rom unsigned char f8x8b[256][8];
extern const rom unsigned char f16x8a[256][16];
extern const rom unsigned char f16x8b[256][16];
extern const rom unsigned char f16x8c[256][16];

extern const rom unsigned char f6x4fv[256][4]; 
extern const rom unsigned char f6x5fv[256][5]; 
extern const rom unsigned char f8x6fv[256][6]; 
extern const rom unsigned char f8x8fv[256][8]; 

//########################################################################
void SetFont(unsigned char num)
//Die Zuordnung mte mal nach Gre umsortiert werden
//########################################################################
{
 switch(num)
  {
   case 1: fontwidth=6; fontheight=8; font=1; break; //f8x6
   case 2: fontwidth=8; fontheight=8; font=2; break; //f8x8a
   case 3: fontwidth=8; fontheight=8; font=3; break; //f8x8b
   case 4: fontwidth=8; fontheight=16; font=4; break; //f16x8a
   case 5: fontwidth=8; fontheight=16; font=5; break; //f16x8b
   case 6: fontwidth=8; fontheight=16; font=6; break; //f16x8c
   case 7: fontwidth=4; fontheight=6; font=7; break; //f6x4fv
   case 8: fontwidth=5; fontheight=6; font=8; break; //f6x5fv
   case 9: fontwidth=6; fontheight=8; font=9; break; //f8x6fv
   case 10: fontwidth=8; fontheight=8; font=10; break; //f8x8fv
   default: fontwidth=0; fontheight=0; font=0; break;
  }
}

//########################################################################
//Schreibt ein einzelnes Zeichen an Position x,y
void LCDSoftChar(unsigned char ch, unsigned char xpos, unsigned char ypos)
//########################################################################
{
unsigned char by,mask;
unsigned char i,j;
rom unsigned char *ptr;

 if(font==0) return;

 SET_LEDS(0);

 for(i=0; i<fontwidth; i++) //ber die Breite des Zeichens
  {
   if(fontheight<=8)
    {
     if(font==1) ptr=&f8x6[ch][i]; //Ein Byte des Zeichens holen
     if(font==2) ptr=&f8x8a[ch][i]; //Ein Byte des Zeichens holen
     if(font==3) ptr=&f8x8b[ch][i]; //Ein Byte des Zeichens holen
     if(font==7) ptr=&f6x4fv[ch][i]; //Ein Byte des Zeichens holen
     if(font==8) ptr=&f6x5fv[ch][i]; //Ein Byte des Zeichens holen
     if(font==9) ptr=&f8x6fv[ch][i]; //Ein Byte des Zeichens holen
     if(font==10) ptr=&f8x8fv[ch][i]; //Ein Byte des Zeichens holen

     by=*ptr; //Ein Byte des Zeichens holen
     mask=0x01;               //Bei D0 anfangen

//Bei den kleinen Fonts wie 6x4 knnte man nicht benutzte Bits
//nicht schreiben um die Textzeilen eng bereinander zu plazieren,
//bzw. um angrenzende Grafikbereiche nicht zu lschen.
//Wenn man immer von oben nach unten schreibt geht es aber auch so.
     for(j=0; j<8; j++)
      {
       SetPixel(xpos+i,ypos+j,(by&mask));
       mask<<=1; //Nchstes Bit
      }//for j
    }//if(fontheight==8)
    
   if(fontheight>8 && fontheight<=16)
    {
     SET_LEDS(font);  //Debug
     
     if(font==4) ptr=&f16x8a[ch][i];
     if(font==5) ptr=&f16x8b[ch][i];
     if(font==6) ptr=&f16x8c[ch][i];
     by=*ptr;

     mask=0x01;               //Bei D0 anfangen
     for(j=0; j<8; j++)
      {
       SetPixel(xpos+i,ypos+j,(by&mask));
       mask<<=1; //Nchstes Bit
      }//for j

     if(font==4) ptr=&f16x8a[ch][i+8];
     if(font==5) ptr=&f16x8b[ch][i+8];
     if(font==6) ptr=&f16x8c[ch][i+8];
     by=*ptr;

     mask=0x01;               //Bei D0 anfangen
     for(j=0; j<8; j++)
      {
       SetPixel(xpos+i,ypos+j+8,(by&mask));
       mask<<=1; //Nchstes Bit
      }//for j
    }//if(fontheight>8....

  }//for i
}

//########################################################################
//Schreibt einen Text an Position x,y
//Mit automatischem Zeilenvorschub falls der Text zu lang war.
//Noch keine Steuerzeichen wie TAB,CR,LF integriert
void LCDSoftText(const rom char *__putstr, unsigned char xpos, unsigned char ypos)
//########################################################################
{
 char __ps;
 unsigned char xp,yp;

 if(fontwidth==0) return; //Kein Font ausgewhlt

 xp=xpos; yp=ypos;
 
 while((__ps = *__putstr))
  {
   __putstr++;
   if (__ps== 0) break;
   LCDSoftChar(__ps,xp,yp);
   xp+=fontwidth; //Nchstes Zeichen
   if(xp>=LCD_WIDTH) { xp=0; yp+=fontheight; } //Nchste Zeile
  }
}

//########################################################################
//Zeigt eine bersicht der im Font enthaltenen Zeichen
void ShowSoftFont(unsigned char num)
//########################################################################
{
 unsigned char i,xp,yp;
 
 ClearScreen();

 xp=0; yp=0;
 SetFont(num);
 
 for(i=0; i<255; i++)
  {
   LCDSoftChar(i,xp,yp);
   xp+=fontwidth; //Nchstes Zeichen
   if(xp>=LCD_WIDTH) { xp=0; yp+=fontheight; } //Nchste Zeile
  }
}
