//************************************************************************
// KS108.C
// LowLevel Routinen fr LCD-Displays mit KS0108
//
// Hier fr Displaytech 64240A
//
// Mit bis zu vier KS108 Chips also bis 240x64
// Ausgelegt bisher nur auf diesen Displaytyp
//
// Der Nullpunkt des Displays liegt oben,links. Fr unten rechts
// mssen dann zustzliche Umrechnungen stattfinden.
//
// hk@holger-klabunde.de
// www.holger-klabunde.de
// 20.10.2003
// Compiler MCC18
//************************************************************************
#include "prozess.h"
#include "protos.h"
#include "ks108.h"

//###################################################################################
// E ist die Bremse des Displays. Braucht ganz schn lange Delays.
// Geniale Angaben zum Timing im Datenblatt:
// 450ns Minimum fr E_low und E_high. Zusammen 1000ns. Fehlen schonmal 100ns.
// Und wo ist das Maximum ? Da ist raten angesagt.
void Wait_for_E(void)
//###################################################################################
{
//Anzahl NOP's fr 11.059MHz
 NOP(); NOP();  
 NOP(); NOP(); NOP(); NOP();
 //Wenn Pixel auf dem Display fehlen noch ein paar NOP's anfgen
}

//##########################################################
// Liest ein Byte aus dem Display
unsigned char ReadDisplay(void)
{
 unsigned char by;

 CheckBusy();

 RS_ON();
 RW_ON(); //Wir wollen lesen

//Display mu zweimal gelesen werden !
//Dummy Read
 E_ON();
 E_OFF();

 CheckBusy();
 DATA_DIR_IN();

 RS_ON();
 RW_ON(); //Wir wollen lesen

 E_ON();
 by=READ_DATA(); //DATA RAM lesen
 E_OFF();

 RW_OFF(); //zurck auf schreiben

 DATA_DIR_OUT();
 
 return by;
}

//##########################################################
//Ein Byte in das Display schreiben
//Register Select mu vorher entsprechend gesetzt werden !
void WriteDisplay(unsigned char dat)
{
 DATA_DIR_OUT();

 RW_OFF(); //Display schreiben setzen

 WRITE_DATA(dat);
 E_ON();
 E_OFF();

}

//##########################################################
//Pixel auf dem Display setzen
//mode=0; Pixel lschen
//mode>0; Pixel setzen
unsigned char SetPixel(unsigned char xpos, unsigned char ypos, unsigned char mode)
{
 unsigned char by,tmp,pixpos;
 unsigned char pixset;

 if(xpos>=LCD_WIDTH) return 1; //Punkt auerhalb der Anzeige
 if(ypos>=LCD_HEIGHT) return 1;

// if(mode==0) pixset=0;
// else pixset=1;
 pixset=mode; //Pixel gesetzt oder nicht erstmal merken

 SetPosition(xpos,ypos); //Position auf 8 Pixel genau setzen

 by=ReadDisplay();       //8 Pixel lesen

 tmp= ypos % 8; //Position des Pixels im Byte
 pixpos= 1 << tmp;             //An die richtige Position schieben

 if(pixset==1 && by&pixpos) return 0; //Pixel hatte den Wert schon
 if(pixset==0 && (by&pixpos)==0) return 0; //Pixel hatte den Wert schon

 if(pixset==0) by&=~pixpos; //Pixel lschen
 else by|=pixpos; //Pixel setzen

 SetPosition(xpos,ypos); //Position wird nach dem lesen verndert !
                         //Also neu setzen
 WriteDisplay(by);       //8 Pixel schreiben
 return 0;
}

//##########################################################
//Zustand des Pixels an Stelle x,y lesen
unsigned char GetPixel(unsigned char xpos, unsigned char ypos)
{
 int pixel;
 unsigned char by,tmp,pix;

 if(xpos>=LCD_WIDTH) return 1; //Punkt auerhalb der Anzeige
 if(ypos>=LCD_HEIGHT) return 1;

 SetPosition(xpos,ypos); //Position auf 8 Pixel genau setzen

 by=ReadDisplay();       //8 Pixel lesen

 tmp= ypos % 8; //Position des Pixels im Byte
 pix= 1 << tmp;                //An die richtige Position schieben

 if(by&pix) pixel=1; //war gesetzt
 else pixel=0;       //war nicht gesetzt

 return pixel;
}

//##########################################################
//Pagenummer des Chips setzen
unsigned char SetPageNumber(unsigned char num)
{
 unsigned char result;

 result=CheckBusy(); //Nachsehen ob Reset und Busy 0 sind
 if(result>0) return result; //Timeout vom Display !! nix tun.

 RS_OFF(); //Instruction setzen
 WriteDisplay(0xB8|num); //Pagenummer setzen

 RS_ON(); //Zurck auf Daten
 return 0;
}

//##########################################################
//Spaltennummer (X-Position) des Chips setzen
unsigned char SetRow(unsigned char xpos)
{
 unsigned char offs;
 unsigned char result;

 result=CheckBusy(); //Nachsehen ob Reset und Busy 0 sind
 if(result>0) return result; //Timeout vom Display !! nix tun.

 RS_OFF(); //Instruction setzen

//Spaltenoffset im Chip berechnen
 offs=xpos % 64; //Rest von xpos durch 64 bestimmen

 WriteDisplay(0x40|offs); //Spaltenummer setzen
 RS_ON(); //Zurck auf Daten
 return 0;
}

//##########################################################
//Gewnschte Koordinate auf dem Display einstellen
unsigned char SetPosition(unsigned char xpos, unsigned char ypos)
{
 unsigned char chip,page;

// wird oben schon gemacht
// if(xpos>=LCD_WIDTH) return 1; //Punkt auerhalb der Anzeige
// if(ypos>=LCD_HEIGHT) return 1;

 chip=GetChipNumber(xpos);
 page=GetPageNumber(ypos);

 SetChipNumber(chip); //Erst den Chip auswhlen
 SetPageNumber(page); //Dann die Page setzen
 SetRow(xpos);        //Zum Schlu die X-Position
 return 0;
}

//##########################################################
//An jeden KS0108 mu der DisplayOn Befehl gesendet werden
void DisplayOn(void)
{
 unsigned char result,i;

 INIT_CONTROL_PINS();

 E_OFF();

 for(i=0; i<4; i++)
  {
   SetChipNumber(i); 
   result=CheckBusy(); //Nachsehen ob Reset und Busy 0 sind
   if(result>0) return; //Timeout vom Display !! nix tun.

   RS_OFF(); //Instruction senden setzen
   WriteDisplay(0x3F); //Befehl Display On
   RS_ON(); //Zurck auf Daten
  } 

}

//##########################################################
void ClearScreen(void)
//##########################################################
{
/* die langsame Methode
 unsigned char x,y;

 for(y=0; y<LCD_HEIGHT; y++)
  for(x=0; x<LCD_WIDTH; x++) SetPixel(x,y,0);
*/
 unsigned char i,j,k;

 k=0;
 do
  {
   SetChipNumber(k); 

   for(j=0; j<8; j++)
    {
     SetPageNumber(j);
     CheckBusy();
     RS_ON();
     RW_OFF(); //Display schreiben setzen

     WRITE_DATA(0);
     for(i=0; i<64; i++)
      { E_ON(); Delay10us();
        E_OFF(); Delay10us();
      }
    }

  k++;
 }while(k<4);

}

//##########################################################
//Vor jeder Aktion des Displays nachsehen ob die letzte noch bearbeitet wird
//Testet Busy und Reset gleichzeitig.
//Beim Busy Check mu nur einmal gelesen werden !!
//
//BusyCheck kann man sich sparen. Keine klare Aussage im Datenblatt dazu
//und funktioniert irgendwie auch nicht. Also lassen wirs.
//Dummy Routine zu Timing Zwecken drin lassen !
unsigned char CheckBusy(void)
{
/*
 unsigned char by;
 unsigned long tout;

 DATA_DIR_IN();

 RW_ON(); //Wir wollen lesen
 RS_OFF(); //Busy lesen setzen

 E_ON();
 tout=0; //Timeoutzhler zurcksetzen
 do
  {
   by=READ_DATA();
   tout++;
  }while((by&0x80 || by&0x10) && tout<10000); //Warten bis DB7 und DB4 auf 0 sind
 E_OFF();

 RS_ON(); //RS immer auf Daten zurcksetzen


 if(tout>=10000)
  {
   return 1;
  }


 DATA_DIR_OUT();
*/

 return 0; //Schei auf das BusyBit
}

//##########################################################
//Aus der Y-Position die Pagenummer berechnen
/* wird nur einmal benutzt. MACRO draus gemacht
unsigned char GetPageNumber(unsigned char ypos)
{
 return ypos/8; //Jede Page ist 8 Zeilen hoch
}
*/

//##########################################################
//Aus der X-Position die Chipnummer berechnen
/* wird nur einmal benutzt. MACRO draus gemacht
unsigned char GetChipNumber(unsigned char xpos)
{
 return xpos/64; //Jeder Chip kontrolliert 64x64 Pixel
}
*/

//##########################################################
//Chipnummer des Displays setzen
/* zu langsam, MACRO draus gemacht das alle 4 Pins gleichzeitig bearbeitet
void SetChipNumber(unsigned char num)
{
 CS1_OFF(); CS2_OFF(); CS3_OFF(); CS4_OFF();
 switch(num)
  {
   case 0: CS1_ON(); break;
   case 1: CS2_ON(); break;
   case 2: CS3_ON(); break;
   case 3: CS4_ON(); break;
  }
 NOP(); NOP(); NOP();
}
*/
