//************************************************************************
// KS108.H
// LowLevel Routinen fr LCD-Displays mit KS0108
//
// Hier fr Displaytech 64240A
//
// hk@holger-klabunde.de
// www.holger-klabunde.de
// 20.10.2003
// Compiler MCC18
//************************************************************************

#ifndef KS108_H
#define KS108_H

//#####################################################
//# Number of NOP's below is based on 11.059MHz Clock #
//#####################################################

#define LCD_WIDTH	240  //Display Breite
#define LCD_HEIGHT	64   //Display Hhe

#define SET_LEDS(a) PORTC=~(a);

//PORTE is CTRL
//PORTD is DATA
#define INIT_CONTROL_PINS() { TRISD=0xFF; TRISE=0x00; RSTB_ON(); } //control pins to output

#define DATA_PORT	PORTD
#define DATA_DIR_IN()  	{ TRISD=0xFF; DATA_PORT=0xFF; } // set io-pins to inputs with pullups
#define DATA_DIR_OUT()	TRISD=0x00; // set io-pins to outputs
#define READ_DATA()   	PORTD	  // read PIN, ! NOT ! PORT
#define WRITE_DATA(a)  	DATA_PORT=(a); // write to data port

#define RS_ON()	       	{ PORTEbits.RE7=1; }
#define RS_OFF()       	{ PORTEbits.RE7=0; }

#define RW_ON()	       	{ PORTEbits.RE6=1; }
#define RW_OFF()       	{ PORTEbits.RE6=0; } //min 140ns

#define E_ON()	       	{ PORTEbits.RE5=1; Wait_for_E(); } //min 450ns
#define E_OFF()       	{ PORTEbits.RE5=0; Wait_for_E(); } //min 450ns

#define RSTB_ON()      	PORTEbits.RE4=1;
#define RSTB_OFF()     	PORTEbits.RE4=0;

#define CS1_ON()      	PORTEbits.RE0=1;
#define CS1_OFF()     	PORTEbits.RE0=0;

#define CS2_ON()      	PORTEbits.RE1=1;
#define CS2_OFF()     	PORTEbits.RE1=0;

#define CS3_ON()      	PORTEbits.RE2=1;
#define CS3_OFF()     	PORTEbits.RE2=0;

#define CS4_ON()      	PORTEbits.RE3=1;
#define CS4_OFF()     	PORTEbits.RE3=0;

//Alle CS Leitungen gleichzeitig bearbeiten
#define SetChipNumber(a) { PORTE&=0xF0; NOP(); PORTE|=(1<<(a)); }

//Aus der X-Position die Chipnummer berechnen
#define GetChipNumber(a) (a)/64 // xpos/64; Jeder Chip kontrolliert 64x64 Pixel
//Aus der Y-Position die Pagenummer berechnen
#define GetPageNumber(a) (a)/8 // ypos/8; //Jede Page ist 8 Zeilen hoch

extern unsigned char ReadDisplay(void);
extern void WriteDisplay(unsigned char dat);
extern unsigned char SetPixel(unsigned char xpos, unsigned char ypos, unsigned char mode);
extern unsigned char GetPixel(unsigned char xpos, unsigned char ypos);
//extern unsigned char GetChipNumber(unsigned char xpos);
//extern void SetChipNumber(unsigned char num);
//extern unsigned char GetPageNumber(unsigned char ypos);
extern unsigned char SetPageNumber(unsigned char num);
extern unsigned char SetRow(unsigned char xpos);
extern unsigned char SetPosition(unsigned char xpos, unsigned char ypos);
extern void DisplayOn(void);
extern void ClearScreen(void);
extern unsigned char CheckBusy(void);

#endif
