//************************************************************************
// Datei: display.c
// Hauptprogramm
//
// Demoprogramm um Text und Grafik auf
// T6963 Grafik-LCD-Display anzeigen
// Display: Winstar WG24064A 240x64 Pixel
//
// Erluterungen zu den Funktionen stehen in den entsprechenden
// *.c Dateien.
//
// hk@holger-klabunde.de
// www.holger-klabunde.de
// 20.10.2003
// Compiler MCC18
//************************************************************************
// Prozessor: 18F6720
//************************************************************************

#include <stdlib.h>
#include <string.h>

#include "prozess.h"
#include "protos.h"
#include "ks108.h"
#include "paul.h"
#include "demo.h"
#include "evilins.h"
#include "doggy.h"

//#include "serial.h"

int main(void)
{
 int i;

 ClrWdt();
 //Takt des PIC 20MHz, ein Zyklus = 200ns
// OPTION=0xC1; //Pullups off,Prescaler auf TMR0, 1:4

 T0CON=0b11000100; //Option gibts bei PIC18 nicht

 ADCON0=0;          //AD-Wandler aus
 ADCON1=0x06;       //Alle Analogeingnge auf digital

// PORTB=0b00000000;  
 PORTB=0;  
// PORTA=0b00000000;     
 PORTA=0;     
// PORTC=0b00111010;
// PORTC=0x3A;
 PORTC=0xff;
 TRISC=0x00;

// TRISB=0b11111111;  //0=Ausgang, 1=Eingang
// TRISB=0xFF;  //0=Ausgang, 1=Eingang
// TRISA=0b11111111;  //0=Ausgang, 1=Eingang
// TRISA=0xFF;  //0=Ausgang, 1=Eingang
// TRISC=0b10011000;  //
// TRISC=0x18;  //TRISC7,6 = 0 fr RS232 !

//I2C-Bus Modul einschalten
// SSPCON=0b00111000; //I2C-Master Mode
// SSPCON=0b00110110; //I2C-Slave Mode, 7Bit Adresse
// SSPCON1=0x36; //I2C-Slave Mode, 7Bit Adresse
// SSPADD=0x60;       //I2C Adresse des Pic setzen auf die er horchen soll
// SSPSTAT=0b10000000;  
// SSPSTAT=0x80;  
// SSPCON2=0;  

// T1CON=0b00100001;  //Prescaler TMR1 auf 1:4, ergibt Int alle 50ms.
// T1CON=0x21;  //Prescaler TMR1 auf 1:4, ergibt Int alle 50ms.
// PIE1bits.TMR1IE=1;          //Timer1 Int an fr Tastenabfrage

// INTCONbits.PEIE=1;            //Periphere Ints an
// PIE1bits.SSPIE=1;           //I2C-Interrupt an
// INTCONbits.GIE=1;             //Interrupts erlauben
 
// ser_init(); //Serielle Schnittstelle einstellen
// sei();              //enable interrupts

 DisplayOn();

//Beginn Endlosschleife
 while(1)
  {

 ClearScreen();
 SetGCursor(0,0);       //Macht ClearScreen() auch schon !
 DrawLineAbs(239,0,0);  //Die 0 hinten heit letzte Position merken
   Delay1ms(250);
 DrawLineAbs(239,63,0);
   Delay1ms(250);
 DrawLineAbs(0,0,0);    //ergibt ein groes Dreieck
   Delay1ms(250);

 SetGCursor(200,32);
 DrawLineRel(-10,-10,1); //Die 1 hinten heit letzte Position NICHT merken
   Delay1ms(250);
 DrawLineRel(5,-10,1);   //Strahlen zeichnen, alle mit demselben Ausgangspunkt
   Delay1ms(250);
 DrawLineRel(-10,5,1);
   Delay1ms(250);
 DrawLineRel(20,10,1);
   Delay1ms(250);

 SetGCursor(0,55);
 for(i=0; i<9; i++) //Eine merkwrdige Achse zeichnen
  {
   DrawLineRel(0,-5,1); //Strich nach oben, Cursor nicht ndern
   Delay1ms(250);
   DrawLineRel(5,5,1);  //Strich nach rechts unten, Cursor nicht ndern
   Delay1ms(250);
   DrawLineRel(10,-3,0);//Strich nach rechts oben, letzte Position merken 
   Delay1ms(250);
  }

 Delay1ms(3000);

 
/*
 ClearScreen();
 Circle(60,32,30,6); //Kreisrand nicht geschlossen
 Circle(60,32,20,3); //Kreisrand geschlossen
 Circle(60,32,10,3); //Kreisrand geschlossen

 FillCircle(140,32,30,2); //Bei step=3 gibts Lngsstreifen im Kreis
 FillCircle(180,10,10,6); //Keine Lngsstreifen im Kreis
 FillCircle(200,40,20,3); //Keine Lngsstreifen im Kreis
 Delay1ms(3000);
*/

 ClearScreen();
 LoadBitmap(paulbmp, 0 , 0, paulWIDTH, paulHEIGHT);   //Bitmap schnell laden
 LoadBitmap(paulbmp, 121 , 0, paulWIDTH, paulHEIGHT); //Bitmap langsam laden
 LoadBitmap(paulbmp, 199 , 32, paulWIDTH, paulHEIGHT); //Bitmap abschneiden
 Delay1ms(3000);

 ClearScreen();
 LoadBitmap(demobmp, 0 , 0, demoWIDTH, demoHEIGHT);   //Bitmap fllt ganzes Display
 Delay1ms(3000);

 ClearScreen();
 LoadBitmap(doggybmp, 0 , 0, doggyWIDTH, doggyHEIGHT);
 Delay1ms(3000);

 ClearScreen();
 LoadBitmap(evilinsbmp, 0 , 0, evilinsWIDTH, evilinsHEIGHT);
 Delay1ms(3000);

 ClearScreen();
 DrawRect(0,0,LCD_WIDTH,LCD_HEIGHT);     //Ganzen Bildschirm mit 3 Pixel Breite umranden
 DrawRect(1,1,LCD_WIDTH-2,LCD_HEIGHT-2);
 DrawRect(2,2,LCD_WIDTH-4,LCD_HEIGHT-4);
 
 FillRect(5,5,LCD_WIDTH-10,LCD_HEIGHT-10); //Groe Flche fllen, flimmert es ? ;)
 Delay1ms(3000);

 ClearScreen();                     
 DrawRect(0,0,LCD_WIDTH,LCD_HEIGHT);
 DrawLine(0,0,LCD_WIDTH,LCD_HEIGHT); //Schrge Linien zeichnen links nach rechts
 DrawLine(LCD_WIDTH,0,0,LCD_HEIGHT); //und andersrum
 DrawLine(0,0,LCD_WIDTH/2,LCD_HEIGHT); //Schrge Linien zeichnen links nach rechts
 DrawLine(LCD_WIDTH/2,0,0,LCD_HEIGHT); //und andersrum
 DrawLine(LCD_WIDTH/2,0,LCD_WIDTH,LCD_HEIGHT); //Schrge Linien zeichnen links nach rechts
 DrawLine(LCD_WIDTH,0,LCD_WIDTH/2,LCD_HEIGHT); //und andersrum
 Delay1ms(3000);

 ClearScreen();                     
//Software Fonts. Schreiben ist langsam, dafr auf einen Pixel genau plazierbar
 SetFont(1);
//Umlaute unter Windows hier im DOS-Modus eintippen !
 LCDSoftText("F8x6 SoftFont gjqy",0,0);
 SetFont(2);
 LCDSoftText("F8x8a SoftFont gjqy",0,9);
 SetFont(3);
 LCDSoftText("F8x8b SoftFont gjqy",0,18);
 SetFont(7);
 LCDSoftText("F6x4fv SoftFont gjqy",0,27);
 SetFont(8);
 LCDSoftText("F6x5fv SoftFont gjqy",0,36);
 SetFont(9);
 LCDSoftText("F8x6fv SoftFont gjqy",0,45);
 SetFont(10);
 LCDSoftText("F8x8fv SoftFont gjqy",0,54);
 Delay1ms(3000);

 ClearScreen();                     
//Software Fonts. Schreiben ist langsam, dafr auf einen Pixel genau plazierbar
 SetFont(4);
//Umlaute unter Windows hier im DOS-Modus eintippen !
 LCDSoftText("F16x8a SoftFont gjqy",0,0);
 SetFont(5);
 LCDSoftText("F16x8b SoftFont gjqy",0,18);
 SetFont(6);
 LCDSoftText("F16x8c SoftFont gjqy",0,36);
 Delay1ms(3000);


//bersicht aller Fonts anzeigen
 for(i=1; i<11; i++)
  {
   ShowSoftFont(i);
   Delay1ms(3000);
  }

  } //Endlosschleife
}
