//Datei: BINBCD8.C
// Wandelt eine 8Bit Binrzahl in BCD Bytes
//
// Nach dem Beispiel von Microchip CD
// Benutzen, nur nicht drber nachdenken !
//
// Holger Klabunde
// 01.05.2001
// Compiler CC5x

//Die Assembleruntersttzung von CC5x ist unter aller Sau.
//MPC und PICC Lite haben die Original Routine ohne groe
//Probleme angenommen.
 
//CC5x stellt sich an wenn inline.h #included wird.
//Assemblerbefehle zwischen #asm und #endasm mssen dann
//unbedingt klein geschrieben werden. Die Assemblerroutine
//von Microchip war direkt nicht zu bersetzen. Schuld war
//MOVLW R1/R0. Das wollte der Compiler nicht schlucken.
//Dann habe ich den Inline Befehl MOVLW(R1); benutzt.
//Da nahm er statt der Adresse von R1 den Inhalt von R1.
//In gewisser Weise ist das fr C ja auch richtig.
//MOVLW(&R1); hatte dann Erfolg. Daran ist Microchip
//schuld. Die htten zum laden von FSR lieber einen eigenen
//Befehl nehmen sollen :(
//
//Die Routine war danach aber in
//
//#asm
//#endasm
// C-Befehl
//#asm
//#endasm
// C-Befehl
//
//zerstckelt und schon ging das call adjBCD merkwrdigerweise
//nicht mehr. Die goto Befehle strte das nicht !
//Ich habe adjBCD dann eine eigene Routine spendiert und den
//grten Teil komplett in Inline-Assembler geschrieben.
//
//Als I-Tpfelchen wollte CC5x dann das addwf 0,W und movwf 0 nicht.
//Die 0 wurde wohl als Konstante und nicht als Registeradresse
//interpretiert. addwf INDF,W und movwf INDF ging dann.
//D.h.: Assemblerroutinen die Adressen fr Register benutzen mssen
//immer so umgeschrieben werden das sie mit Namen angesprochen werden.

#include "prozess.h"      /* Der verwendete Prozessor */
#include "protos.h"

//Input : 8 Bit Wert in B0
//Output: 8 Bit Globale Register  R0,R1
//        R0 = MSB, R1 = LSB
unsigned char B0;
unsigned char R0,R1;

void adjBCD();

void BinToBCD8()
{
 unsigned char counter;
 
 Carry=0; 
 counter=8; //8 Bits sind zu bearbeiten
 R0=0; R1=0;

loop8:
       //Rotiere B0 bitweise durch Carry in R1,R0
 RLF(B0,1);
 RLF(R1,1);
 RLF(R0,1);
 DECFSZ(counter,1); //ein Bit weniger
 goto adjDEC8;     //BCD Korrektur wenn noch Bits brig sind
 return;            //Sonst raus hier

adjDEC8:
 MOVLW(&R1);
 MOVWF(FSR);
 adjBCD();

 MOVLW(&R0);
 MOVWF(FSR);
 adjBCD();

 goto loop8;     //Nchstes von den 8 Bits
}

void adjBCD()
{
 unsigned char tmp;
 
#asm
        movlw 0x03     //Untere BCD-Stelle lade W mit 3
	addwf INDF,W      //0x03 addieren zu R0,R1 Ergebnis in W
	movwf tmp     //W zwischenspeichern fr Test Bit D3
	btfsc tmp,3   // test if bit 3 = 0
	movwf INDF        //war 1, dann W in Ergebnis speichern

	movlw 0x30     //Das gleiche mit der oberen BCD-Stelle
	addwf INDF,W
	movwf tmp
	btfsc tmp,7   
	movwf INDF    
#endasm
}

//Zeigt ein BCD-Byte auf der LCD-Anzeige
//oder eine Hexadezimalzahl
void ShowBCD(unsigned char x)
{
 unsigned char nib;

 nib=(x>>4); //High-Nibble

 if(nib<10) nib+=0x30; //ASCII Zahlen
 else nib+=0x37;  //ASCII Grobuchst.
 LCDWriteByte(nib);

 nib=x&0x0F; //Low-Nibble
 if(nib<10) nib+=0x30; //ASCII Zahlen
 else nib+=0x37;  //ASCII Grobuchst.
 LCDWriteByte(nib);
}
