// Datei: LCD.C
//
// Ansteuerung der LCD-Anzeige
// im 4 Bit Daten Mode
//
// Holger Klabunde
// Copyright 2000
// 03.05.2001
// Compiler CC5x

#include "prozess.h"      /* Der verwendete Prozessor */

#include "PhaseRec.h"
#include "lcd.h"
#include "protos.h"

unsigned char lcdport; //Register zum merken letzter Zustand 4094

//*******************************************
// Schreibt ein Datenbyte in die LCD-Anzeige
// Schreibt das Byte in zwei 4 Bit Nibbles
//*******************************************
void LCDWriteByte(unsigned char data)
{
 unsigned char buff;
 

 lcdport=PORTB;   //alten Wert merken
 
 LCDCS_OFF();

 buff=data>>4;   //High Nibble des Bytes
 lcdport=lcdport&0x0F;	//Hier D7-D4 ersma lschen zum
 lcdport|=(buff<<4);	//reinodern vom High Nibble

 LCDCS_ON();	      //High Nibble schreiben
 LCDCS_OFF();	

 buff=data&0x0F;        //Low Nibble des Bytes
 lcdport=lcdport&0x0F;	//D7-D4 ersma lschen zum
 lcdport|=(buff<<4);		//reinodern vom Low Nibble

 LCDCS_ON();	      //Low Nibble schreiben
 LCDCS_OFF();	
 Delay1ms(1); 	      //etwas auf die Anzeige warten
}

//**************************************************
//Schreibt einen Text in die LCD-Anzeige
//Geklaut aus dem LCD4.C Demo des MPC 1.2 Compilers
//**************************************************
void LCDWrite(const char *__putstr)
{
 char __ps;
 
 __ps = *__putstr;
 
  while(__ps>0)
   {
    __putstr++;
    if (__ps== 0) break;
    LCDWriteByte(__ps);
    __ps = *__putstr;
   }
}

//****************************************************
// Springt auf Zeile x und Position y der LCD-Anzeige 
// Gltig fr 2 Zeilen
//****************************************************
void LCDPos(unsigned char zeile,unsigned char position)
{
 unsigned char buff;

 LCDRS_OFF(); //Umschalten auf Kontrollregister

// 0x80 wegen Display Adress Set.
// Erste Position ist bei mir 1, nicht 0.
// Offset's
// Zeile 1 -> 0x00+0x80-0x01=0x7F
// Zeile 2 -> 0x40+0x80-0x01=0xBF 

 switch(zeile)
  {
   case 1: buff=0x7F+position; break;
   case 2: buff=0xBF+position; break;
   default : break;
  }

 LCDWriteByte(buff); 
 LCDRS_ON(); //Umschalten auf Datenregister
 Delay1ms(1); 	      //etwas auf die Anzeige warten
}

//*****************************************
// Lscht die LCD Anzeige
// Cursor steht dann auf Position 1,Zeile 1
// Gilt auch fr mehrzeilige Anzeigen
//*****************************************
void LCDCls()
{
 LCDRS_OFF(); //Controlregister
 LCDWriteByte(0x01); //CLS
 LCDRS_ON(); //Umschalten auf Datenregister
 Wait();
}

//*********************************************
//Stellt die Funktionsweise der LCD Anzeige ein
//*********************************************
void LCDInit()
{
 int i;

 LCDRS_OFF();  //Control Register
 LCDCS_OFF();  //LCD-Anzeige anwhlen

//Software Reset laut Hitachi Datenblatt
 Delay1ms(255); //Mglichen Power On Reset abwarten
 for(i=0; i<3; i++)
  {
   lcdport=lcdport&0x0F;//D7-D4 ersma lschen
   lcdport|=0x30;	//Wert reinodern
   PORTB=lcdport;	//Auf den Port legen

   LCDCS_ON();	//High Nibble schreiben
   LCDCS_OFF(); //LCD-Anzeige abwhlen
   Delay1ms(100); //Ein bichen warten auf die Anzeige
  }
//Ende Software Reset


//Der erste Schreibzugriff nach dem Reset ist ein 8 Bit
//Zugriff!! Also nur einmal schreiben, nicht Low-High Nibble.

//Um die 4Bit Operation einzuschalten
 lcdport=0x20;	//4 Bit Operation
 PORTB=lcdport;	//Auf den Port legen
 LCDCS_ON();	//High Nibble schreiben
 Wait();

 LCDWriteByte(0x28);    //4 Bit Operation,2 Line,5x7 Font
 Wait();
 LCDWriteByte(0x14); 	//Cursor Move,Right Shift
 Wait();

 LCDWriteByte(0x0C); 	//Display on, Cursor off ,Cursor no blink
 Wait();

 LCDWriteByte(0x06); 	//Increment, Display Freeze
 Wait();
 LCDWriteByte(0x02); 	//Cursor Home
 Wait();
 LCDRS_ON();		//LCD-Datenregister
}
