// Datei: Phaserec.c
// RC5 Empfnger und Code Anzeige
//
// Holger Klabunde 
// 11.02.2001
// Compiler Byte Craft MPC 1.3

#include "prozess.h"      // Der verwendete Prozessor

#include "Phaserec.h"
#include "protos.h"

unsigned char shift;   //Register fr die Abtastung
unsigned char subcode; //Der RC5 Gertecode
unsigned char comcode; //Der RC5 Kommandocode
unsigned char combuf;  //Puffer fr Kommandocode. Fr Verify
unsigned char subbuf;
unsigned char toggle;  //Das Togglebit

//*******************************************************
// Hauptprogramm
//*******************************************************
void main()
{
 unsigned char by,i;
 
 InitPIC(); //Hardware einstellen
 LCDInit(); //LCD-Anzeige initialisieren !!
 LCDCls();  //Sonst bleibt manchmal Dreck in der Anzeige stehen
 LCDWrite("Holgi's");
 LCDPos(2,1);
 LCDWrite("RC5 Test");
 
 shift=0; //Empfangsregister lschen
 
 while(1) // Programm-Endlosschleife
  {

   do
    {
     by=PhaseDemod(); //Warten auf RC5 Code
    }while(by==0);    //Bis by>0

   combuf=comcode; //Eben empfangenen Code speichern
   subbuf=subcode;

   do //Code ein zweites mal empfangen
    {
     by=PhaseDemod(); //Warten auf RC5 Code
    }while(by==0);    //Bis by>0


   if(comcode==combuf && subcode==subbuf) //Beide Codes gleich ?
    {
     LCDCls();
     LCDPos(1,1); LCDWrite("Ad:");
     B0=subcode; //Gertecode in BCD umrechnen
     BinToBCD8(); //Ergebnis in R1 !
     ShowBCD(R1); //Gertecode anzeigen

     LCDWrite(" T"); //ToggleBit anzeigen
     if(toggle==ONE) LCDWriteByte(0x31); //Eine 1
     else            LCDWriteByte(0x30); //Eine 0
     
     LCDPos(2,1); LCDWrite("Cm:");
     B0=comcode; //Kommandocode in BCD umrechnen
     BinToBCD8(); //Ergebnis in R1 !
     R0+=0x30;
     LCDWriteByte(R0);
     ShowBCD(R1); //Kommandocode anzeigen

     LED_OFF();  //Empfangsled lschen

     if(subcode==SUBID) //LED's an PORTA angesprochen ??
      {
       if(comcode==KEY4)
        {
         if(toggle==ONE) { LED4_ON(); }
         else { LED4_OFF(); }
        }

       if(comcode==KEY5)
        {
         if(toggle==ONE) { LED5_ON(); }
         else { LED5_OFF(); }
        }

       if(comcode==KEY6)
        {
         if(toggle==ONE) { LED6_ON(); }
         else { LED6_OFF(); }
        }

       if(comcode==KEY7)
        {
         if(toggle==ONE) { LED7_ON(); }
         else { LED7_OFF(); }
        }

      }

    } //if(comcode==combuf && subcode==subbuf)
   
  } //while(1) Endlosschleife

}
