//Datei: BIN2BCD.C
// Wandelt eine 8Bit Binrzahl in BCD Bytes
//
// Nach dem Beispiel von Microchip CD
// Benutzen, nur nicht drber nachdenken !
//
// Holger Klabunde
// 18.02.2000
// Compiler ByteCraft MPC V1.2

#include "prozess.h"      /* Der verwendete Prozessor */
#include "protos.h"

//Input : 8 Bit Wert in B0
//Output: 8 Bit Globale Register  R0,R1
//        R0 = MSB, R1 = LSB
unsigned char B0;
unsigned char R0,R1;

void BinToBCD8()
{
 unsigned char counter,temp;
 
#asm
    bcf STATUS,0   // clear the carry bit
	movlw 0x8     //8 Bits bearbeiten
	movwf counter  //Schleifenzhler
	clrf R0        //R0=0
	clrf R1
loop8   rlf B0     //Rotiere Bitweise in R1,R0
	rlf R1
	rlf R0
	decfsz counter  //Nchstes Bit
	goto adjDEC8
	RETLW 0

adjDEC8
        movlw R1        //Zeiger auf R1
	movwf FSR       //in FSR fr indirekte Adressierung
	call adjBCD     //BCD-Korrektur
	movlw R0        //Auch fr R0
	movwf FSR
	call adjBCD
	goto loop8     //Nchstes von den 8 Bits

//Register 0 zeigt auf R1 oder R0
adjBCD  movlw 0x03     //Untere BCD-Stelle testen
	addwf 0,W      //0x03 addieren zu R0,R1
	movwf temp     //zwischenspeichern fr Test Bit D3
	btfsc temp,3   
	movwf 0        

	movlw 0x30     //Das gleiche mit der oberen BCD-Stelle
	addwf 0,W
	movwf temp
	btfsc temp,7   
	movwf 0        // save as MSD
	RETLW 0        // Ergebnis in R0,R1 zurckgeben
#endasm
}

//Zeigt ein BCD-Byte auf der LCD-Anzeige
//oder eine Hexadezimalzahl
void ShowBCD(unsigned char x)
{
 unsigned char nib;

 nib=(x>>4) &0x0F; //High-Nibble

 if(nib<10) nib+=0x30; //ASCII Zahlen
 else nib+=0x37;  //ASCII Grobuchst.
 LCDWriteByte(nib);

 nib=x&0x0F; //Low-Nibble
 if(nib<10) nib+=0x30; //ASCII Zahlen
 else nib+=0x37;  //ASCII Grobuchst.
 LCDWriteByte(nib);
}

