// Datei: Phase.c
// Bi-Phasen RC5 Empfnger
//
// 28.04.2001
// Holger Klabunde 
//
// 12.09.2002
// Marco Ensing: Erweitert auf Extended RC5 Code
//
// Compiler Byte Craft MPC 1.3

#include "prozess.h"      // Der verwendete Prozessor

#include "phaserec.h"
#include "protos.h"

// Die Bi-Phasenmodulation arbeitet folgendermaen
// Eine 1 wird durch eine Flanke 0 -> 1 definiert
// Eine 0 wird durch eine Flanke 1 -> 0 definiert
// Der Empfnger invertiert die Bits !!!

// Die RC5-Pulsbreite betrgt 1,778ms
// PORTB.0 wird alle 890us abgetastet und in 2 Bits rotiert.

// Die einzig gltigen Werte sind dann
// 0x02 fr ein 1 Bit und 0x01 fr ein 0 Bit
// 0x00 sowie 0x03 sind nicht erlaubt und ein Kennzeichen
// fr keinen Empfang


//Auflsung des Timers 8 us
//RELOAD = 890us/8us = 111

//Wegen des Programm-Overheads ist der Timer mit 111 zu lang
//und die Abtastung rutscht nach rechts ber die Flanken
//Timerwert verkrzen
//So sollte es eigentlich sein
//#define RELOAD 255-111 //Alle 890us luft der Timer ber

#define DELAY	106
#define RELOAD 255-DELAY //So gehts

//verzgert um 890us, sampelt dann PORTB.0
//und schiebt das Bit in shift
void SampleBit()
{
 INTCON.T0IF=0;

 TMR0=RELOAD;    //Timer mit Abtastrate neu setzen
 while(!INTCON.T0IF); //Warten bis Timer berluft
 
//Porta.4 signalisiert Abtastung zum Debugging mit Oszi !
//Am besten im Code lassen um das Timing nicht neu
//einstellen zu mssen

 PULS_ON();  //Fr Debugging
 PULS_OFF();

 if(LED) LED=0; //Empfangsanzeige
 else LED=1;
 
 shift<<=1;      //alte Bits nach links schieben
 if(IR_IN==1)
  {
   shift|=0x01;  //Wert war positiv, merken !!
  }//Portb.0 sampeln und 1 Bits einfgen
  
 shift&=0x03;    //Nur die letzten beiden Bits sind gltig
}

unsigned char PhaseDemod()
{
    unsigned char mask,i;
    unsigned char msb;

    shift=0;
    msb = 0;

    //Als erstes kommt ein Startbit
    //Das benutze ich zum synchronisieren
    while(IR_IN==1); //Endloses Warten auf negative Flanke vom Empfnger
                     //Das ist das erste Startbit

    //Startbit 2
    //Extended RC5 Code: Wenn Startbit 2 == ZERO dann mu zum Kommandocode
    //64 addiert werden. Extended RC5 kann 128 statt 64 Befehle senden !
    INTCON.T0IF=0;

    //Versatz in die Abtastung bringen, damit nicht zu dicht
    //an den Flanken abgetastet wird
    TMR0=255-(DELAY>>1);    //Timer mit halber Abtastrate neu setzen
    while(!INTCON.T0IF); //Warten bis Timer berluft

    PULS_ON();  //Fr Debugging
    PULS_OFF();
     
    // Abtastung zweite startbit 
    SampleBit();
     
 
    SampleBit(); //Zweite Abtastung mit TMR0
    if(shift!=ONE && shift!=ZERO) //War kein Startbit, dann raus hier
    {
        return 0; 
    } 
    else
    {
        if(shift == ONE)
        {
            msb = 0;
        }      
        else
        {
            msb = 0x40; //b1000000
        }
        //Ende Startbit 2


        //Beginn ToggleBit
        SampleBit(); //Erste Abtastung
        SampleBit(); //Zweite Abtastung
        if(shift!=ONE && shift!=ZERO) return 0; //Kein gltiges Bit, dann raus hier
        toggle=shift; //Togglebit merken
        //Ende ToggleBit

        //Beginn Sub-Code
        //Hier kommt der 5 Bit Gertecode
        subcode=0; //Alten Sub-Code lschen
        mask=0x10; //Zum reinodern von 1 Bits, Beginn bei MSB

        for(i=0; i<5; i++)
        {
            SampleBit(); //Erste Abtastung
            SampleBit(); //Zweite Abtastung
            if(shift!=ONE && shift!=ZERO) return 0; //Kein gltiges Bit, dann raus hier

            if(shift==ONE) subcode|=mask; //Eins Bits in Subcode einfgen
   
            mask>>=1; //Nchstes Bit
        }
        //Ende Sub-Code

        //Beginn Kommando-Code
        //Hier kommt der 6 Bit Kommandocode
        comcode=0; //Kommando-Code lschen
        mask=0x20; //Zum reinodern von 1 Bits, Beginn bei MSB

        for(i=0; i<6; i++)
        {
            SampleBit(); //Erste Abtastung
            SampleBit(); //Zweite Abtastung
            if(shift!=ONE && shift!=ZERO) return 0; //Kein gltiges Bit, dann raus hier

            if(shift==ONE) comcode|=mask; //Eins Bits in Kommandocode einfgen
            mask>>=1; //Nchstes Bit
        }
        //Ende Kommando-Code
        comcode|=msb; // MSB fur die comcode setzen
        return 1; //Flag RC5-Code empfangen
    }
}
