//Datei: BIN2BCD.C
// Wandelt eine 8Bit Binrzahl in BCD Bytes
//
// Nach dem Beispiel von Microchip CD
// Benutzen, nur nicht drber nachdenken !
//
// Holger Klabunde
// 28.04.2001
// Compiler PICC Lite

#include "prozess.h"      /* Der verwendete Prozessor */
#include "protos.h"

//Input : 8 Bit Wert in B0
//Output: 8 Bit Globale Register  R0,R1
//        R0 = MSB, R1 = LSB
unsigned char B0;
unsigned char R0,R1;
unsigned char counter,temp;

void BinToBCD8()
{
 
#asm
    bcf _STATUS,0   // clear the carry bit
	movlw 0x8     //8 Bits bearbeiten
	movwf _counter  //Schleifenzhler
	clrf _R0        //R0=0
	clrf _R1
loop8   rlf _B0     //Rotiere Bitweise in R1,R0
	rlf _R1
	rlf _R0
	decfsz _counter  //Nchstes Bit
	goto adjDEC8
	RETLW 0

adjDEC8
        movlw _R1        //Zeiger auf R1
	movwf _FSR       //in FSR fr indirekte Adressierung
	call adjBCD     //BCD-Korrektur
	movlw _R0        //Auch fr R0
	movwf _FSR
	call adjBCD
	goto loop8     //Nchstes von den 8 Bits

//Register 0 zeigt auf R1 oder R0
adjBCD  movlw 0x03     //Untere BCD-Stelle testen
	addwf 0,W      //0x03 addieren zu R0,R1
	movwf _temp     //zwischenspeichern fr Test Bit D3
	btfsc _temp,3   
	movwf 0        

	movlw 0x30     //Das gleiche mit der oberen BCD-Stelle
	addwf 0,W
	movwf _temp
	btfsc _temp,7   
	movwf 0        // save as MSD
	RETLW 0        // Ergebnis in R0,R1 zurckgeben
#endasm
}

//Zeigt ein BCD-Byte auf der LCD-Anzeige
//oder eine Hexadezimalzahl
void ShowBCD(unsigned char x)
{
 unsigned char nib;

 nib=(x>>4) &0x0F; //High-Nibble

 if(nib<10) nib+=0x30; //ASCII Zahlen
 else nib+=0x37;  //ASCII Grobuchst.
 LCDWriteByte(nib);

 nib=x&0x0F; //Low-Nibble
 if(nib<10) nib+=0x30; //ASCII Zahlen
 else nib+=0x37;  //ASCII Grobuchst.
 LCDWriteByte(nib);
}

