// Datei: LCD.C
//
// Ansteuerung der LCD-Anzeige
// im 4 Bit Daten Mode
//
// Holger Klabunde
// 18.07.2005
// Compiler MCC18

#include <p18cxxx.h>

#include "lcd.h"
#include "delay.h"

unsigned char lcdport;

//Groe deutsche Umlaute in die selbstdefinierbaren
//Zeichen kopieren. Ein Standarddisplay hat diese nicht.
//Siehe auch CGRAM_LEN in lcd.h um weitere Zeichen
//hinzuzufgen.
const unsigned char mychardefs[] = {
//Adresse 0 im Character RAM
// '' 
17, 4, 10, 17, 31, 17, 17, 0,

//Adresse 1 im Character RAM
// '' 
17, 14, 17, 17, 17, 17, 14, 0,

//Adresse 2 im Character RAM
// ''
17, 0, 17, 17, 17, 17, 14, 0,

//Adresse 3 im Character RAM
// '\' 
//0, 16, 8, 4, 2, 1, 0, 0,

//Adresse 4 im Character RAM
// Der Euro 
//7, 8, 30, 8, 30, 8, 7, 0,

//Adresse 5 im Character RAM
//0, 0, 0, 0, 0, 0, 0, 0,
//Adresse 6 im Character RAM
//0, 0, 0, 0, 0, 0, 0, 0,
//Adresse 7 im Character RAM
//0, 0, 0, 0, 0, 0, 0, 0,
0
};

//*******************************************
// Schreibt ein Datenbyte in die LCD-Anzeige
// Schreibt das Byte in zwei 4 Bit Nibbles
//*******************************************
void LCDWriteByte(unsigned char data)
{
 unsigned char buff;
 

 lcdport=LCD_PORT;   //alten Wert merken
 
 LCDCS_OFF();

 buff=data>>4;   //High Nibble des Bytes
 lcdport=lcdport&0x0F;	//Hier D7-D4 ersma lschen zum
 lcdport|=(buff<<4);	//reinodern vom High Nibble

 LCDCS_ON();	      //High Nibble schreiben
 LCDCS_OFF();	

 buff=data&0x0F;        //Low Nibble des Bytes
 lcdport=lcdport&0x0F;	//D7-D4 ersma lschen zum
 lcdport|=(buff<<4);		//reinodern vom Low Nibble

 LCDCS_ON();	      //Low Nibble schreiben
 LCDCS_OFF();	
 Delay100us(1);       //etwas auf die Anzeige warten
}

//**************************************************
//Schreibt einen Buchstaben in die LCD-Anzeige
//**************************************************
void LCDWriteChar(char ps)
{
// if(ps<' ') return; //Codes kleiner Space besser nicht benutzen
 
 //bersetzungstabelle fr deutsche Umlaute
 switch(ps)
  {
   case '' : ps=0xE1; break; //Umlenkung auf neuen Zeichen Code
   case '' : ps=0xEF; break;
   case '' : ps=0xF5; break;
   case '' : ps=0xE2; break;
   case '' : ps=0x00; break; //Umlenkung ins Character RAM
   case '' : ps=0x01; break;
   case '' : ps=0x02; break;
   case '' : ps=0xDF; break;
   case '' : ps=0xE4; break;
   default: break;
  }
     
 LCDWriteByte(ps);
}

//****************************************************
// Springt auf Zeile x und Position y der LCD-Anzeige 
// Gltig bis 4 Zeilen bei 4x20.
// 4x24 oder 4x40 ??
//****************************************************
void LCDPos(unsigned char zeile,unsigned char position)
{
 unsigned char buff;

// 0x80 wegen Display Adress Set.
// Erste Position ist bei mir 1, nicht 0.
// Offset's
// Zeile 1 -> 0x80-0x01=0x7F
// Zeile 2 -> 0x40+0x80-0x01=0xBF 
// Zeile 3 -> 0x14+0x80-0x01=0x93 
// Zeile 4 -> 0x40+0x14+0x80-0x01=0xD3 
 
 switch(zeile)
  {
   case 1: buff=0x7F+position; break;
   case 2: buff=0xBF+position; break;
   case 3: buff=0x93+position; break;
   case 4: buff=0xD3+position; break;
   default : buff=0x80; break; //Ungltige Position. Neue => 1,1
  }

 LCDCommand(buff); 
}

//*****************************************
// Commando ans Display senden
//*****************************************
void LCDCommand(unsigned char mode)
{
 LCDRS_OFF(); //Controlregister
 LCDWriteByte(mode);
 LCDRS_ON(); //Zurck auf Datenregister
}

//*****************************************
// CGRam Adresse setzen
//*****************************************
void LCDCGAdr(unsigned char adr)
{
 unsigned char buf;
 buf=adr<<3;        //Adresse * 8
 buf+=0x40;         //CGRam Flag setzen
 LCDCommand(buf);
}

//*********************************************
//Stellt die Funktionsweise der LCD Anzeige ein
//*********************************************
void LCDInit()
{
 int i;

 LCDRS_OFF();  //Control Register
 LCDCS_OFF();  //LCD-Anzeige abwhlen

//Software Reset laut Hitachi Datenblatt
 Delay1ms(50); //Mglichen Power On Reset abwarten
 for(i=0; i<3; i++)
  {
   lcdport=lcdport&0x0F;//D7-D4 ersma lschen
   lcdport|=0x30;	//Wert reinodern
   LCD_PORT=lcdport;	//Auf den Port legen

   LCDCS_ON();	//High Nibble schreiben
   LCDCS_OFF(); //LCD-Anzeige abwhlen
   Delay1ms(50); //Ein bichen warten auf die Anzeige
  }
//Ende Software Reset


//Der erste Schreibzugriff nach dem Reset ist ein 8 Bit
//Zugriff!! Also nur einmal schreiben, nicht Low-High Nibble.

//Um die 4Bit Operation einzuschalten
 lcdport=0x20;	//4 Bit Operation
 LCD_PORT=lcdport;	//Auf den Port legen
 LCDCS_ON();	//High Nibble schreiben
 Delay1ms(5);

//Die Displays kmmern sich scheinbar nicht um das Bit fr
//die Anzahl der Zeilen. Bei mir klappte es so mit ein- und
//zweizeiligen Displays
 LCDWriteByte(0x28);    //4 Bit Operation,2 Line,5x7 Font
 Delay1ms(5);
 LCDWriteByte(0x14); 	//Cursor Move,Right Shift
 Delay1ms(5);

 LCDWriteByte(0x0C); 	//Display on, Cursor off ,Cursor no blink
 Delay1ms(5);

 LCDWriteByte(0x06); 	//Increment, Display Freeze
 Delay1ms(5);
 LCDWriteByte(0x02); 	//Cursor Home
 Delay1ms(5);
 LCDRS_ON();		//LCD-Datenregister

 LCDCommand(CLEAR_DISPLAY);
 Delay1ms(5);
 
//Die groen deutschen Umlaute ,, ins Character RAM CGRAM schreiben
//Standard LCD-Displays haben die nicht im Zeichensatz

//Der interne Adresszhler des LCD-Displays luft
//nach jedem Schreibzugriff automatisch hoch 

 LCDCGAdr(0); //CG_RAM Adresse(0) setzen

 for(i=0; i<CGRAM_LEN; i++) //8 Codes pro Zeichen bertragen
  {
   LCDWriteByte(mychardefs[i]);
  }

 LCDCommand(0x80); //DD_RAM Adresse 0 setzen, besser ist das
}
