// Datei: LCD.H
//
// Ansteuerung der LCD-Anzeige
// im 4 Bit Daten Mode
//
// Holger Klabunde
// 18.07.2005
// Compiler MCC18

#ifndef _LCD_H
#define _LCD_H

//Ausgnge fr die Ansteuerung der LCD-Anzeige
//PORTB.4..7 Datenleitungen der LCD-Anzeige
//#define LCD_RS	PORTB.2
//#define LCD_CS	PORTB.3

#define LCD_PORT	LATB

#define LCD_RS	0x04 //LCD Register Select
#define LCD_CS	0x08 //LCD Chip Select

#define LCDCS_ON() { lcdport|=LCD_CS; LCD_PORT=lcdport; }
#define LCDCS_OFF() { lcdport&=~LCD_CS; LCD_PORT=lcdport; }
#define LCDRS_ON() { lcdport|=LCD_RS; LCD_PORT=lcdport; }
#define LCDRS_OFF() { lcdport&=~LCD_RS; LCD_PORT=lcdport; }

//Kommandos fr das LCD-Display
#define CLEAR_DISPLAY 0x01
#define OFF_DISPLAY   0x08
#define CURSOR_OFF    0x0C
#define CURSOR_ON     0x0E
#define CURSOR_BLINK  0x0F
#define SHIFT_LEFT    0x18
#define SHIFT_RIGHT   0x1C

#define PREFIX		0xFE //Matrix Orbital Kommando Prefix

//Tabelle mit den groen deutschen Umlauten
//Htte man auch im EEPROM ablegen knnen
#define CGRAM_LEN	24  //Anzahl zu bertragender Zeichen


extern unsigned char lcdport;
extern void LCDInit(void);
extern void LCDPos(unsigned char,unsigned char);
extern void LCDWriteChar(char);
extern void LCDWriteByte(unsigned char);
extern void LCDCommand(unsigned char command);
extern void LCDCGAdr(unsigned char);

#endif //LCD_H
