/*********************************************************************
 * FileName:        user.c
 * Dependencies:    See INCLUDES section below
 * Processor:       PIC18
 * Compiler:        C18 2.30.01+
 * Company:
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Holger Klabunde      06/11/05    Modified CDC Demo
 ********************************************************************/

/******************************************************************************
 * CDC RS-232 Emulation of a Matrix Orbital Display
 ******************************************************************************
 * This is not a complete Emulation ! Some commands are not available.
 * But Commandset does function with LCD-Plugin for Winamp and LCD-Smartie
 * 
 * 
 *****************************************************************************/

/** I N C L U D E S **********************************************************/
#include <p18cxxx.h>
#include <usart.h>
#include "typedefs.h"

#include "usb.h"

#include "io_cfg.h"             // I/O pin mapping
#include "user.h"

#define BUFFER_SIZE	64

/** V A R I A B L E S ********************************************************/
#pragma udata
byte old_sw2;

byte nextstate; //contains NEXT state machine code for receiving 
byte cgram[9];  //cgram[8] ist die CG-RAM Adresse, 0..7 die Daten

char input_buffer[BUFFER_SIZE];
char output_buffer[BUFFER_SIZE];

/** P R I V A T E  P R O T O T Y P E S ***************************************/
void InitializeUSART(void);
void BlinkUSBStatus(void);
BOOL Switch2IsPressed(void);

/** D E C L A R A T I O N S **************************************************/
#pragma code
void UserInit(void)
{
    mInitAllLEDs();
    mInitAllSwitches();
    old_sw2 = sw2;
    
    InitializeUSART();

    T0CON=0b11000100; //Prescaler 1/32, Timer 8 Bit, Timer on
    LCDInit();   
    LCDWriteChar('O');
    LCDWriteChar('n');
    LCDWriteChar(' ');
    LCDWriteChar('!');

    nextstate=NO_STATE; //Reset State Machine
    
}//end UserInit

void InitializeUSART(void)
{
    TRISCbits.TRISC7=1; // RX
    TRISCbits.TRISC6=0; // TX
    SPBRG = 0x71;
    SPBRGH = 0x02;      // 0x0271 for 48MHz -> 19200 baud
    TXSTA = 0x24;       // TX enable BRGH=1
    RCSTA = 0x90;       // continuous RX
    BAUDCON = 0x08;     // BRG16 = 1
}//end InitializeUSART

/******************************************************************************
 * Function:        void ProcessIO(void)
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        This function is a place holder for other user routines.
 *                  It is a mixture of both USB and non-USB tasks.
 *
 * Note:            None
 *****************************************************************************/
void ProcessIO(void)
{   
 byte ch,i,len,col,row,buffcount;
 
    BlinkUSBStatus();
    // User Application USB tasks
    if((usb_device_state < CONFIGURED_STATE)||(UCONbits.SUSPND==1)) return;


//#####################################################################
// Because we don't know if a command is completly in the input buffer
// or not, we have to use a state maschine here
//#####################################################################

   len=getsUSBUSART(input_buffer, BUFFER_SIZE); //do we have some data ?
   if(len>0)
    {
     buffcount=0;
     do
      {
//This is for Markus Zehnder LCD-Plugin for Winamp
gotprefix: //This is a very ugly goto destination ;)

       ch=input_buffer[buffcount++];
       
       if(nextstate==NO_STATE && ch!=PREFIX)
        {
         LCDWriteChar(ch); //Alles andere ist Text
         continue;
        } 
       
       if(nextstate==NO_STATE && ch==PREFIX)
        {
         nextstate=STATE_COMMAND;
         continue;
        } 
       
//Viele Befehle werden hier nur abgefangen bzw. deren Parameter
//abgeholt damit sie nicht als Text ausgegeben werden ! 
       if(nextstate==STATE_COMMAND)
        {
//This is for Markus Zehnder LCD-Plugin for Winamp
         if(ch==PREFIX) { nextstate=STATE_COMMAND; goto gotprefix; } //aargh

         switch(ch)
          {
           case 'X': LCDCommand(CLEAR_DISPLAY); Delay1ms(5); nextstate=NO_STATE; break; //Clear Display
           case 'H': LCDPos(1,1); nextstate=NO_STATE; break; //Go To Top Left
           case 'G': nextstate=STATE_GETCOL; break; //Go To Position, Col, Row
           case 'P': nextstate=STATE_GETCONTRAST; break; //Contrast, Parameter abholen
           case 'B': nextstate=STATE_GETBACKLIGHT; break; //Backlight On, Parameter abholen
           case 'N': nextstate=STATE_GETCGADR; break; //Create Custom Character, 1 Byte Zeichennummer (0-7), 8 Databytes
           default: nextstate=NO_STATE; break;
          }//switch ch
          
         continue;
        }//if(nextstate==STATE_COMMAND)

       if(nextstate!=NO_STATE)
        {
//This is for Markus Zehnder LCD-Plugin for Winamp
         if(ch==PREFIX) { nextstate=STATE_COMMAND; goto gotprefix; } //aargh

         switch(nextstate)
          {
           case STATE_GETCOL: col=ch; nextstate=STATE_GETROW; break;
           case STATE_GETROW: row=ch; LCDPos(row,col); nextstate=NO_STATE; break;
           case STATE_GETCGADR: cgram[8]=ch; nextstate=STATE_GETCG0; break;
           case STATE_GETCG0:   cgram[0]=ch; nextstate=STATE_GETCG1; break;
           case STATE_GETCG1:   cgram[1]=ch; nextstate=STATE_GETCG2; break;
           case STATE_GETCG2:   cgram[2]=ch; nextstate=STATE_GETCG3; break;
           case STATE_GETCG3:   cgram[3]=ch; nextstate=STATE_GETCG4; break;
           case STATE_GETCG4:   cgram[4]=ch; nextstate=STATE_GETCG5; break;
           case STATE_GETCG5:   cgram[5]=ch; nextstate=STATE_GETCG6; break;
           case STATE_GETCG6:   cgram[6]=ch; nextstate=STATE_GETCG7; break;
           case STATE_GETCG7:
                cgram[7]=ch;
        
                LCDCGAdr(cgram[8]);		    //CG-RAM Adresse setzen
                for(i=0; i<8; i++) LCDWriteByte(cgram[i]); //CG-RAM Daten setzen

                LCDCommand(0x80); //DD_RAM Adresse 0 setzen, besser ist das
                nextstate=NO_STATE;
           break;
           case STATE_GETCONTRAST:
                //contrast=ch; //nicht benutzt, nur Parameter abholen
                nextstate=NO_STATE;
           break;
           case STATE_GETBACKLIGHT:
                //backlight=ch; //nicht benutzt, nur Parameter abholen
                         //0=immer an, 1-100 = an fr X Minuten
                nextstate=NO_STATE;
           break;
           default: nextstate=NO_STATE; break;
          }//switch(nextstate)
          
         continue;
        }//if(nextstate!=NO_STATE)
        
//        switch(ch)
//         {
//          
//          case 'F': break; //Backlight Off
//          case 'J': break; //Cursor On
//          case 'K': break; //Cursor Off
//          case 'L': break; //Cursor Left
//          case 'M': break; //Cursor Right
//          case 'S': break; //Cursor Blink On
//          case 'T': break; //Cursor Blink Off
//          case 'h': break; //Initialize Horizontal Bar Graph
//          case '|': break; //Make Horizontal Bar Graph, Spalte, Reihe, Richtung 0=R, Lnge 0-200 
//          case 'v': break; //Initialize Thick Vertical Bar Graph
//          case 's': break; //Initialize Thin Bar Vertical Graph
//          case '=': break; //Make Vertical Bar Graph, Spalte, Lnge
//          case 'C': break; //Auto Line Wrap On
//          case 'D': break; //Auto Line Wrap Off
//          case 'Q': break; //Auto Scroll On
//          case 'R': break; //Auto Scroll Off
//          case 'V': ch=Receive(); break; //General Purpose Output On, Parameter abholen
//          case 'W': ch=Receive(); break; //General Purpose Output Off, Parameter abholen
//          default: break;
//         }

     }while(buffcount<len);

/*
     if(mUSBUSARTIsTxTrfReady()) //Echo back complete buffer
      {
       mUSBUSARTTxRam((byte *)input_buffer, len);
      }
*/
    }//if(len>0) 

}//end ProcessIO




/******************************************************************************
 * Function:        void BlinkUSBStatus(void)
 * Overview:        BlinkUSBStatus turns on and off LEDs corresponding to
 *                  the USB device state.
 *
 * Note:            mLED macros can be found in io_cfg.h
 *                  usb_device_state is declared in usbmmap.c and is modified
 *                  in usbdrv.c, usbctrltrf.c, and usb9.c
 *****************************************************************************/
void BlinkUSBStatus(void)
{
    static word led_count=0;
    
    if(led_count == 0)led_count = 10000U;
    led_count--;

    #define mLED_Both_Off()         {mLED_1_Off();mLED_2_Off();}
    #define mLED_Both_On()          {mLED_1_On();mLED_2_On();}
    #define mLED_Only_1_On()        {mLED_1_On();mLED_2_Off();}
    #define mLED_Only_2_On()        {mLED_1_Off();mLED_2_On();}

    if(UCONbits.SUSPND == 1)
    {
        if(led_count==0)
        {
            mLED_1_Toggle();
            mLED_2 = mLED_1;        // Both blink at the same time
        }//end if
    }
    else
    {
        if(usb_device_state == DETACHED_STATE)
        {
            mLED_Both_Off();
        }
        else if(usb_device_state == ATTACHED_STATE)
        {
            mLED_Both_On();
        }
        else if(usb_device_state == POWERED_STATE)
        {
            mLED_Only_1_On();
        }
        else if(usb_device_state == DEFAULT_STATE)
        {
            mLED_Only_2_On();
        }
        else if(usb_device_state == ADDRESS_STATE)
        {
            if(led_count == 0)
            {
                mLED_1_Toggle();
                mLED_2_Off();
            }//end if
        }
        else if(usb_device_state == CONFIGURED_STATE)
        {
            if(led_count==0)
            {
                mLED_1_Toggle();
                mLED_2 = !mLED_1;       // Alternate blink                
            }//end if
        }//end if(...)
    }//end if(UCONbits.SUSPND...)

}//end BlinkUSBStatus

BOOL Switch2IsPressed(void)
{
    if(sw2 != old_sw2)
    {
        old_sw2 = sw2;                  // Save new value
        if(sw2 == 0)                    // If pressed
            return TRUE;                // Was pressed
    }//end if
    return FALSE;                       // Was not pressed
}//end Switch2IsPressed

/*
BOOL Switch3IsPressed(void)
{
    if(sw3 != old_sw3)
    {
        old_sw3 = sw3;                  // Save new value
        if(sw3 == 0)                    // If pressed
            return TRUE;                // Was pressed
    }//end if
    return FALSE;                       // Was not pressed
}//end Switch3IsPressed
*/
/** EOF user.c ***************************************************************/
