/*++

Module Name:

    ftd2def.h

    Native USB device driver for FTDI FT8U232/245
    http://www.ftdichip.com

    FTD2XX DLL function and prototype definitions

    ftd2def.h in conjunction with LoadFTDll.cpp does not
    require ftd2xx.lib to be linked. This is very usefull
    because ftd2xx.lib could not be linked with my
    VisualC++ V5.0 compiler. 
	
 hk@holger-klabunde.de
 www.holger-klabunde.de
 14.02.2003

--*/

#include <windows.h>
#include "ftd2xx.h" //include definitions from FTDI

#ifndef FTD2DEF_H
#define FTD2DEF_H

#ifdef __cplusplus
extern "C" {
#endif

extern int LoadFTDLL();
extern void UnloadFTDLL();
extern FT_HANDLE fthandle;
extern FT_STATUS ftstatus;


typedef FT_STATUS (WINAPI* DLL_FT_Close)(FT_HANDLE ftHandle);
extern DLL_FT_Close FT_Close;

typedef FT_STATUS (WINAPI* DLL_FT_ListDevices)(
	PVOID pArg1,
	PVOID pArg2,
	DWORD Flags
    );
extern DLL_FT_ListDevices FT_ListDevices;

typedef FT_STATUS (WINAPI* DLL_FT_Open)(
	int deviceNumber,
	FT_HANDLE *pHandle
	);
extern DLL_FT_Open FT_Open;

typedef FT_STATUS (WINAPI* DLL_FT_OpenEx)(
    PVOID pArg1,
    DWORD Flags,
    FT_HANDLE *pHandle
    );
extern DLL_FT_OpenEx FT_OpenEx;

typedef FT_STATUS (WINAPI* DLL_FT_Read)(
    FT_HANDLE ftHandle,
    LPVOID lpBuffer,
    DWORD nBufferSize,
    LPDWORD lpBytesReturned
    );
extern DLL_FT_Read FT_Read;

typedef FT_STATUS (WINAPI* DLL_FT_Write)(
    FT_HANDLE ftHandle,
    LPVOID lpBuffer,
    DWORD nBufferSize,
    LPDWORD lpBytesWritten
    );
extern DLL_FT_Write FT_Write;

typedef FT_STATUS (WINAPI* DLL_FT_IoCtl)(
    FT_HANDLE ftHandle,
    DWORD dwIoControlCode,
    LPVOID lpInBuf,
    DWORD nInBufSize,
    LPVOID lpOutBuf,
    DWORD nOutBufSize,
    LPDWORD lpBytesReturned,
    LPOVERLAPPED lpOverlapped
    );
extern DLL_FT_IoCtl FT_IoCtl;

typedef FT_STATUS (WINAPI* DLL_FT_SetBaudRate)(
    FT_HANDLE ftHandle,
	ULONG BaudRate
	);
extern DLL_FT_SetBaudRate FT_SetBaudRate;

typedef FT_STATUS (WINAPI* DLL_FT_SetDivisor)(
    FT_HANDLE ftHandle,
	USHORT Divisor
	);
extern DLL_FT_SetDivisor FT_SetDivisor;

typedef FT_STATUS (WINAPI* DLL_FT_SetDataCharacteristics)(
    FT_HANDLE ftHandle,
	UCHAR WordLength,
	UCHAR StopBits,
	UCHAR Parity
	);
extern DLL_FT_SetDataCharacteristics FT_SetDataCharacteristics;

typedef FT_STATUS (WINAPI* DLL_FT_SetFlowControl)(
    FT_HANDLE ftHandle,
    USHORT FlowControl,
    UCHAR XonChar,
    UCHAR XoffChar
	);
extern DLL_FT_SetFlowControl FT_SetFlowControl;

typedef FT_STATUS (WINAPI* DLL_FT_ResetDevice)(FT_HANDLE ftHandle);
extern DLL_FT_ResetDevice FT_ResetDevice;

typedef FT_STATUS (WINAPI* DLL_FT_SetDtr)(FT_HANDLE ftHandle);
extern DLL_FT_SetDtr FT_SetDtr;

typedef FT_STATUS (WINAPI* DLL_FT_ClrDtr)(FT_HANDLE ftHandle);
extern DLL_FT_ClrDtr FT_ClrDtr;

typedef FT_STATUS (WINAPI* DLL_FT_SetRts)(FT_HANDLE ftHandle);
extern DLL_FT_SetRts FT_SetRts;

typedef FT_STATUS (WINAPI* DLL_FT_ClrRts)(FT_HANDLE ftHandle);
extern DLL_FT_ClrRts FT_ClrRts;

typedef FT_STATUS (WINAPI* DLL_FT_GetModemStatus)(
    FT_HANDLE ftHandle,
	ULONG *pModemStatus
	);
extern DLL_FT_GetModemStatus FT_GetModemStatus;

typedef FT_STATUS (WINAPI* DLL_FT_SetChars)(
    FT_HANDLE ftHandle,
	UCHAR EventChar,
	UCHAR EventCharEnabled,
	UCHAR ErrorChar,
	UCHAR ErrorCharEnabled
    );
extern DLL_FT_SetChars FT_SetChars;

typedef FT_STATUS (WINAPI* DLL_FT_Purge)(
    FT_HANDLE ftHandle,
	ULONG Mask
	);
extern DLL_FT_Purge FT_Purge;

typedef FT_STATUS (WINAPI* DLL_FT_SetTimeouts)(
    FT_HANDLE ftHandle,
	ULONG ReadTimeout,
	ULONG WriteTimeout
	);
extern DLL_FT_SetTimeouts FT_SetTimeouts;

typedef FT_STATUS (WINAPI* DLL_FT_GetQueueStatus)(
    FT_HANDLE ftHandle,
	DWORD *dwRxBytes
	);
extern DLL_FT_GetQueueStatus FT_GetQueueStatus;

typedef FT_STATUS (WINAPI* DLL_FT_SetEventNotification)(
    FT_HANDLE ftHandle,
	DWORD Mask,
	PVOID Param
	);
extern DLL_FT_SetEventNotification FT_SetEventNotification;

typedef FT_STATUS (WINAPI* DLL_FT_GetStatus)(
    FT_HANDLE ftHandle,
    DWORD *dwRxBytes,
    DWORD *dwTxBytes,
    DWORD *dwEventDWord
	);
extern DLL_FT_GetStatus FT_GetStatus;

typedef FT_STATUS (WINAPI* DLL_FT_SetBreakOn)(FT_HANDLE ftHandle);
extern DLL_FT_SetBreakOn FT_SetBreakOn;

typedef FT_STATUS (WINAPI* DLL_FT_SetBreakOff)(FT_HANDLE ftHandle);
extern DLL_FT_SetBreakOff FT_SetBreakOff;

typedef FT_STATUS (WINAPI* DLL_FT_SetWaitMask)(
    FT_HANDLE ftHandle,
    DWORD Mask
    );
extern DLL_FT_SetWaitMask FT_SetWaitMask;

typedef FT_STATUS (WINAPI* DLL_FT_WaitOnMask)(
    FT_HANDLE ftHandle,
    DWORD *Mask
    );
extern DLL_FT_WaitOnMask FT_WaitOnMask;

typedef FT_STATUS (WINAPI* DLL_FT_GetEventStatus)(
    FT_HANDLE ftHandle,
    DWORD *dwEventDWord
    );
extern DLL_FT_GetEventStatus FT_GetEventStatus;

typedef FT_STATUS (WINAPI* DLL_FT_EE_Read)(
    FT_HANDLE ftHandle,
	PFT_PROGRAM_DATA pData
	);
extern DLL_FT_EE_Read FT_EE_Read;

typedef FT_STATUS (WINAPI* DLL_FT_ReadEE)(
    FT_HANDLE ftHandle,
	DWORD dwWordOffset,
    LPWORD lpwValue
	);
extern DLL_FT_ReadEE FT_ReadEE;

typedef FT_STATUS (WINAPI* DLL_FT_WriteEE)(
    FT_HANDLE ftHandle,
	DWORD dwWordOffset,
    WORD wValue
	);
extern DLL_FT_WriteEE FT_WriteEE;

typedef FT_STATUS (WINAPI* DLL_FT_EraseEE)(
    FT_HANDLE ftHandle
	);
extern DLL_FT_EraseEE FT_EraseEE;


typedef FT_STATUS (WINAPI* DLL_FT_EE_Program)(
    FT_HANDLE ftHandle,
	PFT_PROGRAM_DATA pData
	);
extern DLL_FT_EE_Program FT_EE_Program;

typedef FT_STATUS (WINAPI* DLL_FT_EE_UASize)(
    FT_HANDLE ftHandle,
	LPDWORD lpdwSize
	);
extern DLL_FT_EE_UASize FT_EE_UASize;

typedef FT_STATUS (WINAPI* DLL_FT_EE_UAWrite)(
    FT_HANDLE ftHandle,
	PUCHAR pucData,
	DWORD dwDataLen
	);
extern DLL_FT_EE_UAWrite FT_EE_UAWrite;

typedef FT_STATUS (WINAPI* DLL_FT_EE_UARead)(
    FT_HANDLE ftHandle,
	PUCHAR pucData,
	DWORD dwDataLen,
	LPDWORD lpdwBytesRead
	);
extern DLL_FT_EE_UARead FT_EE_UARead;

typedef FT_STATUS (WINAPI* DLL_FT_SetLatencyTimer)(
    FT_HANDLE ftHandle,
    UCHAR ucLatency
    );
extern DLL_FT_SetLatencyTimer FT_SetLatencyTimer;

typedef FT_STATUS (WINAPI* DLL_FT_GetLatencyTimer)(
    FT_HANDLE ftHandle,
    PUCHAR pucLatency
    );
extern DLL_FT_GetLatencyTimer FT_GetLatencyTimer;

typedef FT_STATUS (WINAPI* DLL_FT_SetBitMode)(
    FT_HANDLE ftHandle,
    UCHAR ucMask,
	UCHAR ucEnable
    );
extern DLL_FT_SetBitMode FT_SetBitMode;

typedef FT_STATUS (WINAPI* DLL_FT_GetBitMode)(
    FT_HANDLE ftHandle,
    PUCHAR pucMode
    );
extern DLL_FT_GetBitMode FT_GetBitMode;

typedef FT_STATUS (WINAPI* DLL_FT_SetUSBParameters)(
    FT_HANDLE ftHandle,
    ULONG ulInTransferSize,
    ULONG ulOutTransferSize
    );
extern DLL_FT_SetUSBParameters FT_SetUSBParameters;

//
// Win32-type functions
//
typedef FT_HANDLE (WINAPI* DLL_FT_W32_CreateFile)(
	LPCSTR					lpszName,
	DWORD					dwAccess,
	DWORD					dwShareMode,
	LPSECURITY_ATTRIBUTES	lpSecurityAttributes,
	DWORD					dwCreate,
	DWORD					dwAttrsAndFlags,
	HANDLE					hTemplate
	);
extern DLL_FT_W32_CreateFile FT_W32_CreateFile;

typedef BOOL (WINAPI* DLL_FT_W32_CloseHandle)(
    FT_HANDLE ftHandle
	);
extern DLL_FT_W32_CloseHandle FT_W32_CloseHandle;

typedef BOOL (WINAPI* DLL_FT_W32_ReadFile)(
    FT_HANDLE ftHandle,
    LPVOID lpBuffer,
    DWORD nBufferSize,
    LPDWORD lpBytesReturned,
	LPOVERLAPPED lpOverlapped
    );
extern DLL_FT_W32_ReadFile FT_W32_ReadFile;

typedef BOOL (WINAPI* DLL_FT_W32_WriteFile)(
    FT_HANDLE ftHandle,
    LPVOID lpBuffer,
    DWORD nBufferSize,
    LPDWORD lpBytesWritten,
	LPOVERLAPPED lpOverlapped
    );
extern DLL_FT_W32_WriteFile FT_W32_WriteFile;

typedef DWORD (WINAPI* DLL_FT_W32_GetLastError)(
    FT_HANDLE ftHandle
    );
extern DLL_FT_W32_GetLastError FT_W32_GetLastError;

typedef BOOL (WINAPI* DLL_FT_W32_GetOverlappedResult)(
    FT_HANDLE ftHandle,
	LPOVERLAPPED lpOverlapped,
    LPDWORD lpdwBytesTransferred,
	BOOL bWait
    );
extern DLL_FT_W32_GetOverlappedResult FT_W32_GetOverlappedResult;

//
// Win32 COMM API type functions
//

typedef BOOL (WINAPI* DLL_FT_W32_ClearCommBreak)(
    FT_HANDLE ftHandle
	);
extern DLL_FT_W32_ClearCommBreak FT_W32_ClearCommBreak;

typedef BOOL (WINAPI* DLL_FT_W32_ClearCommError)(
    FT_HANDLE ftHandle,
	LPDWORD lpdwErrors,
    LPFTCOMSTAT lpftComstat
	);
extern DLL_FT_W32_ClearCommError FT_W32_ClearCommError;

typedef BOOL (WINAPI* DLL_FT_W32_EscapeCommFunction)(
    FT_HANDLE ftHandle,
	DWORD dwFunc
	);
extern DLL_FT_W32_EscapeCommFunction FT_W32_EscapeCommFunction;

typedef BOOL (WINAPI* DLL_FT_W32_GetCommModemStatus)(
    FT_HANDLE ftHandle,
	LPDWORD lpdwModemStatus
	);
extern DLL_FT_W32_GetCommModemStatus FT_W32_GetCommModemStatus;

typedef BOOL (WINAPI* DLL_FT_W32_GetCommState)(
    FT_HANDLE ftHandle,
    LPFTDCB lpftDcb
	);
extern DLL_FT_W32_GetCommState FT_W32_GetCommState;

typedef BOOL (WINAPI* DLL_FT_W32_GetCommTimeouts)(
    FT_HANDLE ftHandle,
    FTTIMEOUTS *pTimeouts
	);
extern DLL_FT_W32_GetCommTimeouts FT_W32_GetCommTimeouts;

typedef BOOL (WINAPI* DLL_FT_W32_PurgeComm)(
    FT_HANDLE ftHandle,
	DWORD dwMask
	);
extern DLL_FT_W32_PurgeComm FT_W32_PurgeComm;

typedef BOOL (WINAPI* DLL_FT_W32_SetCommBreak)(
    FT_HANDLE ftHandle
	);
extern DLL_FT_W32_SetCommBreak FT_W32_SetCommBreak;

typedef BOOL (WINAPI* DLL_FT_W32_SetCommMask)(
    FT_HANDLE ftHandle,
    ULONG ulEventMask
    );
extern DLL_FT_W32_SetCommMask FT_W32_SetCommMask;

typedef BOOL (WINAPI* DLL_FT_W32_SetCommState)(
    FT_HANDLE ftHandle,
    LPFTDCB lpftDcb
	);
extern DLL_FT_W32_SetCommState FT_W32_SetCommState;

typedef BOOL (WINAPI* DLL_FT_W32_SetCommTimeouts)(
    FT_HANDLE ftHandle,
    FTTIMEOUTS *pTimeouts
	);
extern DLL_FT_W32_SetCommTimeouts FT_W32_SetCommTimeouts;

typedef BOOL (WINAPI* DLL_FT_W32_SetupComm)(
    FT_HANDLE ftHandle,
	DWORD dwReadBufferSize,
	DWORD dwWriteBufferSize
	);
extern DLL_FT_W32_SetupComm FT_W32_SetupComm;

typedef BOOL (WINAPI* DLL_FT_W32_WaitCommEvent)(
    FT_HANDLE ftHandle,
    PULONG pulEvent,
	LPOVERLAPPED lpOverlapped
    );
extern DLL_FT_W32_WaitCommEvent FT_W32_WaitCommEvent;

#ifdef __cplusplus
}
#endif


#endif  /* FTD2XX_H */

