//---------------------------------------------------------------------------
// LoadFTDll.cpp
//
//    Native USB device driver for FTDI FT8U232/245
//    http://www.ftdichip.com
//
//    FTD2XX DLL function and prototype definitions
//
//    ftd2def.h in conjunction with LoadFTDll.cpp does not
//    require ftd2xx.lib to be linked. This is very usefull
//    because ftd2xx.lib could not be linked with my
//    VisualC++ V5.0 compiler. 
//	
// hk@holger-klabunde.de
// www.holger-klabunde.de
// 15.02.2003
//---------------------------------------------------------------------------

#include <windows.h>

#include "ftd2xx.h"
#include "ftd2def.h"

DLL_FT_Close       FT_Close;
DLL_FT_ListDevices FT_ListDevices;
DLL_FT_Open        FT_Open;
DLL_FT_OpenEx      FT_OpenEx;
DLL_FT_Read        FT_Read;
DLL_FT_Write       FT_Write;
DLL_FT_IoCtl       FT_IoCtl;
DLL_FT_SetBaudRate FT_SetBaudRate;
DLL_FT_SetDivisor  FT_SetDivisor;
DLL_FT_SetDataCharacteristics FT_SetDataCharacteristics;
DLL_FT_SetFlowControl FT_SetFlowControl;
DLL_FT_ResetDevice FT_ResetDevice;
DLL_FT_SetDtr      FT_SetDtr;
DLL_FT_ClrDtr      FT_ClrDtr;
DLL_FT_SetRts      FT_SetRts;
DLL_FT_ClrRts      FT_ClrRts;
DLL_FT_GetModemStatus FT_GetModemStatus;
DLL_FT_SetChars    FT_SetChars;
DLL_FT_Purge       FT_Purge;
DLL_FT_SetTimeouts FT_SetTimeouts;
DLL_FT_GetQueueStatus FT_GetQueueStatus;
DLL_FT_SetEventNotification FT_SetEventNotification;
DLL_FT_GetStatus   FT_GetStatus;
DLL_FT_SetBreakOn  FT_SetBreakOn;
DLL_FT_SetBreakOff FT_SetBreakOff;
DLL_FT_SetWaitMask FT_SetWaitMask;
DLL_FT_WaitOnMask  FT_WaitOnMask;
DLL_FT_GetEventStatus FT_GetEventStatus;

DLL_FT_EE_Read     FT_EE_Read;
DLL_FT_ReadEE      FT_ReadEE;
DLL_FT_WriteEE     FT_WriteEE;
DLL_FT_EraseEE     FT_EraseEE;
DLL_FT_EE_Program  FT_EE_Program;
DLL_FT_EE_UASize   FT_EE_UASize;
DLL_FT_EE_UAWrite  FT_EE_UAWrite;
DLL_FT_EE_UARead   FT_EE_UARead;

DLL_FT_SetLatencyTimer FT_SetLatencyTimer;
DLL_FT_GetLatencyTimer FT_GetLatencyTimer;
DLL_FT_SetBitMode  FT_SetBitMode;
DLL_FT_GetBitMode  FT_GetBitMode;
DLL_FT_SetUSBParameters FT_SetUSBParameters;

DLL_FT_W32_CreateFile FT_W32_CreateFile;
DLL_FT_W32_CloseHandle FT_W32_CloseHandle;
DLL_FT_W32_ReadFile FT_W32_ReadFile;
DLL_FT_W32_WriteFile FT_W32_WriteFile;
DLL_FT_W32_GetLastError FT_W32_GetLastError;
DLL_FT_W32_GetOverlappedResult FT_W32_GetOverlappedResult;

DLL_FT_W32_ClearCommBreak FT_W32_ClearCommBreak;
DLL_FT_W32_ClearCommError FT_W32_ClearCommError;
DLL_FT_W32_EscapeCommFunction FT_W32_EscapeCommFunction;
DLL_FT_W32_GetCommModemStatus FT_W32_GetCommModemStatus;
DLL_FT_W32_GetCommState FT_W32_GetCommState;
DLL_FT_W32_GetCommTimeouts FT_W32_GetCommTimeouts;
DLL_FT_W32_PurgeComm FT_W32_PurgeComm;
DLL_FT_W32_SetCommBreak FT_W32_SetCommBreak;
DLL_FT_W32_SetCommMask FT_W32_SetCommMask;
DLL_FT_W32_SetCommState FT_W32_SetCommState;
DLL_FT_W32_SetCommTimeouts FT_W32_SetCommTimeouts;
DLL_FT_W32_SetupComm FT_W32_SetupComm;
DLL_FT_W32_WaitCommEvent FT_W32_WaitCommEvent;

HINSTANCE ftdll=NULL;
FT_HANDLE fthandle=NULL;
FT_STATUS ftstatus;

//**********************************************************************************
void UnloadFTDLL() 
//**********************************************************************************
{
 if(ftdll) { FreeLibrary(ftdll); ftdll=NULL; }
}

//****************************************************************************************
// Loads Ftd2xx.dll. Returns nonzero if successfull, zero if not.
int LoadFTDLL()
//**********************************************************************************
{
 ftdll = LoadLibrary("Ftd2xx.dll");	
 if(ftdll == NULL)
  {
   MessageBox(NULL,"Error: Can't Load Ftd2xx.dll",NULL,MB_OK);
   return 0;
  }
 else
  {

   //Get dll function entrys by function name
   if(!(FT_Close = (DLL_FT_Close)GetProcAddress(ftdll,"FT_Close"))) return 0;
   if(!(FT_ListDevices = (DLL_FT_ListDevices)GetProcAddress(ftdll,"FT_ListDevices"))) return 0;
   if(!(FT_Open = (DLL_FT_Open)GetProcAddress(ftdll,"FT_Open"))) return 0;
   if(!(FT_OpenEx = (DLL_FT_OpenEx)GetProcAddress(ftdll,"FT_OpenEx"))) return 0;
   if(!(FT_Read = (DLL_FT_Read)GetProcAddress(ftdll,"FT_Read"))) return 0;
   if(!(FT_Write = (DLL_FT_Write)GetProcAddress(ftdll,"FT_Write"))) return 0;
   if(!(FT_IoCtl = (DLL_FT_IoCtl)GetProcAddress(ftdll,"FT_IoCtl"))) return 0;
   if(!(FT_SetBaudRate = (DLL_FT_SetBaudRate)GetProcAddress(ftdll,"FT_SetBaudRate"))) return 0;
   if(!(FT_SetDivisor = (DLL_FT_SetDivisor)GetProcAddress(ftdll,"FT_SetDivisor"))) return 0;
   if(!(FT_SetDataCharacteristics = (DLL_FT_SetDataCharacteristics)GetProcAddress(ftdll,"FT_SetDataCharacteristics"))) return 0;
   if(!(FT_SetFlowControl = (DLL_FT_SetFlowControl)GetProcAddress(ftdll,"FT_SetFlowControl"))) return 0;
   if(!(FT_SetDtr = (DLL_FT_SetDtr)GetProcAddress(ftdll,"FT_SetDtr"))) return 0;
   if(!(FT_ClrDtr = (DLL_FT_ClrDtr)GetProcAddress(ftdll,"FT_ClrDtr"))) return 0;
   if(!(FT_SetRts = (DLL_FT_SetRts)GetProcAddress(ftdll,"FT_SetRts"))) return 0;
   if(!(FT_ClrRts = (DLL_FT_ClrRts)GetProcAddress(ftdll,"FT_ClrRts"))) return 0;
   if(!(FT_GetModemStatus = (DLL_FT_GetModemStatus)GetProcAddress(ftdll,"FT_GetModemStatus"))) return 0;
   if(!(FT_SetChars = (DLL_FT_SetChars)GetProcAddress(ftdll,"FT_SetChars"))) return 0;
   if(!(FT_Purge = (DLL_FT_Purge)GetProcAddress(ftdll,"FT_Purge"))) return 0;
   if(!(FT_SetTimeouts = (DLL_FT_SetTimeouts)GetProcAddress(ftdll,"FT_SetTimeouts"))) return 0;
   if(!(FT_GetQueueStatus = (DLL_FT_GetQueueStatus)GetProcAddress(ftdll,"FT_GetQueueStatus"))) return 0;
   if(!(FT_SetEventNotification = (DLL_FT_SetEventNotification)GetProcAddress(ftdll,"FT_SetEventNotification"))) return 0;
   if(!(FT_GetStatus = (DLL_FT_GetStatus)GetProcAddress(ftdll,"FT_GetStatus"))) return 0;
   if(!(FT_SetBreakOn = (DLL_FT_SetBreakOn)GetProcAddress(ftdll,"FT_SetBreakOn"))) return 0;
   if(!(FT_SetBreakOff = (DLL_FT_SetBreakOff)GetProcAddress(ftdll,"FT_SetBreakOff"))) return 0;
   if(!(FT_SetWaitMask = (DLL_FT_SetWaitMask)GetProcAddress(ftdll,"FT_SetWaitMask"))) return 0;
   if(!(FT_WaitOnMask = (DLL_FT_WaitOnMask)GetProcAddress(ftdll,"FT_WaitOnMask"))) return 0;
   if(!(FT_GetEventStatus = (DLL_FT_GetEventStatus)GetProcAddress(ftdll,"FT_GetEventStatus"))) return 0;
   if(!(FT_ResetDevice = (DLL_FT_ResetDevice)GetProcAddress(ftdll,"FT_ResetDevice"))) return 0;


   if(!(FT_EE_Read = (DLL_FT_EE_Read)GetProcAddress(ftdll,"FT_EE_Read"))) return 0;
   if(!(FT_ReadEE = (DLL_FT_ReadEE)GetProcAddress(ftdll,"FT_ReadEE"))) return 0;
   if(!(FT_WriteEE = (DLL_FT_WriteEE)GetProcAddress(ftdll,"FT_WriteEE"))) return 0;
   if(!(FT_EraseEE = (DLL_FT_EraseEE)GetProcAddress(ftdll,"FT_EraseEE"))) return 0;
   if(!(FT_EE_Program = (DLL_FT_EE_Program)GetProcAddress(ftdll,"FT_EE_Program"))) return 0;
   if(!(FT_EE_UASize = (DLL_FT_EE_UASize)GetProcAddress(ftdll,"FT_EE_UASize"))) return 0;
   if(!(FT_EE_UAWrite = (DLL_FT_EE_UAWrite)GetProcAddress(ftdll,"FT_EE_UAWrite"))) return 0;
   if(!(FT_EE_UARead = (DLL_FT_EE_UARead)GetProcAddress(ftdll,"FT_EE_UARead"))) return 0;

   if(!(FT_SetLatencyTimer = (DLL_FT_SetLatencyTimer)GetProcAddress(ftdll,"FT_SetLatencyTimer"))) return 0;
   if(!(FT_GetLatencyTimer = (DLL_FT_GetLatencyTimer)GetProcAddress(ftdll,"FT_GetLatencyTimer"))) return 0;
   if(!(FT_SetBitMode = (DLL_FT_SetBitMode)GetProcAddress(ftdll,"FT_SetBitMode"))) return 0;
   if(!(FT_GetBitMode = (DLL_FT_GetBitMode)GetProcAddress(ftdll,"FT_GetBitMode"))) return 0;
   if(!(FT_SetUSBParameters = (DLL_FT_SetUSBParameters)GetProcAddress(ftdll,"FT_SetUSBParameters"))) return 0;

//
// Win32-type functions
//
   if(!(FT_W32_CreateFile = (DLL_FT_W32_CreateFile)GetProcAddress(ftdll,"FT_W32_CreateFile"))) return 0;
   if(!(FT_W32_CloseHandle = (DLL_FT_W32_CloseHandle)GetProcAddress(ftdll,"FT_W32_CloseHandle"))) return 0;
   if(!(FT_W32_ReadFile = (DLL_FT_W32_ReadFile)GetProcAddress(ftdll,"FT_W32_ReadFile"))) return 0;
   if(!(FT_W32_WriteFile = (DLL_FT_W32_WriteFile)GetProcAddress(ftdll,"FT_W32_WriteFile"))) return 0;
   if(!(FT_W32_GetLastError = (DLL_FT_W32_GetLastError)GetProcAddress(ftdll,"FT_W32_GetLastError"))) return 0;
   if(!(FT_W32_GetOverlappedResult = (DLL_FT_W32_GetOverlappedResult)GetProcAddress(ftdll,"FT_W32_GetOverlappedResult"))) return 0;

//
// Win32 COMM API type functions
//
   if(!(FT_W32_ClearCommBreak = (DLL_FT_W32_ClearCommBreak)GetProcAddress(ftdll,"FT_W32_ClearCommBreak"))) return 0;
   if(!(FT_W32_ClearCommError = (DLL_FT_W32_ClearCommError)GetProcAddress(ftdll,"FT_W32_ClearCommError"))) return 0;
   if(!(FT_W32_EscapeCommFunction = (DLL_FT_W32_EscapeCommFunction)GetProcAddress(ftdll,"FT_W32_EscapeCommFunction"))) return 0;
   if(!(FT_W32_GetCommModemStatus = (DLL_FT_W32_GetCommModemStatus)GetProcAddress(ftdll,"FT_W32_GetCommModemStatus"))) return 0;
   if(!(FT_W32_GetCommState = (DLL_FT_W32_GetCommState)GetProcAddress(ftdll,"FT_W32_GetCommState"))) return 0;
   if(!(FT_W32_GetCommTimeouts = (DLL_FT_W32_GetCommTimeouts)GetProcAddress(ftdll,"FT_W32_GetCommTimeouts"))) return 0;
   if(!(FT_W32_PurgeComm = (DLL_FT_W32_PurgeComm)GetProcAddress(ftdll,"FT_W32_PurgeComm"))) return 0;
   if(!(FT_W32_SetCommBreak = (DLL_FT_W32_SetCommBreak)GetProcAddress(ftdll,"FT_W32_SetCommBreak"))) return 0;
   if(!(FT_W32_SetCommMask = (DLL_FT_W32_SetCommMask)GetProcAddress(ftdll,"FT_W32_SetCommMask"))) return 0;
   if(!(FT_W32_SetCommState = (DLL_FT_W32_SetCommState)GetProcAddress(ftdll,"FT_W32_SetCommState"))) return 0;
   if(!(FT_W32_SetCommTimeouts = (DLL_FT_W32_SetCommTimeouts)GetProcAddress(ftdll,"FT_W32_SetCommTimeouts"))) return 0;
   if(!(FT_W32_SetupComm = (DLL_FT_W32_SetupComm)GetProcAddress(ftdll,"FT_W32_SetupComm"))) return 0;
   if(!(FT_W32_WaitCommEvent = (DLL_FT_W32_WaitCommEvent)GetProcAddress(ftdll,"FT_W32_WaitCommEvent"))) return 0;

  }//if(ftdll == NULL)

 return 1;
}	

