//---------------------------------------------------------------------------
// USBTest1.cpp
//
// Meine erstes Programm mit USB :)
//
// Nur fr die FTDI Chips fr die der D2XX Treiber installiert wurde.
// Nicht fr die Chip die mit dem VCP Treiber installiert wurden.
//
// Listet alle gefundenen FT232 oder FT245 auf und zeigt
// einige Informationen aus dem EEPROM an. Das erfordert
// natrlich das auch eines angeschlossen und programmiert ist ;)
//
// Was passiert wenn kein EEPROM angeschlossen ist habe ich nie
// ausprobiert. Wre mal interessant.
//
// hk@holger-klabunde.de
// www.holger-klabunde.de
// 14.02.2003
//---------------------------------------------------------------------------

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <windows.h>

#include "ftd2xx.h"
#include "ftd2def.h"


void CleanUp();

//**********************************************************************************
int main(int argc, char *argv[])
//**********************************************************************************
{
 DWORD numDevs;
 DWORD i,j;
 char buffer[64];
 WORD eeword;

 FT_PROGRAM_DATA ftData;
 char ManufacturerBuf[32];
 char ManufacturerIdBuf[16];
 char DescriptionBuf[64];
 char SerialNumberBuf[16];
 ftData.Manufacturer = ManufacturerBuf;
 ftData.ManufacturerId = ManufacturerIdBuf;
 ftData.Description = DescriptionBuf;
 ftData.SerialNumber = SerialNumberBuf;

 if(LoadFTDLL())
  {
   if(FT_ListDevices(&numDevs,NULL,FT_LIST_NUMBER_ONLY)==FT_OK)
    {
     printf("Connected devices: %d\n\n",numDevs);

     for(i=0; i<numDevs; i++)
      {
       printf("Device: %d\n",i);

       if(FT_ListDevices((PVOID)i,buffer,FT_LIST_BY_INDEX|FT_OPEN_BY_DESCRIPTION)==FT_OK)
        {

         if(FT_OpenEx(buffer,FT_OPEN_BY_DESCRIPTION,&fthandle)==FT_OK)
          {

           if(FT_EE_Read(fthandle,&ftData)==FT_OK)
            {
             printf("VID 0x%04X PID 0x%04X\n"
                    "Manufacturer: %s  ID: %s\n"
                    "Description: %s\n"
                    "SerialNumber: %s\n"
                    "MaxPower: %d\n"
                    "Plug And Play: %d\n"
                    "SelfPowered: %d\n"
                    "RemoteWakeup: %d\n"
                    ,ftData.VendorId,ftData.ProductId
                    ,ftData.Manufacturer,ftData.ManufacturerId
                    ,ftData.Description
                    ,ftData.SerialNumber
                    ,ftData.MaxPower
                    ,ftData.PnP
                    ,ftData.SelfPowered
                    ,ftData.RemoteWakeup
//                    ,ftData.,ftData.

                   );

             if(ftData.Rev4) printf("Revision 4 Chip\n");
             else  printf("Revision < 4 Chip\n"); 

             if(ftData.IsoIn) printf("In endpoint is isochronous\n");
             else  printf("In endpoint is NOT isochronous\n"); 

             if(ftData.IsoOut) printf("Out endpoint is isochronous\n");
             else  printf("Out endpoint is NOT isochronous\n"); 

             if(ftData.PullDownEnable) printf("PullDownEnable is true\n");
             else  printf("PullDownEnable is false\n"); 

             if(ftData.SerNumEnable) printf("SerNumEnable is true\n");
             else  printf("SerNumEnable is false\n"); 

             if(ftData.USBVersionEnable) printf("USBVersionEnable is true\n");
             else  printf("USBVersionEnable is false\n"); 

             printf("USBVersion 0x%04X\n",ftData.USBVersion);
            }//if(FT_EE_Read(fthandle,&ftData)==FT_OK)

           printf("\n");

/* please don't do this ;)
if(i==0)
 {
  ftData.VendorId=0x0403; 
  ftData.ProductId=0x6200;
  ftData.Manufacturer="FTDI";
  ftData.ManufacturerId="FT";
  ftData.Description="USB HS Fifo 6200";
  ftData.SerialNumber="FT292BVW";
  ftData.MaxPower=98;
  ftData.PnP=1;
  ftData.SelfPowered=0;
  ftData.RemoteWakeup=1;
  ftData.Rev4=false;
  ftData.IsoIn=false;
  ftData.IsoOut=false;
  ftData.PullDownEnable=false;
  ftData.SerNumEnable=false;
  ftData.USBVersionEnable=false;
  ftData.USBVersion=0x0110;
  if(FT_EE_Program(fthandle,&ftData)==FT_OK)
   {
    printf("New EEPROM Data written");
   }
 }
*/
           DWORD UA_Size;
           ftstatus = FT_EE_UASize(fthandle,&UA_Size);
           if (ftstatus == FT_OK)
            {
             printf("Free User Application Memory in EEPROM %d Bytes\n",UA_Size);
            }
           else 
            { // FT_EE_UASize FAILED!
            }


           printf("Hexdump of EEPROM:\n");

           for(j=0; j<64; j++) //hex dump of EEPROM
            {
             ftstatus=FT_ReadEE(fthandle,j,&eeword);
             if(ftstatus==FT_OK)
              {
                if(j%8 == 0) printf("\n");
                printf("%02X %02X ",eeword&0xFF, eeword>>8 );
              }
             else
              {
              }
            }
           printf("\n");

           if(fthandle) FT_Close(fthandle);
           fthandle=NULL;
          }//if(FT_OpenEx(buffer,FT_OPEN_BY_DESCRIPTION,&fthandle)==FT_OK)


        }
      }//for(i=0; i<numDevs; i++)

    }//if(FT_ListDevices(&numDevs,NULL,FT_LIST_NUMBER_ONLY)==FT_OK)
   else
    {
     printf("No devices connected\n");
    }

  }

 CleanUp();
 UnloadFTDLL(); //Don't forget it
 return 0;
}

//**********************************************************************************
void CleanUp() 
//**********************************************************************************
{
 if(fthandle) { FT_Close(fthandle); fthandle=NULL; }
}
